/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.BlockDenseOre;
import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresRegistry;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class ModIntegration {
    public static final String[] canonOres = new String[]{"oreIron", "oreGold", "oreCopper", "oreTin", "oreSilver", "oreLead", "oreNickel", "orePlatinum"};
    public static final String[] canonSecondaryOres = new String[]{"oreNickel", null, "oreGold", "oreIron", "oreLead", "oreSilver", "orePlatinum", null};
    public static Random rand = new Random();
    public static ModInterface[] mods = new ModInterface[]{new VanillaFurnace(), new TE4Integration()};

    public static boolean isCanonOre(String ore) {
        for (String s : canonOres) {
            if (!s.equals(ore)) continue;
            return true;
        }
        return false;
    }

    public static String getSecondCanonOre(String ore) {
        for (int i = 0; i < canonOres.length; ++i) {
            if (!canonOres[i].equals(ore)) continue;
            return canonSecondaryOres[i];
        }
        return null;
    }

    public static NBTTagCompound getItemStackNBT(ItemStack item, int newStackSize) {
        NBTTagCompound tag = ModIntegration.getItemStackNBT(item);
        tag.func_74774_a("Count", (byte)newStackSize);
        return tag;
    }

    public static NBTTagCompound getItemStackNBT(ItemStack item) {
        NBTTagCompound tag = new NBTTagCompound();
        item.func_77955_b(tag);
        return tag;
    }

    public static ItemStack cloneStack(ItemStack item, int newStackSize) {
        ItemStack newitem = item.func_77946_l();
        newitem.field_77994_a = newStackSize;
        return newitem;
    }

    public static boolean isOreSmeltsToIngot(String oreDict) {
        if ("".equals(oreDict)) {
            return false;
        }
        String ingotName = "ingot" + oreDict.substring("ore".length());
        return !OreDictionary.getOres((String)ingotName).isEmpty();
    }

    public static ItemStack getSmeltedIngot(String oreDict, String preferredModOwner) {
        if ("".equals(oreDict)) {
            return null;
        }
        String ingotName = "ingot" + oreDict.substring("ore".length());
        ItemStack out = null;
        Iterator i$ = OreDictionary.getOres((String)ingotName).iterator();
        while (i$.hasNext()) {
            ItemStack ingot;
            out = ingot = (ItemStack)i$.next();
            String s = GameData.getItemRegistry().func_148750_c((Object)ingot.func_77973_b());
            if (preferredModOwner == null || !preferredModOwner.equals(s.substring(0, s.indexOf(58)))) continue;
            return out;
        }
        return out;
    }

    public static ItemStack getFurnace(DenseOre toSmelt, float multiplier) {
        ItemStack out = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt.newStack(1));
        if (out == null && ModIntegration.isOreSmeltsToIngot(toSmelt.baseOreDictionary)) {
            out = ModIntegration.getSmeltedIngot(toSmelt.baseOreDictionary, toSmelt.modOwner);
        }
        if (out != null) {
            out = out.func_77946_l();
            if ("minecraft:lapis_ore".equals(toSmelt.baseBlock)) {
                out.field_77994_a = 6;
            } else if ("minecraft:redstone_ore".equals(toSmelt.baseBlock)) {
                out.field_77994_a = 4;
            }
            out.field_77994_a = (int)((float)out.field_77994_a * multiplier);
            if (out.field_77994_a > 64) {
                out.field_77994_a = 64;
            } else if (out.field_77994_a < 1) {
                out.field_77994_a = 1;
            }
        }
        return out;
    }

    public static void addModIntegration() {
        for (DenseOre ore : DenseOresRegistry.ores.values()) {
            int bId = ore.id / 16;
            int meta = ore.id % 16;
            BlockDenseOre blockDenseOre = DenseOresRegistry.blocks.get(bId);
            if (!blockDenseOre.isValid(meta)) continue;
            ItemStack output = new ItemStack(blockDenseOre.getBlock(meta), 1, ore.metadata);
            ItemStack input = new ItemStack((Block)blockDenseOre, 1, meta);
            for (ModInterface mod : mods) {
                mod.registerOre(ore, input, output);
            }
        }
    }

    public static class TE4Integration
    implements ModInterface {
        @Override
        public void registerOre(DenseOre ore, ItemStack input, ItemStack output) {
            this.addPulverizer(input, output);
            if (ModIntegration.isCanonOre(ore.baseOreDictionary) && ModIntegration.getFurnace(ore, 1.0f) != null) {
                ItemStack slag = GameRegistry.findItemStack((String)"ThermalExpansion", (String)"slagRich", (int)1);
                String s = ModIntegration.getSecondCanonOre(ore.baseOreDictionary);
                if (s != null && ModIntegration.getSmeltedIngot(s, ore.modOwner) != null) {
                    slag = ModIntegration.cloneStack(ModIntegration.getSmeltedIngot(s, ore.modOwner), 3);
                }
                this.addSmelter(input, new ItemStack((Block)Blocks.field_150354_m, 4), ModIntegration.getFurnace(ore, 8.0f), slag, 25);
                this.addSmelter(input, GameRegistry.findItemStack((String)"ThermalFoundation", (String)"dustPyrotheum", (int)2), ModIntegration.getFurnace(ore, 8.0f), slag, 75);
                this.addSmelter(input, GameRegistry.findItemStack((String)"ThermalFoundation", (String)"crystalCinnabar", (int)2), ModIntegration.getFurnace(ore, 16.0f), slag, 100);
            }
        }

        private void addSmelter(ItemStack a, ItemStack b, ItemStack output, ItemStack altOutput, int prob) {
            if (a == null || b == null || output == null) {
                return;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("energy", 16000);
            tag.func_74782_a("primaryInput", (NBTBase)ModIntegration.getItemStackNBT(a));
            tag.func_74782_a("secondaryInput", (NBTBase)ModIntegration.getItemStackNBT(b));
            tag.func_74782_a("primaryOutput", (NBTBase)ModIntegration.getItemStackNBT(output));
            if (altOutput != null) {
                tag.func_74782_a("secondaryOutput", (NBTBase)ModIntegration.getItemStackNBT(altOutput));
                tag.func_74768_a("secondaryChance", prob);
            }
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterRecipe", (NBTTagCompound)tag);
        }

        private void addPulverizer(ItemStack input, ItemStack output) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("energy", 8000);
            tag.func_74782_a("input", (NBTBase)ModIntegration.getItemStackNBT(input));
            tag.func_74782_a("primaryOutput", (NBTBase)ModIntegration.getItemStackNBT(output, 4));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"PulverizerRecipe", (NBTTagCompound)tag);
        }
    }

    public static class VanillaFurnace
    implements ModInterface {
        @Override
        public void registerOre(DenseOre ore, ItemStack input, ItemStack output) {
            ItemStack out = ModIntegration.getFurnace(ore, 3.0f);
            if (out != null) {
                GameRegistry.addSmelting((ItemStack)input, (ItemStack)out, (float)1.0f);
            }
        }
    }

    public static interface ModInterface {
        public void registerOre(DenseOre var1, ItemStack var2, ItemStack var3);
    }
}

