/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.util;

import cpw.mods.fml.common.FMLCommonHandler;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import tterrag.core.TTCore;
import tterrag.core.common.util.TTFileUtils;

public class ResourcePackAssembler {
    private List<File> icons = new ArrayList<File>();
    private List<File> langs = new ArrayList<File>();
    private List<CustomFile> customs = new ArrayList<CustomFile>();
    private static final String MC_META_BASE = "{\"pack\":{\"pack_format\":1,\"description\":\"%s\"}}";
    private File dir;
    private String name;
    private String mcmeta;
    private String modid;
    private boolean hasPackPng = false;
    private Class<?> jarClass;

    public ResourcePackAssembler(File directory, String packName, String modid) {
        this.dir = directory;
        this.name = packName;
        this.modid = modid.toLowerCase();
        this.mcmeta = String.format(MC_META_BASE, this.name);
    }

    public ResourcePackAssembler setHasPackPng(Class<?> jarClass) {
        this.jarClass = jarClass;
        this.hasPackPng = true;
        return this;
    }

    public void addIcon(File icon) {
        this.icons.add(icon);
    }

    public void addLang(File lang) {
        this.langs.add(lang);
    }

    public void addCustomFile(String path, File file) {
        this.customs.add(new CustomFile(path, file));
    }

    public void addCustomFile(File file) {
        this.addCustomFile(null, file);
    }

    public ResourcePackAssembler assemble() {
        String pathToDir = this.dir.getAbsolutePath();
        File mcmeta = new File(pathToDir + "/pack.mcmeta");
        try {
            this.writeDefaultMcmeta(mcmeta);
            if (this.hasPackPng) {
                TTFileUtils.copyFromJar(this.jarClass, this.modid + "/" + "pack.png", new File(this.dir.getAbsolutePath() + "/pack.png"));
            }
            String itemsDir = pathToDir + "/assets/" + this.modid + "/textures/items";
            String blocksDir = pathToDir + "/assets/" + this.modid + "/textures/blocks";
            String langDir = pathToDir + "/assets/" + this.modid + "/lang";
            for (File icon : this.icons) {
                FileUtils.copyFile((File)icon, (File)new File(itemsDir + "/" + icon.getName()));
                FileUtils.copyFile((File)icon, (File)new File(blocksDir + "/" + icon.getName()));
            }
            for (File lang : this.langs) {
                FileUtils.copyFile((File)lang, (File)new File(langDir + "/" + lang.getName()));
            }
            for (CustomFile custom : this.customs) {
                File directory = new File(pathToDir + (custom.ext != null ? "/" + custom.ext : ""));
                directory.mkdirs();
                FileUtils.copyFile((File)custom.file, (File)new File(directory.getAbsolutePath() + "/" + custom.file.getName()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void inject() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            File dest = new File(FMLCommonHandler.instance().getSavesDirectory().getParentFile() + "/resourcepacks/" + this.dir.getName());
            try {
                TTFileUtils.safeDeleteDirectory(dest);
                FileUtils.copyDirectory((File)this.dir, (File)dest);
                TTFileUtils.safeDeleteDirectory(this.dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            TTCore.logger.info("Skipping resource pack, we are on a dedicated server.");
        }
    }

    private void writeDefaultMcmeta(File file) throws IOException {
        TTFileUtils.safeDelete(file);
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileWriter fw = new FileWriter(file);
        fw.write(this.mcmeta);
        fw.flush();
        fw.close();
    }

    private class CustomFile {
        private String ext;
        private File file;

        @ConstructorProperties(value={"ext", "file"})
        public CustomFile(String ext, File file) {
            this.ext = ext;
            this.file = file;
        }
    }
}

