/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.handlers;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import tterrag.core.common.Handlers;
import tterrag.core.common.enchant.EnchantXPBoost;
import tterrag.core.common.util.Scheduler;

@Handlers.Handler(value={Handlers.Handler.HandlerType.FORGE})
public class XPBoostHandler {
    private static final Method getExperiencePoints = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"e", "func_70693_a", "getExperiencePoints"}, (Class[])new Class[]{EntityPlayer.class});
    private static final String NBT_KEY = "ttCore:xpboost";

    @SubscribeEvent
    public void handleEntityKill(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        Entity killer = event.source.func_76364_f();
        if (!entity.field_70170_p.field_72995_K && killer != null) {
            NBTTagCompound tag;
            if (killer instanceof EntityPlayer) {
                this.scheduleXP((Entity)entity, this.getXPBoost(entity, (EntityPlayer)killer));
            } else if (killer instanceof EntityArrow && (tag = killer.getEntityData()).func_74764_b(NBT_KEY) && tag.func_74762_e(NBT_KEY) >= 0) {
                int level = tag.func_74762_e(NBT_KEY);
                this.scheduleXP((Entity)entity, this.getXPBoost(entity, (EntityPlayer)((EntityArrow)killer).field_70250_c, level));
            }
        }
    }

    @SubscribeEvent
    public void handleArrowFire(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityArrow) {
            EntityArrow arrow = (EntityArrow)event.entity;
            if (arrow.field_70250_c != null && arrow.field_70250_c instanceof EntityPlayer) {
                arrow.getEntityData().func_74768_a(NBT_KEY, this.getXPBoostLevel(((EntityPlayer)arrow.field_70250_c).func_71045_bC()));
            }
        }
    }

    @SubscribeEvent
    public void handleBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack held = event.getPlayer().func_71045_bC();
        if (held != null) {
            int xp;
            int level = this.getXPBoostLevel(held);
            int fortune = EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)held);
            if (level >= 0 && (xp = event.block.getExpDrop((IBlockAccess)event.world, event.blockMetadata, fortune)) > 0) {
                event.world.func_72838_d((Entity)new EntityXPOrb(event.world, (double)event.x + 0.5, (double)event.y + 0.5, (double)event.z + 0.5, this.getXPBoost(xp, level)));
            }
        }
    }

    private int getXPBoost(EntityLivingBase killed, EntityPlayer player) {
        return this.getXPBoost(killed, player, this.getXPBoostLevel(player.func_71045_bC()));
    }

    private int getXPBoost(EntityLivingBase killed, EntityPlayer player, int level) {
        int boost = 0;
        ItemStack weapon = player.func_71045_bC();
        if (weapon != null && level >= 0) {
            int xp = (Integer)getExperiencePoints.invoke((Object)killed, player);
            return this.getXPBoost(xp, level);
        }
        return boost;
    }

    private int getXPBoost(int xp, int level) {
        return Math.round((float)xp * ((float)Math.log10(level + 1) * 2.0f));
    }

    private int getXPBoostLevel(ItemStack weapon) {
        if (weapon == null) {
            return -1;
        }
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)weapon);
        Iterator i$ = enchants.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            Enchantment enchant = Enchantment.field_77331_b[i];
            if (enchant != EnchantXPBoost.INSTANCE) continue;
            return (Integer)enchants.get(i);
        }
        return -1;
    }

    private void scheduleXP(Entity entity, int boost) {
        this.scheduleXP(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, boost);
    }

    private void scheduleXP(final World world, final double x, final double y, final double z, final int boost) {
        if (boost <= 0) {
            return;
        }
        Scheduler.instance().schedule(20, new Runnable(){

            @Override
            public void run() {
                world.func_72838_d((Entity)new EntityXPOrb(world, x, y, z, boost));
            }
        });
    }
}

