/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.config;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import tterrag.core.TTCore;
import tterrag.core.common.Handlers;
import tterrag.core.common.config.AbstractConfigHandler;
import tterrag.core.common.config.ITweakConfigHandler;
import tterrag.core.common.tweaks.Tweak;
import tterrag.core.common.tweaks.Tweaks;

@Handlers.Handler(value={Handlers.Handler.HandlerType.FML})
public class ConfigHandler
extends AbstractConfigHandler
implements ITweakConfigHandler {
    public static boolean showOredictTooltips = false;
    public static boolean extraDebugStuff = true;
    public static int disableVoidFog = 1;
    public static int anvilMaxLevel = 40;
    public static boolean betterAchievements = true;
    public static boolean allowCropRC = true;
    private static String[] supportedCrops = new String[]{"minecraft:wheat", "minecraft:potatoes", "minecraft:carrots"};
    public static int enchantIDXPBoost = 43;
    public static boolean allowXPBoost = true;
    private static List<Block> rightClickCrops = ImmutableList.of();
    public static final ConfigHandler INSTANCE = new ConfigHandler();

    protected ConfigHandler() {
        super("ttCore");
    }

    @Override
    public void init() {
        this.addSection("general");
        this.addSection("enchants");
        this.addSection("tweaks");
    }

    @Override
    protected void reloadIngameConfigs() {
        this.activateSection("general");
        showOredictTooltips = this.getValue("showOredictTooltips", "Show oredictionary names of every item in its tooltip.", showOredictTooltips);
        extraDebugStuff = this.getValue("extraDebugStuff", "Show item registry names and other things in debug mode (f3+h)", extraDebugStuff);
        disableVoidFog = this.getValue("disableVoidFog", "Removes all void fog.\n0 = off\n1 = DEFAULT worldtype only\n2 = all world types", disableVoidFog);
        anvilMaxLevel = this.getValue("anvilMaxLevel", "The max amount of XP levels an anvil recipe can use", anvilMaxLevel);
        betterAchievements = this.getValue("superDuperFunMode", "The way the game should have been made.", betterAchievements);
        supportedCrops = this.getValue("supportedCrops", "Crop blocks to attempt to enable right-click harvesting on. This may or may not work for mod crops, depending on their implementation.", supportedCrops);
        Tweaks.loadIngameTweaks();
    }

    @Override
    protected void reloadNonIngameConfigs() {
        this.activateSection("enchants");
        enchantIDXPBoost = this.getValue("enchantIDXPBoost", "Enchant ID for the XP boost enchant.", enchantIDXPBoost);
        allowXPBoost = this.getValue("allowXPBoost", "Allow the XP Boost enchant to be registered.", allowXPBoost);
        Tweaks.loadNonIngameTweaks();
    }

    @Override
    public boolean addBooleanFor(Tweak tweak) {
        this.activateSection("tweaks");
        return this.getValue(tweak.getName(), tweak.getComment(), true);
    }

    public void loadRightClickCrops() {
        ArrayList<Block> baking = new ArrayList<Block>();
        for (String s : supportedCrops) {
            Block block = (Block)Block.field_149771_c.func_82594_a(s);
            if (block == null) {
                TTCore.logger.error("Block %s not found for right clickable crops.", new Object[]{s});
                continue;
            }
            baking.add(block);
        }
        rightClickCrops = ImmutableList.copyOf(baking);
    }

    public static List<Block> getRightClickCrops() {
        return rightClickCrops;
    }
}

