/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.config;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import tterrag.core.TTCore;
import tterrag.core.api.common.config.IConfigHandler;
import tterrag.core.common.event.ConfigFileChangedEvent;

public abstract class AbstractConfigHandler
implements IConfigHandler {
    private String modid;
    private Configuration config;
    private List<Section> sections = new ArrayList<Section>();
    private Section activeSection = null;

    protected AbstractConfigHandler(String modid) {
        this.modid = modid;
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public final void initialize(File cfg) {
        this.config = new Configuration(cfg);
        this.init();
        this.reloadAllConfigs();
        this.saveConfigFile();
    }

    protected void loadConfigFile() {
        this.config.load();
    }

    protected void saveConfigFile() {
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(this.modid)) {
            TTCore.logger.info("Reloading all configs for modid: " + this.modid);
            this.reloadAllConfigs();
            this.saveConfigFile();
        }
    }

    @SubscribeEvent
    public void onConfigFileChanged(ConfigFileChangedEvent event) {
        if (event.modID.equals(this.modid)) {
            TTCore.logger.info("Reloading ingame configs for modid: " + this.modid);
            this.loadConfigFile();
            this.reloadIngameConfigs();
            event.setSuccessful();
            this.saveConfigFile();
        }
    }

    private void reloadAllConfigs() {
        this.reloadNonIngameConfigs();
        this.reloadIngameConfigs();
    }

    protected abstract void init();

    protected abstract void reloadNonIngameConfigs();

    protected abstract void reloadIngameConfigs();

    protected Section addSection(String sectionName) {
        return this.addSection(sectionName, sectionName, null);
    }

    protected Section addSection(String sectionName, String langKey) {
        return this.addSection(sectionName, langKey, null);
    }

    protected Section addSection(String sectionName, String langKey, String comment) {
        Section section = new Section(sectionName, langKey);
        if (this.activeSection == null && this.sections.isEmpty()) {
            this.activeSection = section;
        }
        if (comment != null) {
            this.config.addCustomCategoryComment(sectionName, comment);
        }
        return section.register();
    }

    private void checkInitialized() {
        if (this.activeSection == null) {
            throw new IllegalStateException("No section is active!");
        }
    }

    protected void activateSection(@NonNull String sectionName) {
        if (sectionName == null) {
            throw new NullPointerException("sectionName");
        }
        Section section = this.getSectionByName(sectionName);
        if (section == null) {
            throw new IllegalArgumentException("Section " + sectionName + " does not exist!");
        }
        this.activateSection(section);
    }

    protected void activateSection(@NonNull Section section) {
        if (section == null) {
            throw new NullPointerException("section");
        }
        this.activeSection = section;
    }

    protected Section getSectionByName(@NonNull String sectionName) {
        if (sectionName == null) {
            throw new NullPointerException("sectionName");
        }
        for (Section s : this.sections) {
            if (!s.name.equalsIgnoreCase(sectionName)) continue;
            return s;
        }
        return null;
    }

    protected <T> T getValue(String key, T defaultVal) {
        return this.getValue(key, defaultVal, RestartReqs.NONE);
    }

    protected <T> T getValue(String key, T defaultVal, RestartReqs req) {
        return this.getValue(key, null, defaultVal, req);
    }

    protected <T> T getValue(String key, T defaultVal, Bound<T> bound) {
        return this.getValue(key, null, defaultVal, bound);
    }

    protected <T> T getValue(String key, String comment, T defaultVal) {
        return this.getValue(key, comment, defaultVal, RestartReqs.NONE);
    }

    protected <T> T getValue(String key, String comment, T defaultVal, RestartReqs req) {
        return this.getValue(key, comment, defaultVal, req, null);
    }

    protected <T> T getValue(String key, String comment, T defaultVal, Bound<T> bound) {
        return this.getValue(key, comment, defaultVal, RestartReqs.NONE, bound);
    }

    protected <T> T getValue(String key, String comment, T defaultVal, RestartReqs req, Bound<T> bound) {
        Property prop = this.getProperty(key, defaultVal, req);
        prop.comment = comment;
        return this.getValue(prop, defaultVal, bound);
    }

    protected <T> T getValue(Property prop, T defaultVal) {
        return this.getValue(prop, defaultVal, null);
    }

    protected <T> T getValue(Property prop, T defaultVal, Bound<T> bound) {
        this.checkInitialized();
        if (bound != null) {
            this.setBounds(prop, bound);
        }
        if (defaultVal instanceof Integer) {
            return (T)Integer.valueOf(prop.getInt());
        }
        if (defaultVal instanceof Boolean) {
            return (T)Boolean.valueOf(prop.getBoolean());
        }
        if (defaultVal instanceof int[]) {
            return (T)prop.getIntList();
        }
        if (defaultVal instanceof String) {
            return (T)prop.getString();
        }
        if (defaultVal instanceof String[]) {
            return (T)prop.getStringList();
        }
        if (defaultVal instanceof Float || defaultVal instanceof Double) {
            double d = prop.getDouble();
            if (defaultVal instanceof Float) {
                return (T)Float.valueOf((float)d);
            }
            return (T)Double.valueOf(d);
        }
        throw new IllegalArgumentException("default value is not a config value type.");
    }

    private void setBounds(Property prop, Bound<?> bound) {
        if (((Bound)bound).min instanceof Integer) {
            prop.setMinValue(((Integer)((Bound)bound).min).intValue());
            prop.setMaxValue(((Integer)((Bound)bound).max).intValue());
        } else if (((Bound)bound).min instanceof Double || ((Bound)bound).min instanceof Float) {
            double max;
            double min;
            if (((Bound)bound).min instanceof Float) {
                min = ((Float)((Bound)bound).min).doubleValue();
                max = ((Float)((Bound)bound).max).doubleValue();
            } else {
                min = (Double)((Bound)bound).min;
                max = (Double)((Bound)bound).max;
            }
            prop.setMinValue(min);
            prop.setMaxValue(max);
        } else {
            TTCore.logger.warn("A mod tried to set bounds on a property that was not either of Integer of Double type.");
            TTCore.logger.warn("Trace :" + Arrays.toString(Thread.currentThread().getStackTrace()));
        }
    }

    protected <T> Property getProperty(String key, T defaultVal) {
        return this.getProperty(key, defaultVal, RestartReqs.NONE);
    }

    protected <T> Property getProperty(String key, T defaultVal, RestartReqs req) {
        this.checkInitialized();
        Section section = this.activeSection;
        Property prop = null;
        if (defaultVal instanceof Integer) {
            prop = this.config.get(section.name, key, ((Integer)defaultVal).intValue());
        }
        if (defaultVal instanceof Boolean) {
            prop = this.config.get(section.name, key, ((Boolean)defaultVal).booleanValue());
        }
        if (defaultVal instanceof int[]) {
            prop = this.config.get(section.name, key, (int[])defaultVal);
        }
        if (defaultVal instanceof String) {
            prop = this.config.get(section.name, key, (String)defaultVal);
        }
        if (defaultVal instanceof String[]) {
            prop = this.config.get(section.name, key, (String[])defaultVal);
        }
        if (defaultVal instanceof Float || defaultVal instanceof Double) {
            double val = defaultVal instanceof Float ? ((Float)defaultVal).doubleValue() : ((Double)defaultVal).doubleValue();
            prop = this.config.get(section.name, key, val);
        }
        if (prop != null) {
            return req.apply(prop);
        }
        throw new IllegalArgumentException("default value is not a config value type.");
    }

    @Override
    public final List<Section> getSections() {
        return ImmutableList.copyOf(this.sections);
    }

    @Override
    public final ConfigCategory getCategory(String name) {
        return this.config.getCategory(name);
    }

    @Override
    public final String getModID() {
        return this.modid;
    }

    public static class Bound<T> {
        private T min;
        private T max;

        private Bound(T min, T max) {
            this.min = min;
            this.max = max;
        }

        public static <T> Bound<T> of(T min, T max) {
            return new Bound<T>(min, max);
        }
    }

    public static enum RestartReqs {
        NONE,
        REQUIRES_WORLD_RESTART,
        REQUIRES_MC_RESTART;


        public Property apply(Property prop) {
            if (this == REQUIRES_MC_RESTART) {
                prop.setRequiresMcRestart(true);
            } else if (this == REQUIRES_WORLD_RESTART) {
                prop.setRequiresWorldRestart(true);
            }
            return prop;
        }
    }

    public class Section {
        public final String name;
        public final String lang;

        public Section(String name, String lang) {
            this.name = name;
            this.lang = "section." + lang;
        }

        private Section register() {
            AbstractConfigHandler.this.sections.add(this);
            return this;
        }

        public String lc() {
            return this.name.toLowerCase();
        }
    }
}

