/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.common.network;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import kihira.tails.common.PartsData;
import kihira.tails.common.Tails;
import net.minecraft.client.Minecraft;

public class PlayerDataMapMessage
implements IMessage {
    private Map<UUID, PartsData> partsDataMap;

    public PlayerDataMapMessage() {
    }

    public PlayerDataMapMessage(Map partsDataMap) {
        this.partsDataMap = partsDataMap;
    }

    public void fromBytes(ByteBuf buf) {
        String tailInfoJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        try {
            this.partsDataMap = (Map)new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().fromJson(tailInfoJson, new TypeToken<Map<UUID, PartsData>>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            Tails.logger.catching((Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        String tailInfoJson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create().toJson(this.partsDataMap);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)tailInfoJson);
    }

    public static class Handler
    implements IMessageHandler<PlayerDataMapMessage, IMessage> {
        public IMessage onMessage(PlayerDataMapMessage message, MessageContext ctx) {
            for (Map.Entry entry : message.partsDataMap.entrySet()) {
                if (Minecraft.func_71410_x().field_71439_g.getPersistentID() == entry.getKey()) continue;
                Tails.proxy.addPartsData((UUID)entry.getKey(), (PartsData)entry.getValue());
            }
            return null;
        }
    }
}

