/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.common;

import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Desktop;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.StatCollector;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FoxLibManager {
    public static final String foxlibVersion = "1.7.10-0.6.0";
    public static final String foxlibReqVersion = "[1.7.10-0.6.0,)";
    public static final String foxlibFileName = "FoxLib-1.7.10-0.6.0.jar";
    public static final String foxlibDownloadLink = "http://maven.kihirakreations.co.uk/kihira/FoxLib/1.7.10-0.6.0/FoxLib-1.7.10-0.6.0.jar";
    public static final String foxlibDownloadFallback = "http://minecraft.curseforge.com/mc-mods/223291-foxlib/files";
    public static final Logger logger = LogManager.getLogger((String)"FoxLib Manager");
    @SidedProxy(serverSide="kihira.tails.common.FoxLibManager$CommonProxy", clientSide="kihira.tails.common.FoxLibManager$ClientProxy")
    public static CommonProxy proxy;
    public static boolean outdated;
    long totalSize;

    public static boolean checkFoxlib() {
        if (!FoxLibManager.isFoxlibInstalled()) {
            logger.error("FoxLib is not installed!");
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                FMLCommonHandler.instance().bus().register((Object)new FoxLibManager());
            } else {
                String s = StatCollector.func_74837_a((String)"foxlib.downloader.missing", (Object[])new Object[]{"Tails", foxlibDownloadFallback});
                FMLLog.bigWarning((String)s, (Object[])new Object[0]);
                FMLCommonHandler.instance().getSidedDelegate().haltGame(s, null);
            }
        } else if (!FoxLibManager.isFoxlibCorrectVersion()) {
            logger.error("FoxLib is not the correct version! Expected 1.7.10-0.6.0 got " + ((ModContainer)Loader.instance().getIndexedModList().get("foxlib")).getDisplayVersion());
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                outdated = true;
                FMLCommonHandler.instance().bus().register((Object)new FoxLibManager());
            } else {
                String s = StatCollector.func_74837_a((String)"foxlib.downloader.outofdate", (Object[])new Object[]{foxlibDownloadFallback});
                FMLLog.bigWarning((String)s, (Object[])new Object[0]);
                FMLCommonHandler.instance().getSidedDelegate().haltGame(s, null);
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean isFoxlibInstalled() {
        return Loader.isModLoaded((String)"foxlib");
    }

    public static boolean isFoxlibCorrectVersion() {
        try {
            byte[] bs = Launch.classLoader.getClassBytes("net.minecraft.world.World");
            if (bs != null) {
                logger.warn("We are in a dev environment, skipping version check");
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println(((ModContainer)Loader.instance().getIndexedModList().get("foxlib")).getProcessedVersion().getVersionString());
        return VersionParser.parseRange((String)foxlibReqVersion).containsVersion(((ModContainer)Loader.instance().getIndexedModList().get("foxlib")).getProcessedVersion());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent e) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiMainMenu) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                public void func_73878_a(boolean yesButton, int screenID) {
                    if (yesButton) {
                        if (outdated) {
                            FoxLibManager.this.deleteOldVersions();
                        }
                        FoxLibManager.this.downloadFoxlib();
                    } else {
                        if (outdated) {
                            proxy.throwFoxlibError();
                        } else {
                            FMLLog.bigWarning((String)"foxlib.downloader.missing", (Object[])new Object[]{FoxLibManager.foxlibDownloadFallback});
                        }
                        Minecraft.func_71410_x().func_71400_g();
                    }
                }
            }, outdated ? I18n.func_135052_a((String)"foxlib.downloader.2", (Object[])new Object[]{"Tails"}) : I18n.func_135052_a((String)"foxlib.downloader.0", (Object[])new Object[]{"Tails"}), outdated ? I18n.func_135052_a((String)"foxlib.downloader.3", (Object[])new Object[]{"Tails"}) : I18n.func_135052_a((String)"foxlib.downloader.1", (Object[])new Object[0]), 0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void downloadFoxlib() {
        final GuiScreenWorking screenWorking = new GuiScreenWorking();
        Minecraft.func_71410_x().func_147108_a((GuiScreen)screenWorking);
        Thread downloadThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block5: {
                    screenWorking.func_73721_b(I18n.func_135052_a((String)"foxlib.downloader.downloading", (Object[])new Object[0]));
                    screenWorking.func_73719_c("Starting...");
                    FileOutputStream output = null;
                    InputStream input = null;
                    try {
                        File target = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "mods" + File.separator + FoxLibManager.foxlibFileName);
                        URL download = new URL(FoxLibManager.foxlibDownloadLink);
                        output = new FileOutputStream(target);
                        input = download.openStream();
                        DownloadCountingOutputStream countingOutputStream = new DownloadCountingOutputStream(output, (IProgressUpdate)screenWorking);
                        FoxLibManager.this.totalSize = Long.valueOf(download.openConnection().getHeaderField("Content-Length"));
                        screenWorking.func_73720_a(String.format("Downloading file (%.3f MB)...", Float.valueOf((float)FoxLibManager.this.totalSize / 1000000.0f)));
                        IOUtils.copy((InputStream)input, (OutputStream)((Object)countingOutputStream));
                        IOUtils.closeQuietly((OutputStream)output);
                    }
                    catch (IOException e) {
                        new File(Minecraft.func_71410_x().field_71412_D + File.separator + "mods" + File.separator + FoxLibManager.foxlibFileName).deleteOnExit();
                        e.printStackTrace();
                        proxy.showFailedScreen();
                        break block5;
                    }
                    finally {
                        IOUtils.closeQuietly(output);
                        IOUtils.closeQuietly(input);
                    }
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
        }, "FoxLib Downloader");
        downloadThread.setDaemon(true);
        downloadThread.start();
    }

    private void deleteOldVersions() {
        File modsFolder = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "mods");
        File[] files = modsFolder.listFiles((FileFilter)new WildcardFileFilter("*FoxLib*.jar", IOCase.INSENSITIVE));
        if (files != null) {
            for (File file : files) {
                if (!file.exists()) continue;
                logger.info("Deleting file " + file.toString() + " on exit");
                file.deleteOnExit();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientProxy
    extends CommonProxy {
        @Override
        public void throwFoxlibError() {
            throw new CustomModLoadingErrorDisplayException(){

                public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
                    try {
                        Desktop.getDesktop().browse(URI.create(FoxLibManager.foxlibDownloadFallback));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
                    String s = I18n.func_135052_a((String)"foxlib.downloader.outofdate", (Object[])new Object[0]);
                    fontRenderer.func_78276_b(s, errorScreen.field_146294_l / 2 - fontRenderer.func_78256_a(s) / 2, errorScreen.field_146295_m / 2, -1);
                }
            };
        }

        @Override
        public void showRestartScreen() {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenHold(I18n.func_135052_a((String)"foxlib.downloader.success", (Object[])new Object[0]), I18n.func_135052_a((String)"foxlib.downloader.restart", (Object[])new Object[0])));
        }

        @Override
        public void showFailedScreen() {
            try {
                Desktop.getDesktop().browse(URI.create(FoxLibManager.foxlibDownloadFallback));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenHold(I18n.func_135052_a((String)"foxlib.downloader.failed.0", (Object[])new Object[]{FoxLibManager.foxlibDownloadFallback}), I18n.func_135052_a((String)"foxlib.downloader.failed.1", (Object[])new Object[0])));
        }
    }

    public static class CommonProxy {
        public void throwFoxlibError() {
            FMLLog.bigWarning((String)StatCollector.func_74837_a((String)"foxlib.downloader.outofdate", (Object[])new Object[]{FoxLibManager.foxlibDownloadFallback}), (Object[])new Object[0]);
        }

        public void showRestartScreen() {
        }

        public void showFailedScreen() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class GuiScreenHold
    extends GuiScreen {
        private String topMessage;
        private String bottomMessage;

        public GuiScreenHold(String topMessage, String bottomMessage) {
            this.topMessage = topMessage;
            this.bottomMessage = bottomMessage;
        }

        public void func_73863_a(int p_73863_1_, int p_73863_2_, float p_73863_3_) {
            this.func_146276_q_();
            this.func_73732_a(this.field_146289_q, this.topMessage, this.field_146294_l / 2, 90, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, this.bottomMessage, this.field_146294_l / 2, 110, 0xFFFFFF);
        }

        protected void func_73869_a(char character, int keycode) {
        }
    }

    private class DownloadCountingOutputStream
    extends CountingOutputStream {
        private final IProgressUpdate update;

        public DownloadCountingOutputStream(OutputStream out, IProgressUpdate update) {
            super(out);
            this.update = update;
        }

        protected void afterWrite(int n) throws IOException {
            super.afterWrite(n);
            if (this.getByteCount() == FoxLibManager.this.totalSize) {
                proxy.showRestartScreen();
            }
            this.update.func_73718_a((int)(this.getByteCount() / FoxLibManager.this.totalSize));
        }
    }
}

