/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.client.texture;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.util.UUID;
import kihira.tails.client.PartRegistry;
import kihira.tails.client.texture.TripleTintTexture;
import kihira.tails.common.PartInfo;
import kihira.tails.common.PartsData;
import kihira.tails.common.Tails;
import kihira.tails.common.network.PlayerDataMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.Point;

@SideOnly(value=Side.CLIENT)
public class TextureHelper {
    private static final int switch1Colour = -61200;
    private static final int switch2Colour = -4661120;
    private static final Point[] dataPoints = new Point[]{new Point(58, 16), new Point(58, 17), new Point(58, 18)};
    private static final Point[][] switchPoints = new Point[][]{{new Point(56, 16), new Point(57, 16)}, {new Point(56, 17), new Point(57, 17)}, {new Point(56, 18), new Point(57, 18)}};
    private static final Point[][] tintPoints = new Point[][]{{new Point(59, 16), new Point(60, 16), new Point(61, 16)}, {new Point(59, 17), new Point(60, 17), new Point(61, 17)}, {new Point(59, 18), new Point(60, 18), new Point(61, 18)}};

    public static void buildPlayerInfo(AbstractClientPlayer player) {
        GameProfile profile = player.func_146103_bH();
        UUID uuid = profile.getId();
        BufferedImage image = kihira.foxlib.client.TextureHelper.getPlayerSkinAsBufferedImage((AbstractClientPlayer)player);
        if (image != null) {
            PartsData partsData = Tails.proxy.getPartsData(uuid);
            if (partsData == null) {
                partsData = new PartsData(uuid);
            }
            for (PartsData.PartType partType : PartsData.PartType.values()) {
                int ordinal = partType.ordinal();
                int scol1 = image.getRGB(switchPoints[ordinal][0].getX(), switchPoints[ordinal][0].getY());
                int scol2 = image.getRGB(switchPoints[ordinal][1].getX(), switchPoints[ordinal][1].getY());
                PartInfo tailInfo = scol1 == -61200 && scol2 == -4661120 ? TextureHelper.buildPartInfoFromSkin(uuid, partType, image) : new PartInfo(uuid, false, 0, 0, 0, 0, 0, 0, null, partType);
                partsData.setPartInfo(partType, tailInfo);
            }
            Tails.proxy.addPartsData(uuid, partsData);
            if (player == Minecraft.func_71410_x().field_71439_g) {
                Tails.setLocalPartsData(partsData);
                Tails.networkWrapper.sendToServer((IMessage)new PlayerDataMessage(partsData, false));
            }
        }
    }

    public static BufferedImage writePartsDataToSkin(PartsData partsData, AbstractClientPlayer player) {
        BufferedImage image = kihira.foxlib.client.TextureHelper.getPlayerSkinAsBufferedImage((AbstractClientPlayer)player);
        if (image != null) {
            for (PartsData.PartType partType : PartsData.PartType.values()) {
                PartInfo partInfo = partsData.getPartInfo(partType);
                int ordinal = partType.ordinal();
                int switch1 = 0;
                int switch2 = 0;
                if (partInfo != null) {
                    if (partInfo.hasPart) {
                        switch1 = -61200;
                        switch2 = -4661120;
                    }
                    int dataColour = -16777216;
                    dataColour |= partInfo.typeid << 16;
                    dataColour |= partInfo.subid << 8;
                    image.setRGB(dataPoints[ordinal].getX(), dataPoints[ordinal].getY(), dataColour |= partInfo.textureID);
                    image.setRGB(tintPoints[ordinal][0].getX(), tintPoints[ordinal][0].getY(), partInfo.tints[0]);
                    image.setRGB(tintPoints[ordinal][1].getX(), tintPoints[ordinal][1].getY(), partInfo.tints[1]);
                    image.setRGB(tintPoints[ordinal][2].getX(), tintPoints[ordinal][2].getY(), partInfo.tints[2]);
                }
                image.setRGB(switchPoints[ordinal][0].getX(), switchPoints[ordinal][0].getY(), switch1);
                image.setRGB(switchPoints[ordinal][1].getX(), switchPoints[ordinal][1].getY(), switch2);
            }
        } else {
            Tails.logger.warn("Attempted to write PartInfo to skin but player doesn't have a skin!");
        }
        return image;
    }

    public static PartInfo buildPartInfoFromSkin(UUID id, PartsData.PartType partType, BufferedImage skin) {
        int ordinal = partType.ordinal();
        int data = skin.getRGB(dataPoints[ordinal].getX(), dataPoints[ordinal].getY());
        int typeid = data >> 16 & 0xFF;
        int subtype = data >> 8 & 0xFF;
        int textureid = data & 0xFF;
        String[] textures = PartRegistry.getRenderPart(partType, typeid).getTextureNames(subtype);
        textureid = textureid >= textures.length ? 0 : textureid;
        int tint1 = skin.getRGB(tintPoints[ordinal][0].getX(), tintPoints[ordinal][0].getY());
        int tint2 = skin.getRGB(tintPoints[ordinal][1].getX(), tintPoints[ordinal][1].getY());
        int tint3 = skin.getRGB(tintPoints[ordinal][2].getX(), tintPoints[ordinal][2].getY());
        ResourceLocation tailtexture = TextureHelper.generateTexture(id, partType, typeid, subtype, textureid, new int[]{tint1, tint2, tint3});
        return new PartInfo(id, true, typeid, subtype, 0, tint1, tint2, tint3, tailtexture, partType);
    }

    public static ResourceLocation generateTexture(UUID id, PartsData.PartType partType, int typeid, int subid, int textureID, int[] tints) {
        String[] textures = PartRegistry.getRenderPart(partType, typeid).getTextureNames(subid);
        textureID = textureID >= textures.length ? 0 : textureID;
        String texturePath = "texture/" + partType.name().toLowerCase() + "/" + textures[textureID] + ".png";
        ResourceLocation tailtexture = new ResourceLocation("tails_" + id.toString() + "_" + partType.name() + "_" + typeid + "_" + subid + "_" + textureID + "_" + tints[0] + "_" + tints[1] + "_" + tints[2]);
        Minecraft.func_71410_x().func_110434_K().func_110579_a(tailtexture, (ITextureObject)new TripleTintTexture("tails", texturePath, tints[0], tints[1], tints[2]));
        return tailtexture;
    }

    public static ResourceLocation generateTexture(PartInfo partInfo) {
        return TextureHelper.generateTexture(partInfo.uuid, partInfo.partType, partInfo.typeid, partInfo.subid, partInfo.textureID, partInfo.tints);
    }

    public static boolean needsBuild(EntityPlayer player) {
        return !Tails.proxy.hasPartsData(player.getPersistentID()) && player.func_146103_bH().getProperties().containsKey((Object)"textures");
    }
}

