/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.client;

import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import kihira.tails.client.model.ears.ModelCatEars;
import kihira.tails.client.model.ears.ModelFoxEars;
import kihira.tails.client.model.ears.ModelPandaEars;
import kihira.tails.client.model.tail.ModelBirdTail;
import kihira.tails.client.model.tail.ModelCatTail;
import kihira.tails.client.model.tail.ModelDevilTail;
import kihira.tails.client.model.tail.ModelDragonTail;
import kihira.tails.client.model.tail.ModelFluffyTail;
import kihira.tails.client.model.tail.ModelRaccoonTail;
import kihira.tails.client.render.RenderPart;
import kihira.tails.client.render.RenderWings;
import kihira.tails.common.PartsData;

@SideOnly(value=Side.CLIENT)
public class PartRegistry {
    private static final ArrayListMultimap<PartsData.PartType, RenderPart> partRegistry = ArrayListMultimap.create();

    public static void registerPart(PartsData.PartType partType, RenderPart renderPart) {
        partRegistry.put((Object)partType, (Object)renderPart);
    }

    public static List<RenderPart> getParts(PartsData.PartType partType) {
        return partRegistry.get((Object)partType);
    }

    public static RenderPart getRenderPart(PartsData.PartType partType, int index) {
        List<RenderPart> parts = PartRegistry.getParts(partType);
        index = index >= parts.size() ? 0 : index;
        return parts.get(index);
    }

    static {
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.fluffy", 2, new ModelFluffyTail(), "foxTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.dragon", 1, new ModelDragonTail(), "dragonTail", "dragonTailStriped"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.raccoon", 0, new ModelRaccoonTail(), "racoonTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.devil", 1, new ModelDevilTail(), "devilTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.cat", 0, new ModelCatTail(), "tabbyTail", "tigerTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.bird", 0, new ModelBirdTail(), "birdTail"));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.fox", 0, new ModelFoxEars(), "foxEars"));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.cat", 0, new ModelCatEars(), "catEars"));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.panda", 0, new ModelPandaEars(), "pandaEars"));
        PartRegistry.registerPart(PartsData.PartType.WINGS, new RenderWings("wings.big", 1, null, "bigWings", "metalWings"));
    }
}

