/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import openmods.Log;
import openperipheral.api.IEntityMetaProvider;
import openperipheral.api.IItemStackMetaProvider;
import openperipheral.api.IMetaProvider;

public class MetaProvidersRegistry<P extends IMetaProvider<?>> {
    public static final MetaProvidersRegistry<IEntityMetaProvider<?>> ENITITES = MetaProvidersRegistry.create(Entity.class, "entity");
    public static final MetaProvidersRegistry<IItemStackMetaProvider<?>> ITEMS = MetaProvidersRegistry.create(Item.class, "item");
    private final Multimap<Class<?>, P> directProviders = ArrayListMultimap.create();
    private final Multimap<Class<?>, P> providersCache = ArrayListMultimap.create();
    private final Set<Class<?>> inCache = Sets.newHashSet();
    private final String type;
    private final Class<?> baseClass;

    private static <T extends IMetaProvider<?>> MetaProvidersRegistry<T> create(Class<?> baseCls, String type) {
        return new MetaProvidersRegistry(type, baseCls);
    }

    public MetaProvidersRegistry(String type, Class<?> baseClass) {
        this.type = type;
        this.baseClass = baseClass;
    }

    public void addProvider(P provider) {
        Class targetClass = provider.getTargetClass();
        Preconditions.checkArgument((targetClass.isInterface() || this.baseClass.isAssignableFrom(targetClass) ? 1 : 0) != 0, (String)"Invalid type: %s", (Object[])new Object[]{targetClass});
        this.directProviders.put(targetClass, provider);
        Log.trace((String)"Registering %s metadata provider '%s' for '%s'", (Object[])new Object[]{this.type, provider.getClass(), targetClass});
        this.providersCache.clear();
        this.inCache.clear();
    }

    public Iterable<P> getProviders(Class<?> cls) {
        Collection<Object> all;
        if (!this.inCache.contains(cls)) {
            all = this.collectAllProviders(cls);
            this.providersCache.putAll(cls, all);
            this.inCache.add(cls);
        } else {
            all = this.providersCache.get(cls);
        }
        return all;
    }

    private Set<P> collectAllProviders(Class<?> targetCls) {
        Set providers = Sets.newIdentityHashSet();
        for (Class<?> cls : MetaProvidersRegistry.getAllImplementedClasses(targetCls)) {
            providers.addAll(this.directProviders.get(cls));
        }
        HashSet keys = Sets.newHashSet();
        for (IMetaProvider provider : providers) {
            String key = provider.getKey();
            boolean isNew = keys.add(key);
            Preconditions.checkState((boolean)isNew, (String)"Meta provider key %s is duplicated for class %s", (Object[])new Object[]{key, targetCls});
        }
        return providers;
    }

    private static Set<Class<?>> getAllImplementedClasses(Class<?> targetCls) {
        HashSet classes = Sets.newHashSet();
        LinkedList queue = Lists.newLinkedList();
        queue.add(targetCls);
        while (!queue.isEmpty()) {
            Class cls = (Class)queue.poll();
            classes.add(cls);
            Class superclass = cls.getSuperclass();
            if (superclass != null) {
                queue.add(superclass);
            }
            queue.addAll(Arrays.asList(cls.getInterfaces()));
        }
        return classes;
    }
}

