/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.meta;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openperipheral.ApiImplementation;
import openperipheral.api.IItemStackMetaBuilder;
import openperipheral.api.IItemStackMetaProvider;
import openperipheral.meta.MetaProvidersRegistry;

@ApiImplementation
public class ItemStackMetadataBuilder
implements IItemStackMetaBuilder {
    private static final Map<String, Object> NULL;

    private static String getNameForItemStack(ItemStack is) {
        try {
            return is.func_82833_r();
        }
        catch (Exception e) {
            try {
                return is.func_77977_a();
            }
            catch (Exception exception) {
                return "unknown";
            }
        }
    }

    public static String getRawNameForStack(ItemStack is) {
        try {
            return is.func_77977_a().toLowerCase();
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    @Override
    public Map<String, Object> getItemStackMetadata(ItemStack itemstack) {
        if (itemstack == null) {
            return NULL;
        }
        Item item = itemstack.func_77973_b();
        HashMap map = Maps.newHashMap();
        ItemStackMetadataBuilder.fillBasicProperties(map, item, itemstack);
        ItemStackMetadataBuilder.fillCustomProperties(map, item, itemstack);
        return map;
    }

    private static void fillCustomProperties(Map<String, Object> map, Item item, ItemStack itemstack) {
        Iterable<IItemStackMetaProvider<?>> providers = MetaProvidersRegistry.ITEMS.getProviders(item.getClass());
        for (IItemStackMetaProvider<?> provider : providers) {
            Object converted = provider.getMeta(item, itemstack);
            if (converted == null) continue;
            String key = provider.getKey();
            map.put(key, converted);
        }
    }

    private static void fillBasicProperties(Map<String, Object> map, Item item, ItemStack itemstack) {
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)item);
        map.put("id", id != null ? id.toString() : "?");
        map.put("name", id != null ? id.name : "?");
        map.put("mod_id", id != null ? id.modId : "?");
        map.put("display_name", ItemStackMetadataBuilder.getNameForItemStack(itemstack));
        map.put("raw_name", ItemStackMetadataBuilder.getRawNameForStack(itemstack));
        map.put("qty", itemstack.field_77994_a);
        map.put("dmg", itemstack.func_77960_j());
        map.put("max_dmg", itemstack.func_77958_k());
        map.put("max_size", itemstack.func_77976_d());
    }

    @Override
    public void register(IItemStackMetaProvider<?> provider) {
        MetaProvidersRegistry.ITEMS.addProvider(provider);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)"invalid");
        NULL = builder.build();
    }
}

