/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.api;

import openperipheral.api.IApiInterface;

public class ApiAccess {
    public static final String API_VERSION = "2.2";
    private static ApiProvider provider;

    private ApiAccess() {
    }

    public static void init(ApiProvider provider) {
        if (ApiAccess.provider != null) {
            throw new IllegalStateException("API already initialized");
        }
        ApiAccess.provider = provider;
    }

    public static <T extends IApiInterface> T getApi(Class<T> cls) {
        if (provider == null) {
            throw new IllegalStateException("API not initialized");
        }
        return provider.getApi(cls);
    }

    public static <T extends IApiInterface> boolean isApiPresent(Class<T> cls) {
        if (provider == null) {
            throw new IllegalStateException("API not initialized");
        }
        return provider.isApiPresent(cls);
    }

    public static interface ApiProvider {
        public <T extends IApiInterface> T getApi(Class<T> var1);

        public <T extends IApiInterface> boolean isApiPresent(Class<T> var1);
    }
}

