/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.reflect.Method;
import java.util.Arrays;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.peripheral.ExecutionStrategy;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.PeripheralAdapterWrapper;
import openperipheral.api.IAdapter;
import openperipheral.api.IAdapterWithConstraints;

public class PeripheralExternalAdapterWrapper
extends PeripheralAdapterWrapper {
    private final IAdapter adapter;

    public PeripheralExternalAdapterWrapper(IAdapter adapter) {
        super(adapter.getClass(), adapter.getTargetClass(), adapter.getSourceId());
        this.adapter = adapter;
    }

    @Override
    protected IPeripheralMethodExecutor createDirectExecutor(MethodDeclaration method, ExecutionStrategy strategy) {
        return new PeripheralAdapterWrapper.PeripheralMethodExecutor(method, strategy){

            @Override
            protected MethodDeclaration.CallWrap createWrapper(IComputerAccess computer, ILuaContext context, Object target, Object[] luaArgs) {
                return this.method.createWrapper(PeripheralExternalAdapterWrapper.this.adapter).setJavaArg("computer", computer).setJavaArg("target", target).setJavaArg("context", context).setLuaArgs(luaArgs);
            }
        };
    }

    @Override
    protected void configureJavaArguments(MethodDeclaration decl) {
        decl.setDefaultArgName(0, "target");
        decl.declareJavaArgType("computer", IComputerAccess.class);
        decl.declareJavaArgType("context", ILuaContext.class);
        decl.declareJavaArgType("target", this.targetClass);
    }

    @Override
    protected IPeripheralMethodExecutor adaptObjectExecutor(final Method targetProvider, final IObjectMethodExecutor executor) {
        Preconditions.checkArgument((boolean)Arrays.equals(targetProvider.getParameterTypes(), new Class[]{this.targetClass}));
        return new IPeripheralMethodExecutor(){

            @Override
            public IDescriptable description() {
                return executor.description();
            }

            @Override
            public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) throws Exception {
                Object executorTarget = targetProvider.invoke((Object)PeripheralExternalAdapterWrapper.this.adapter, target);
                return executor.execute(context, executorTarget, args);
            }
        };
    }

    @Override
    public String describe() {
        return "external peripheral (source: " + this.adapterClass.toString() + ")";
    }

    @Override
    public boolean canUse(Class<?> cls) {
        return true;
    }

    public static class WithConstraints
    extends PeripheralExternalAdapterWrapper {
        private final IAdapterWithConstraints adapter;

        public WithConstraints(IAdapterWithConstraints adapter) {
            super(adapter);
            this.adapter = adapter;
        }

        @Override
        public String describe() {
            return "external peripheral (w/ constraints) (source: " + this.adapterClass.toString() + ")";
        }

        @Override
        public boolean canUse(Class<?> cls) {
            return this.adapter.canApply(cls);
        }
    }
}

