/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import openmods.Log;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.AdapterWrapper;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.MethodMap;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.adapter.peripheral.ExecutionStrategy;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.api.Asynchronous;
import openperipheral.api.Include;
import openperipheral.api.Synchronizable;

public abstract class PeripheralAdapterWrapper
extends AdapterWrapper<IPeripheralMethodExecutor> {
    static final String ARG_TARGET = "target";
    static final String ARG_COMPUTER = "computer";
    static final String ARG_CONTEXT = "context";

    protected PeripheralAdapterWrapper(Class<?> adapterClass, Class<?> targetClass, String source) {
        super(adapterClass, targetClass, source);
    }

    protected static boolean isIgnoringWarnings(AnnotatedElement element, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        Synchronizable ignore = element.getAnnotation(Synchronizable.class);
        return ignore != null ? ignore.value() : defaultValue;
    }

    protected static boolean isAsynchronous(AnnotatedElement element, boolean defaultValue) {
        Asynchronous async = element.getAnnotation(Asynchronous.class);
        return async != null ? async.value() : defaultValue;
    }

    @Override
    protected List<IPeripheralMethodExecutor> buildMethodList() {
        final boolean defaultAsync = PeripheralAdapterWrapper.isAsynchronous(this.adapterClass, false);
        boolean packageIsIgnoringWarnings = PeripheralAdapterWrapper.isIgnoringWarnings(this.adapterClass.getPackage(), false);
        final boolean classIsIgnoringWarnings = PeripheralAdapterWrapper.isIgnoringWarnings(this.adapterClass, packageIsIgnoringWarnings);
        List<IPeripheralMethodExecutor> peripheralMethods = this.buildMethodList(new AdapterWrapper.MethodExecutorFactory<IPeripheralMethodExecutor>(){

            @Override
            public IPeripheralMethodExecutor createExecutor(Method method, MethodDeclaration decl) {
                ExecutionStrategy strategy;
                boolean isAsync = PeripheralAdapterWrapper.isAsynchronous(method, defaultAsync);
                ExecutionStrategy executionStrategy = strategy = isAsync ? ExecutionStrategy.ASYNCHRONOUS : ExecutionStrategy.createOnTickStrategy(PeripheralAdapterWrapper.this.targetClass);
                if (!strategy.isAlwaysSafe() && !PeripheralAdapterWrapper.isIgnoringWarnings(method, classIsIgnoringWarnings)) {
                    Log.warn((String)"Method '%s' is synchronous, but type %s does not provide world instance. Possible runtime crash!", (Object[])new Object[]{method, PeripheralAdapterWrapper.this.targetClass});
                }
                return PeripheralAdapterWrapper.this.createDirectExecutor(decl, strategy);
            }
        });
        for (Method m : this.adapterClass.getMethods()) {
            Include marker = m.getAnnotation(Include.class);
            if (marker == null) continue;
            this.includeClass(peripheralMethods, m);
        }
        return peripheralMethods;
    }

    private void includeClass(List<IPeripheralMethodExecutor> result, Method targetProvider) {
        Class<?> target = targetProvider.getReturnType();
        Preconditions.checkArgument((!target.isPrimitive() ? 1 : 0) != 0, (String)"Method %s is marked with annotation 'Include', but returns primitive type", (Object[])new Object[]{targetProvider});
        MethodMap<IObjectMethodExecutor> toInclude = AdapterManager.OBJECTS_MANAGER.getAdaptedClass(target);
        Set executors = Sets.newIdentityHashSet();
        executors.addAll(toInclude.values());
        for (IObjectMethodExecutor e : executors) {
            result.add(this.adaptObjectExecutor(targetProvider, e));
        }
    }

    protected abstract IPeripheralMethodExecutor createDirectExecutor(MethodDeclaration var1, ExecutionStrategy var2);

    protected abstract IPeripheralMethodExecutor adaptObjectExecutor(Method var1, IObjectMethodExecutor var2);

    protected static abstract class PeripheralMethodExecutor
    implements IPeripheralMethodExecutor {
        public final MethodDeclaration method;
        public final ExecutionStrategy strategy;

        protected abstract MethodDeclaration.CallWrap createWrapper(IComputerAccess var1, ILuaContext var2, Object var3, Object[] var4);

        public PeripheralMethodExecutor(MethodDeclaration method, ExecutionStrategy strategy) {
            this.method = method;
            this.strategy = strategy;
        }

        @Override
        public IDescriptable description() {
            return this.method;
        }

        @Override
        public Object[] execute(IComputerAccess computer, ILuaContext context, Object target, Object[] args) throws Exception {
            MethodDeclaration.CallWrap callable = this.createWrapper(computer, context, target, args);
            return this.strategy.execute(target, computer, context, callable);
        }
    }
}

