/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.peripheral;

import com.google.common.base.Preconditions;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import openmods.Log;
import openperipheral.adapter.AdapterLogicException;
import openperipheral.adapter.MethodMap;
import openperipheral.adapter.WrappedEntityBase;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.api.IAttachable;
import openperipheral.util.PeripheralUtils;
import openperipheral.util.ResourceMount;
import org.apache.logging.log4j.Level;

public class AdapterPeripheral
extends WrappedEntityBase<IPeripheralMethodExecutor>
implements IPeripheral {
    private static final String MOUNT_NAME = "openp";
    private static final IMount MOUNT = new ResourceMount();
    protected final String type;
    protected final Object targetObject;

    public AdapterPeripheral(MethodMap<IPeripheralMethodExecutor> methods, Object targetObject) {
        super(methods);
        this.targetObject = targetObject;
        this.type = PeripheralUtils.getNameForTarget(targetObject);
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String[] getMethodNames() {
        return super.getMethodNames();
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int index, Object[] arguments) throws LuaException, InterruptedException {
        computer.getAttachmentName();
        IPeripheralMethodExecutor executor = (IPeripheralMethodExecutor)this.getMethod(index);
        Preconditions.checkNotNull((Object)executor, (String)"Invalid method index: %d", (Object[])new Object[]{index});
        try {
            return executor.execute(computer, context, this.targetObject, arguments);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (LuaException e) {
            throw e;
        }
        catch (AdapterLogicException e) {
            String methodName = this.getMethodName(index);
            Log.log((Level)Level.DEBUG, (Throwable)e.getCause(), (String)"Adapter error during method %s(%d) execution on peripheral %s, args: %s", (Object[])new Object[]{methodName, index, this.type, Arrays.toString(arguments)});
            throw e.rethrow();
        }
        catch (Throwable e) {
            String methodName = this.getMethodName(index);
            Log.log((Level)Level.INFO, (Throwable)e, (String)"Unwrapped error during method %s(%d) execution on peripheral %s, args: %s", (Object[])new Object[]{methodName, index, this.type, Arrays.toString(arguments)});
            throw new LuaException("Internal error. Check logs for info");
        }
    }

    public void attach(IComputerAccess computer) {
        computer.mount(MOUNT_NAME, MOUNT);
        if (this.targetObject instanceof IAttachable) {
            ((IAttachable)this.targetObject).addComputer(computer);
        }
    }

    public void detach(IComputerAccess computer) {
        if (this.targetObject instanceof IAttachable) {
            ((IAttachable)this.targetObject).removeComputer(computer);
        }
    }

    public boolean equals(IPeripheral other) {
        return other == this;
    }
}

