/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.object;

import dan200.computercraft.api.lua.ILuaContext;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Callable;
import openmods.Log;
import openperipheral.adapter.AdapterWrapper;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.PropertyListBuilder;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.object.IObjectMethodExecutor;
import openperipheral.api.IAdapter;
import openperipheral.api.IAdapterWithConstraints;
import openperipheral.api.ObjectTypeId;

public abstract class ObjectAdapterWrapper
extends AdapterWrapper<IObjectMethodExecutor> {
    private static final String ARG_TARGET = "target";
    private static final String ARG_CONTEXT = "context";

    protected ObjectAdapterWrapper(Class<?> adapterClass, Class<?> targetClass, String source) {
        super(adapterClass, targetClass, source);
    }

    @Override
    protected List<IObjectMethodExecutor> buildMethodList() {
        return this.buildMethodList(new AdapterWrapper.MethodExecutorFactory<IObjectMethodExecutor>(){

            @Override
            public IObjectMethodExecutor createExecutor(Method method, final MethodDeclaration decl) {
                return new IObjectMethodExecutor(){

                    @Override
                    public IDescriptable description() {
                        return decl;
                    }

                    @Override
                    public Object[] execute(ILuaContext context, Object target, Object[] args) throws Exception {
                        return ObjectAdapterWrapper.this.createWrapper(decl, context, target, args).call();
                    }
                };
            }
        });
    }

    protected abstract Callable<Object[]> createWrapper(MethodDeclaration var1, ILuaContext var2, Object var3, Object[] var4);

    public static class Inline
    extends ObjectAdapterWrapper
    implements PropertyListBuilder.IPropertyExecutorFactory<IObjectMethodExecutor> {
        private final String source;

        public Inline(Class<?> targetClass) {
            this(targetClass, Inline.getSourceId(targetClass));
        }

        private Inline(Class<?> targetClass, String source) {
            super(targetClass, targetClass, source);
            this.source = source;
        }

        private static String getSourceId(Class<?> cls) {
            ObjectTypeId id = cls.getAnnotation(ObjectTypeId.class);
            if (id != null) {
                return id.value();
            }
            Log.trace((String)"Inline adapter %s has no ObjectTypeId annotation", (Object[])new Object[]{cls});
            return cls.getName().toLowerCase();
        }

        @Override
        protected void configureJavaArguments(MethodDeclaration decl) {
            decl.declareJavaArgType(ObjectAdapterWrapper.ARG_CONTEXT, ILuaContext.class);
        }

        @Override
        protected Callable<Object[]> createWrapper(MethodDeclaration decl, ILuaContext context, Object target, Object[] args) {
            return decl.createWrapper(target).setJavaArg(ObjectAdapterWrapper.ARG_CONTEXT, context).setLuaArgs(args);
        }

        @Override
        public IObjectMethodExecutor createExecutor(PropertyListBuilder.FieldContext context) {
            return new ObjectPropertyExecutor(context);
        }

        @Override
        protected List<IObjectMethodExecutor> buildMethodList() {
            List<IObjectMethodExecutor> result = super.buildMethodList();
            PropertyListBuilder.buildPropertyList(this.targetClass, this.source, this, result);
            return result;
        }

        @Override
        public String describe() {
            return "internal object (source: " + this.adapterClass.toString() + ")";
        }

        @Override
        public boolean canUse(Class<?> cls) {
            return true;
        }
    }

    public static class ExternalWithConstraints
    extends External {
        private final IAdapterWithConstraints adapter;

        public ExternalWithConstraints(IAdapterWithConstraints adapter) {
            super(adapter);
            this.adapter = adapter;
        }

        @Override
        public String describe() {
            return "external object (w/ constraints) (source: " + this.adapterClass.toString() + ")";
        }

        @Override
        public boolean canUse(Class<?> cls) {
            return this.adapter.canApply(cls);
        }
    }

    public static class External
    extends ObjectAdapterWrapper {
        private final IAdapter adapter;

        public External(IAdapter adapter) {
            super(adapter.getClass(), adapter.getTargetClass(), adapter.getSourceId());
            this.adapter = adapter;
        }

        @Override
        protected void configureJavaArguments(MethodDeclaration decl) {
            decl.setDefaultArgName(0, ObjectAdapterWrapper.ARG_TARGET);
            decl.declareJavaArgType(ObjectAdapterWrapper.ARG_CONTEXT, ILuaContext.class);
            decl.declareJavaArgType(ObjectAdapterWrapper.ARG_TARGET, this.targetClass);
        }

        @Override
        protected Callable<Object[]> createWrapper(MethodDeclaration decl, ILuaContext context, Object target, Object[] args) {
            return decl.createWrapper(this.adapter).setJavaArg(ObjectAdapterWrapper.ARG_TARGET, target).setJavaArg(ObjectAdapterWrapper.ARG_CONTEXT, context).setLuaArgs(args);
        }

        @Override
        public String describe() {
            return "external object (source: " + this.adapterClass.toString() + ")";
        }

        @Override
        public boolean canUse(Class<?> cls) {
            return true;
        }
    }

    private static class ObjectPropertyExecutor
    extends PropertyListBuilder.PropertyExecutor
    implements IObjectMethodExecutor {
        protected ObjectPropertyExecutor(PropertyListBuilder.FieldContext context) {
            super(context);
        }

        @Override
        public Object[] execute(ILuaContext context, Object target, Object[] args) {
            return this.call(target, args);
        }
    }
}

