/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import openperipheral.api.Env;
import openperipheral.api.LuaCallable;
import openperipheral.api.LuaReturnType;

public class LuaReflectionHelper {
    private static Map<String, Object> describe(Method method) {
        HashMap desc = Maps.newHashMap();
        ArrayList args = Lists.newArrayList();
        for (Class<?> arg : method.getParameterTypes()) {
            args.add(arg.toString());
        }
        desc.put("modifiers", Modifier.toString(method.getModifiers()));
        desc.put("from", method.getDeclaringClass().toString());
        desc.put("args", args);
        return desc;
    }

    private static Map<String, Map<String, Object>> describe(Method[] methods) {
        HashMap results = Maps.newHashMap();
        for (Method method : methods) {
            results.put(method.getName(), LuaReflectionHelper.describe(method));
        }
        return results;
    }

    @LuaCallable(returnTypes={LuaReturnType.STRING})
    public String getClass(@Env(value="target") Object owner) {
        return owner.getClass().toString();
    }

    @LuaCallable(returnTypes={LuaReturnType.STRING})
    public String getSuperclass(@Env(value="target") Object owner) {
        return owner.getClass().getSuperclass().toString();
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE})
    public List<String> getInterfaces(@Env(value="target") Object owner) {
        ArrayList results = Lists.newArrayList();
        for (Class<?> cls : owner.getClass().getInterfaces()) {
            results.add(cls.toString());
        }
        return results;
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE})
    public Map<String, Map<String, Object>> getMethods(@Env(value="target") Object owner) {
        return LuaReflectionHelper.describe(owner.getClass().getMethods());
    }

    @LuaCallable(returnTypes={LuaReturnType.TABLE})
    public Map<String, Map<String, Object>> getDeclaredMethods(@Env(value="target") Object owner) {
        return LuaReflectionHelper.describe(owner.getClass().getDeclaredMethods());
    }
}

