/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import openmods.Log;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.AdapterWrapper;
import openperipheral.adapter.IDescriptable;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.MethodMap;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.api.LuaCallable;

public abstract class ClassMethodsListBuilder<E extends IMethodExecutor> {
    private final AdapterManager<E> manager;
    private final MethodMap<E> methods = new MethodMap();
    private final Set<String> sources = Sets.newHashSet();
    public static final String ARG_TARGET = "target";

    public ClassMethodsListBuilder(AdapterManager<E> manager) {
        this.manager = manager;
    }

    protected abstract E createDummyWrapper(Object var1, MethodDeclaration var2);

    public void addMethodsFromObject(Object target, String source) {
        for (Method method : target.getClass().getMethods()) {
            LuaCallable callableMeta = method.getAnnotation(LuaCallable.class);
            if (callableMeta == null) continue;
            MethodDeclaration decl = new MethodDeclaration(method, callableMeta, source);
            this.sources.add(decl.source());
            for (String name : decl.getNames()) {
                this.methods.put(name, this.createDummyWrapper(target, decl));
            }
        }
    }

    public void addExternalAdapters(Class<?> targetCls, Class<?> superClass) {
        for (AdapterWrapper<E> wrapper : this.manager.getExternalAdapters(superClass)) {
            if (wrapper.canUse(targetCls)) {
                this.addMethods(wrapper);
                continue;
            }
            Log.warn((String)"Adapter %s cannot be used for %s due to constraints", (Object[])new Object[]{wrapper.describe()});
        }
    }

    public void addInlineAdapter(Class<?> cls) {
        AdapterWrapper<E> wrapper = this.manager.getInlineAdapter(cls);
        this.addMethods(wrapper);
    }

    public void addMethods(AdapterWrapper<E> wrapper) {
        for (IMethodExecutor executor : wrapper.getMethods()) {
            IDescriptable descriptable = executor.description();
            this.sources.add(descriptable.source());
            for (String name : descriptable.getNames()) {
                IMethodExecutor previous = this.methods.put(name, executor);
                if (previous == null) continue;
                Log.trace((String)"Previous defininition of Lua method '%s' overwritten by %s adapter", (Object[])new Object[]{name, wrapper.describe()});
            }
        }
    }

    public Map<String, E> getMethodList() {
        return Collections.unmodifiableMap(this.methods);
    }

    public Set<String> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    public boolean hasMethods() {
        return !this.methods.isEmpty();
    }

    public MethodMap<E> create() {
        return this.methods;
    }
}

