/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Set;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;
import openperipheral.ApiSingleton;
import openperipheral.Config;
import openperipheral.api.IPeripheralBlacklist;
import openperipheral.api.Ignore;

@ApiSingleton
public class TileEntityBlacklist
implements IPeripheralBlacklist {
    public static final TileEntityBlacklist INSTANCE = new TileEntityBlacklist();
    private final Set<String> imcBlacklist = Sets.newHashSet();
    private Set<String> fullBlacklist = Sets.newHashSet();

    @SubscribeEvent
    public void onConfigChange(ConfigurationChange evt) {
        if (evt.check("integration", "disableClasses")) {
            this.fullBlacklist = Sets.newHashSet(this.imcBlacklist);
            for (String cls : Config.teBlacklist) {
                this.fullBlacklist.add(cls.toLowerCase());
            }
        }
    }

    @Override
    public boolean isBlacklisted(Class<?> teClass) {
        String teClassName = teClass.getName().toLowerCase();
        if (this.fullBlacklist.contains(teClassName)) {
            return true;
        }
        if (teClass.isAnnotationPresent(Ignore.class)) {
            this.fullBlacklist.add(teClassName);
            return true;
        }
        try {
            teClass.getField("OPENPERIPHERAL_IGNORE");
            this.fullBlacklist.add(teClassName);
            return true;
        }
        catch (NoSuchFieldException e) {
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Class %s doesn't cooperate", (Object[])new Object[]{teClass});
        }
        return false;
    }

    @Override
    public void addToBlacklist(String className) {
        this.imcBlacklist.add(className.toLowerCase());
    }

    @Override
    public void addToBlacklist(Class<?> cls) {
        this.addToBlacklist(cls.getName());
    }
}

