/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.Log;
import openmods.reflection.ReflectionHelper;
import openperipheral.adapter.AdapterManager;
import openperipheral.adapter.CachingPeripheralFactory;
import openperipheral.adapter.IPeripheralFactory;
import openperipheral.adapter.MethodMap;
import openperipheral.adapter.SafePeripheralFactory;
import openperipheral.adapter.TileEntityBlacklist;
import openperipheral.adapter.peripheral.AdapterPeripheral;
import openperipheral.adapter.peripheral.IPeripheralMethodExecutor;
import openperipheral.adapter.peripheral.ProxyAdapterPeripheral;
import openperipheral.api.ExposeInterface;
import openperipheral.api.ICustomPeripheralProvider;
import openperipheral.api.Volatile;

public class PeripheralHandlers
implements IPeripheralProvider {
    private static final IPeripheralFactory<TileEntity> NULL_HANDLER = new IPeripheralFactory<TileEntity>(){

        @Override
        public IPeripheral getPeripheral(TileEntity obj, int side) {
            return null;
        }
    };
    private static final IPeripheralFactory<TileEntity> ADAPTER_HANDLER = new SafePeripheralFactory(){

        @Override
        protected IPeripheral createPeripheral(TileEntity tile, int side) {
            return PeripheralHandlers.createAdaptedPeripheral(tile);
        }
    };
    private static final IPeripheralFactory<TileEntity> ADAPTER_CACHING_HANDLER = new CachingPeripheralFactory(){

        @Override
        protected IPeripheral createPeripheral(TileEntity tile, int side) {
            return PeripheralHandlers.createAdaptedPeripheral(tile);
        }
    };
    private static final IPeripheralFactory<TileEntity> PROVIDER_HANDLER = new SafePeripheralFactory(){

        @Override
        protected IPeripheral createPeripheral(TileEntity tile, int side) {
            return tile instanceof ICustomPeripheralProvider ? ((ICustomPeripheralProvider)tile).createPeripheral(side) : null;
        }
    };
    private static final IPeripheralFactory<TileEntity> PROVIDER_CACHING_HANDLER = new CachingPeripheralFactory(){

        @Override
        protected IPeripheral createPeripheral(TileEntity tile, int side) {
            return tile instanceof ICustomPeripheralProvider ? ((ICustomPeripheralProvider)tile).createPeripheral(side) : null;
        }
    };
    private static final Map<Class<? extends TileEntity>, IPeripheralFactory<TileEntity>> adaptedClasses = Maps.newHashMap();

    private static IPeripheralFactory<TileEntity> findFactoryForClass(Class<? extends TileEntity> teClass) {
        if (IPeripheral.class.isAssignableFrom(teClass)) {
            return NULL_HANDLER;
        }
        if (ICustomPeripheralProvider.class.isAssignableFrom(teClass)) {
            if (teClass.isAnnotationPresent(Volatile.class)) {
                Log.trace((String)"Adding non-caching provider handler for %s", (Object[])new Object[]{teClass});
                return PROVIDER_HANDLER;
            }
            Log.trace((String)"Adding caching provider handler for %s", (Object[])new Object[]{teClass});
            return PROVIDER_CACHING_HANDLER;
        }
        if (TileEntityBlacklist.INSTANCE.isBlacklisted(teClass)) {
            return NULL_HANDLER;
        }
        for (Class<? extends TileEntity> clazz : AdapterManager.PERIPHERALS_MANAGER.getAllAdaptableClasses()) {
            if (!clazz.isAssignableFrom(teClass)) continue;
            if (teClass.isAnnotationPresent(Volatile.class)) {
                Log.trace((String)"Adding non-caching adapter handler for %s", (Object[])new Object[]{teClass});
                return ADAPTER_HANDLER;
            }
            Log.trace((String)"Adding caching adapter handler for %s", (Object[])new Object[]{teClass});
            return ADAPTER_CACHING_HANDLER;
        }
        return NULL_HANDLER;
    }

    private static IPeripheralFactory<TileEntity> getFactoryForClass(Class<? extends TileEntity> teClass) {
        IPeripheralFactory<TileEntity> factory = adaptedClasses.get(teClass);
        if (factory == null) {
            factory = PeripheralHandlers.findFactoryForClass(teClass);
            adaptedClasses.put(teClass, factory);
        }
        return factory;
    }

    public static IPeripheral createAdaptedPeripheralSafe(Object target) {
        Preconditions.checkNotNull((Object)target, (Object)"Null target");
        try {
            return PeripheralHandlers.createAdaptedPeripheral(target);
        }
        catch (Throwable t) {
            Log.warn((Throwable)t, (String)"Failed to create peripheral for object '%s'", (Object[])new Object[]{target});
            return SafePeripheralFactory.PLACEHOLDER;
        }
    }

    public static IPeripheral createAdaptedPeripheral(Object target) {
        ImmutableSet whitelist;
        Class<?> targetClass = target.getClass();
        MethodMap<IPeripheralMethodExecutor> methods = AdapterManager.PERIPHERALS_MANAGER.getAdaptedClass(targetClass);
        if (methods.isEmpty()) {
            return null;
        }
        ExposeInterface proxyAnn = targetClass.getAnnotation(ExposeInterface.class);
        if (proxyAnn == null) {
            return new AdapterPeripheral(methods, target);
        }
        Set implemented = ReflectionHelper.getAllInterfaces(targetClass);
        Sets.SetView proxied = Sets.intersection((Set)implemented, (Set)(whitelist = ImmutableSet.copyOf((Object[])proxyAnn.value())));
        if (proxied.isEmpty()) {
            return new AdapterPeripheral(methods, target);
        }
        HashSet allImplemented = Sets.newHashSet((Iterable)proxied);
        allImplemented.add(IPeripheral.class);
        ProxyAdapterPeripheral handler = new ProxyAdapterPeripheral(methods, target);
        Class[] interfaces = allImplemented.toArray(new Class[allImplemented.size()]);
        return (IPeripheral)Proxy.newProxyInstance(targetClass.getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return null;
        }
        IPeripheralFactory<TileEntity> factory = PeripheralHandlers.getFactoryForClass(te.getClass());
        return factory.getPeripheral(te, side);
    }
}

