/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import openmods.Log;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.api.LuaCallable;

public abstract class AdapterWrapper<E extends IMethodExecutor> {
    protected final List<E> methods;
    protected final Class<?> targetClass;
    protected final Class<?> adapterClass;
    protected final String source;

    protected AdapterWrapper(Class<?> adapterClass, Class<?> targetClass, String source) {
        this.adapterClass = adapterClass;
        this.targetClass = targetClass;
        this.source = source;
        this.methods = ImmutableList.copyOf(this.buildMethodList());
    }

    public String source() {
        return this.source;
    }

    public List<E> getMethods() {
        return this.methods;
    }

    public Class<?> getAdapterClass() {
        return this.adapterClass;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public abstract boolean canUse(Class<?> var1);

    public abstract String describe();

    protected abstract List<E> buildMethodList();

    protected abstract void configureJavaArguments(MethodDeclaration var1);

    protected List<E> buildMethodList(MethodExecutorFactory<E> factory) {
        Method[] clsMethods;
        ArrayList result = Lists.newArrayList();
        try {
            clsMethods = this.adapterClass.getDeclaredMethods();
        }
        catch (Throwable t) {
            Log.severe((Throwable)t, (String)"Can't get adapter %s methods (possible sideness fail), bailing out", (Object[])new Object[]{this.adapterClass});
            return result;
        }
        for (Method method : clsMethods) {
            try {
                LuaCallable callableAnn = method.getAnnotation(LuaCallable.class);
                if (callableAnn == null) continue;
                MethodDeclaration decl = new MethodDeclaration(method, callableAnn, this.source);
                this.configureJavaArguments(decl);
                decl.validate();
                E exec = factory.createExecutor(method, decl);
                result.add(exec);
            }
            catch (Throwable e) {
                throw new MethodWrapException(method, e);
            }
        }
        return result;
    }

    protected static interface MethodExecutorFactory<E extends IMethodExecutor> {
        public E createExecutor(Method var1, MethodDeclaration var2);
    }

    public static class MethodWrapException
    extends RuntimeException {
        private static final long serialVersionUID = -5116134133615320058L;

        public MethodWrapException(Method method, Throwable cause) {
            super(String.format("Failed to wrap method '%s'", method), cause);
        }
    }
}

