/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import dan200.computercraft.api.lua.ILuaObject;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import openmods.Log;
import openperipheral.ApiSingleton;
import openperipheral.api.ITypeConverter;
import openperipheral.api.ITypeConvertersRegistry;
import openperipheral.converter.ConverterArray;
import openperipheral.converter.ConverterDefault;
import openperipheral.converter.ConverterEnum;
import openperipheral.converter.ConverterFluidTankInfo;
import openperipheral.converter.ConverterGameProfile;
import openperipheral.converter.ConverterItemStack;
import openperipheral.converter.ConverterList;
import openperipheral.converter.ConverterMap;
import openperipheral.converter.ConverterNumber;
import openperipheral.converter.ConverterSet;
import openperipheral.converter.ConverterString;

@ApiSingleton
public class TypeConversionRegistry
implements ITypeConvertersRegistry {
    public static final TypeConversionRegistry INSTANCE = new TypeConversionRegistry();
    private final Deque<ITypeConverter> converters = Lists.newLinkedList();
    private final Set<Class<?>> directlyIgnored = Sets.newHashSet();
    private final List<Class<?>> subclassIngored = Lists.newArrayList();

    @Override
    public void registerIgnored(Class<?> ignored, boolean includeSubclasses) {
        (includeSubclasses ? this.subclassIngored : this.directlyIgnored).add(ignored);
    }

    private boolean isIgnored(Class<?> cls) {
        if (this.directlyIgnored.contains(cls)) {
            return true;
        }
        for (Class<?> ignored : this.subclassIngored) {
            if (!ignored.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    private TypeConversionRegistry() {
        this.registerIgnored(ILuaObject.class, true);
        this.converters.add(new ConverterGameProfile());
        this.converters.add(new ConverterFluidTankInfo());
        this.converters.add(new ConverterFluidTankInfo());
        this.converters.add(new ConverterItemStack());
        this.converters.add(new ConverterArray());
        this.converters.add(new ConverterList());
        this.converters.add(new ConverterMap());
        this.converters.add(new ConverterSet());
        this.converters.add(new ConverterEnum());
        this.converters.add(new ConverterDefault());
        this.converters.add(new ConverterNumber());
        this.converters.add(new ConverterString());
    }

    @Override
    public void register(ITypeConverter converter) {
        Log.trace((String)"Registering type converter %s", (Object[])new Object[]{converter});
        this.converters.addFirst(converter);
    }

    @Override
    public Object fromLua(Object obj, Class<?> expected) {
        for (ITypeConverter converter : this.converters) {
            try {
                Object response = converter.fromLua(this, obj, expected);
                if (response == null) continue;
                return response;
            }
            catch (Throwable e) {
                Log.warn((Throwable)e, (String)"Type converter %s failed", (Object[])new Object[]{converter});
                throw Throwables.propagate((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public Object toLua(Object obj) {
        if (obj == null || this.isIgnored(obj.getClass())) {
            return obj;
        }
        for (ITypeConverter converter : this.converters) {
            try {
                Object response = converter.toLua(this, obj);
                if (response == null) continue;
                return response;
            }
            catch (Throwable e) {
                Log.warn((Throwable)e, (String)"Type converter %s failed", (Object[])new Object[]{converter});
                throw Throwables.propagate((Throwable)e);
            }
        }
        throw new IllegalStateException("Conversion failed on value " + obj);
    }
}

