/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.utils.bitmap.IReadableBitMap;

public class SidedInventoryAdapter
implements ISidedInventory {
    private final IInventory inventory;
    private final Map<Integer, SlotInfo> slots = Maps.newHashMap();

    public SidedInventoryAdapter(IInventory inventory) {
        this.inventory = inventory;
    }

    public void registerSlot(Enum<?> slot, IReadableBitMap<ForgeDirection> sideFlags, boolean canInsert, boolean canExtract) {
        this.registerSlot(slot.ordinal(), sideFlags, canInsert, canExtract);
    }

    public void registerSlot(int slot, IReadableBitMap<ForgeDirection> sideFlags, boolean canInsert, boolean canExtract) {
        this.slots.put(slot, new SlotInfo(sideFlags, canInsert, canExtract));
    }

    public void registerSlots(int start, int count, IReadableBitMap<ForgeDirection> sideFlags, boolean canInsert, boolean canExtract) {
        for (int i = start; i < start + count; ++i) {
            this.registerSlot(i, sideFlags, canInsert, canExtract);
        }
    }

    public void registerAllSlots(IReadableBitMap<ForgeDirection> sideFlags, boolean canInsert, boolean canExtract) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            this.registerSlot(i, sideFlags, canInsert, canExtract);
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inventory.func_70300_a(entityplayer);
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.inventory.func_94041_b(i, itemstack);
    }

    public int[] func_94128_d(int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        HashSet result = Sets.newHashSet();
        for (Map.Entry<Integer, SlotInfo> entry : this.slots.entrySet()) {
            if (!entry.getValue().canAccessFromSite(dir)) continue;
            result.add(entry.getKey());
        }
        int[] tmp = new int[result.size()];
        int i = 0;
        for (Integer value : result) {
            tmp[i++] = value;
        }
        return tmp;
    }

    public boolean func_102007_a(int slotIndex, ItemStack itemstack, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        SlotInfo slot = this.slots.get(slotIndex);
        if (slot == null) {
            return false;
        }
        return slot.canInsert && slot.canAccessFromSite(dir) && this.inventory.func_94041_b(slotIndex, itemstack);
    }

    public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        SlotInfo slot = this.slots.get(slotIndex);
        if (slot == null) {
            return false;
        }
        return slot.canExtract && slot.canAccessFromSite(dir);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public void func_70296_d() {
        this.inventory.func_70296_d();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    private class SlotInfo {
        private final IReadableBitMap<ForgeDirection> sideFlags;
        private final boolean canInsert;
        private final boolean canExtract;

        private SlotInfo(IReadableBitMap<ForgeDirection> sideFlags, boolean canInsert, boolean canExtract) {
            this.sideFlags = sideFlags;
            this.canInsert = canInsert;
            this.canExtract = canExtract;
        }

        private boolean canAccessFromSite(ForgeDirection side) {
            return this.sideFlags.get(side);
        }
    }
}

