/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.integration.modules.BuildCraftPipes;
import openmods.inventory.GenericInventory;
import openmods.utils.BlockUtils;

public class InventoryUtils {
    public static void tryInsertStack(IInventory targetInventory, int slot, ItemStack stack, boolean canMerge) {
        if (targetInventory.func_94041_b(slot, stack)) {
            ItemStack targetStack = targetInventory.func_70301_a(slot);
            if (targetStack == null) {
                targetInventory.func_70299_a(slot, stack.func_77946_l());
                stack.field_77994_a = 0;
            } else if (canMerge && targetInventory.func_94041_b(slot, stack) && InventoryUtils.areMergeCandidates(stack, targetStack)) {
                int space = targetStack.func_77976_d() - targetStack.field_77994_a;
                int mergeAmount = Math.min(space, stack.field_77994_a);
                ItemStack copy = targetStack.func_77946_l();
                copy.field_77994_a += mergeAmount;
                targetInventory.func_70299_a(slot, copy);
                stack.field_77994_a -= mergeAmount;
            }
        }
    }

    public static boolean areItemAndTagEqual(ItemStack stackA, ItemStack stackB) {
        return stackA.func_77969_a(stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean areMergeCandidates(ItemStack source, ItemStack target) {
        return InventoryUtils.areItemAndTagEqual(source, target) && target.field_77994_a < target.func_77976_d();
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack) {
        InventoryUtils.insertItemIntoInventory(inventory, stack, ForgeDirection.UNKNOWN, -1);
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack, ForgeDirection side, int intoSlot) {
        InventoryUtils.insertItemIntoInventory(inventory, stack, side, intoSlot, true);
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack, ForgeDirection side, int intoSlot, boolean doMove) {
        InventoryUtils.insertItemIntoInventory(inventory, stack, side, intoSlot, doMove, true);
    }

    public static void insertItemIntoInventory(IInventory inventory, ItemStack stack, ForgeDirection side, int intoSlot, boolean doMove, boolean canStack) {
        boolean isSidedInventory;
        if (stack == null) {
            return;
        }
        int sideId = side.ordinal();
        IInventory targetInventory = inventory;
        if (!doMove) {
            GenericInventory copy = new GenericInventory("temporary.inventory", false, targetInventory.func_70302_i_());
            copy.copyFrom(inventory);
            targetInventory = copy;
        }
        TreeSet attemptSlots = Sets.newTreeSet();
        boolean bl = isSidedInventory = inventory instanceof ISidedInventory && side != ForgeDirection.UNKNOWN;
        if (isSidedInventory) {
            int[] accessibleSlots;
            for (int slot : accessibleSlots = ((ISidedInventory)inventory).func_94128_d(sideId)) {
                attemptSlots.add(slot);
            }
        } else {
            for (int a = 0; a < inventory.func_70302_i_(); ++a) {
                attemptSlots.add(a);
            }
        }
        if (intoSlot > -1) {
            attemptSlots.retainAll((Collection<?>)ImmutableSet.of((Object)intoSlot));
        }
        if (attemptSlots.isEmpty()) {
            return;
        }
        for (Integer slot : attemptSlots) {
            if (stack.field_77994_a <= 0) break;
            if (isSidedInventory && !((ISidedInventory)inventory).func_102007_a(slot.intValue(), stack, sideId)) continue;
            InventoryUtils.tryInsertStack(targetInventory, slot, stack, canStack);
        }
    }

    public static int moveItemInto(IInventory fromInventory, int fromSlot, Object target, int intoSlot, int maxAmount, ForgeDirection direction, boolean doMove) {
        return InventoryUtils.moveItemInto(fromInventory, fromSlot, target, intoSlot, maxAmount, direction, doMove, true);
    }

    public static int moveItemInto(IInventory fromInventory, int fromSlot, Object target, int intoSlot, int maxAmount, ForgeDirection direction, boolean doMove, boolean canStack) {
        ItemStack sourceStack = (fromInventory = InventoryUtils.getInventory(fromInventory)).func_70301_a(fromSlot);
        if (sourceStack == null) {
            return 0;
        }
        if (fromInventory instanceof ISidedInventory && !((ISidedInventory)fromInventory).func_102008_b(fromSlot, sourceStack, direction.ordinal())) {
            return 0;
        }
        ItemStack clonedSourceStack = sourceStack.func_77946_l();
        int amountToMove = clonedSourceStack.field_77994_a = Math.min(clonedSourceStack.field_77994_a, maxAmount);
        int inserted = 0;
        if (target instanceof TileEntity && BuildCraftPipes.access().isPipe((TileEntity)target)) {
            inserted = BuildCraftPipes.access().tryAcceptIntoPipe((TileEntity)target, clonedSourceStack, doMove, direction);
            clonedSourceStack.field_77994_a -= inserted;
        } else if (target instanceof IInventory) {
            IInventory targetInventory = InventoryUtils.getInventory((IInventory)target);
            ForgeDirection side = direction.getOpposite();
            InventoryUtils.insertItemIntoInventory(targetInventory, clonedSourceStack, side, intoSlot, doMove, canStack);
            inserted = amountToMove - clonedSourceStack.field_77994_a;
        }
        if (doMove) {
            ItemStack newSourcestack = sourceStack.func_77946_l();
            newSourcestack.field_77994_a -= inserted;
            if (newSourcestack.field_77994_a == 0) {
                fromInventory.func_70299_a(fromSlot, null);
            } else {
                fromInventory.func_70299_a(fromSlot, newSourcestack);
            }
        }
        return inserted;
    }

    private static IInventory doubleChestFix(TileEntity te) {
        int z;
        int y;
        int x;
        World world = te.func_145831_w();
        if (world.func_147439_a((x = te.field_145851_c) - 1, y = te.field_145848_d, z = te.field_145849_e) == Blocks.field_150486_ae) {
            return new InventoryLargeChest("Large chest", (IInventory)world.func_147438_o(x - 1, y, z), (IInventory)te);
        }
        if (world.func_147439_a(x + 1, y, z) == Blocks.field_150486_ae) {
            return new InventoryLargeChest("Large chest", (IInventory)te, (IInventory)world.func_147438_o(x + 1, y, z));
        }
        if (world.func_147439_a(x, y, z - 1) == Blocks.field_150486_ae) {
            return new InventoryLargeChest("Large chest", (IInventory)world.func_147438_o(x, y, z - 1), (IInventory)te);
        }
        if (world.func_147439_a(x, y, z + 1) == Blocks.field_150486_ae) {
            return new InventoryLargeChest("Large chest", (IInventory)te, (IInventory)world.func_147438_o(x, y, z + 1));
        }
        return te instanceof IInventory ? (IInventory)te : null;
    }

    public static IInventory getInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityChest) {
            return InventoryUtils.doubleChestFix(tileEntity);
        }
        if (tileEntity instanceof IInventory) {
            return (IInventory)tileEntity;
        }
        return null;
    }

    public static IInventory getInventory(World world, int x, int y, int z, ForgeDirection direction) {
        if (direction != null) {
            x += direction.offsetX;
            y += direction.offsetY;
            z += direction.offsetZ;
        }
        return InventoryUtils.getInventory(world, x, y, z);
    }

    public static IInventory getInventory(IInventory inventory) {
        if (inventory instanceof TileEntityChest) {
            return InventoryUtils.doubleChestFix((TileEntity)inventory);
        }
        return inventory;
    }

    public static List<ItemStack> getInventoryContents(IInventory inventory) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack slot = inventory.func_70301_a(i);
            if (slot == null) continue;
            result.add(slot);
        }
        return result;
    }

    public static Set<Integer> getSlotsWithStack(IInventory inventory, ItemStack stack) {
        inventory = InventoryUtils.getInventory(inventory);
        HashSet slots = Sets.newHashSet();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null || !stackInSlot.func_77969_a(stack)) continue;
            slots.add(i);
        }
        return slots;
    }

    public static int getFirstSlotWithStack(IInventory inventory, ItemStack stack) {
        inventory = InventoryUtils.getInventory(inventory);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stackInSlot = inventory.func_70301_a(i);
            if (stackInSlot == null || !stackInSlot.func_77969_a(stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean consumeInventoryItem(IInventory inventory, ItemStack stack) {
        int slotWithStack = InventoryUtils.getFirstSlotWithStack(inventory, stack);
        if (slotWithStack > -1) {
            ItemStack stackInSlot = inventory.func_70301_a(slotWithStack);
            --stackInSlot.field_77994_a;
            if (stackInSlot.field_77994_a == 0) {
                inventory.func_70299_a(slotWithStack, null);
            }
            return true;
        }
        return false;
    }

    public static int getSlotIndexOfNextStack(IInventory invent) {
        for (int i = 0; i < invent.func_70302_i_(); ++i) {
            ItemStack stack = invent.func_70301_a(i);
            if (stack == null) continue;
            return i;
        }
        return -1;
    }

    public static ItemStack removeNextItemStack(IInventory invent) {
        int nextFilledSlot = InventoryUtils.getSlotIndexOfNextStack(invent);
        if (nextFilledSlot > -1) {
            ItemStack copy = invent.func_70301_a(nextFilledSlot).func_77946_l();
            invent.func_70299_a(nextFilledSlot, null);
            return copy;
        }
        return null;
    }

    public static int moveItemsFromOneOfSides(TileEntity te, IInventory inv, int maxAmount, int intoSlot, Set<ForgeDirection> sides) {
        return InventoryUtils.moveItemsFromOneOfSides(te, inv, null, maxAmount, intoSlot, sides);
    }

    public static int moveItemsFromOneOfSides(TileEntity te, IInventory inv, ItemStack filterStack, int maxAmount, int intoSlot, Set<ForgeDirection> sides) {
        ArrayList shuffledSides = Lists.newArrayList(sides);
        Collections.shuffle(shuffledSides);
        IInventory ourInventory = InventoryUtils.getInventory(inv);
        for (ForgeDirection dir : sides) {
            TileEntity tileOnSurface = BlockUtils.getTileInDirection(te, dir);
            if (!(tileOnSurface instanceof IInventory)) continue;
            IInventory neighbor = (IInventory)tileOnSurface;
            Set<Integer> slots = filterStack == null ? InventoryUtils.getAllSlots(neighbor) : InventoryUtils.getSlotsWithStack(neighbor, filterStack);
            for (Integer slot : slots) {
                int moved = InventoryUtils.moveItemInto(neighbor, slot, ourInventory, intoSlot, maxAmount, dir.getOpposite(), true);
                if (moved <= 0) continue;
                return moved;
            }
        }
        return 0;
    }

    public static int testInventoryInsertion(IInventory inventory, ItemStack item) {
        if (item == null || item.field_77994_a == 0) {
            return 0;
        }
        if (inventory == null) {
            return 0;
        }
        int slotCount = inventory.func_70302_i_();
        int itemSizeCounter = item.field_77994_a;
        for (int i = 0; i < slotCount && itemSizeCounter > 0; ++i) {
            if (!inventory.func_94041_b(i, item)) continue;
            ItemStack inventorySlot = inventory.func_70301_a(i);
            if (inventorySlot == null) {
                itemSizeCounter -= Math.min(Math.min(itemSizeCounter, inventory.func_70297_j_()), item.func_77976_d());
                continue;
            }
            if (!InventoryUtils.areMergeCandidates(item, inventorySlot)) continue;
            int space = inventorySlot.func_77976_d() - inventorySlot.field_77994_a;
            itemSizeCounter -= Math.min(itemSizeCounter, space);
        }
        if (itemSizeCounter != item.field_77994_a) {
            itemSizeCounter = Math.max(itemSizeCounter, 0);
            return item.field_77994_a - itemSizeCounter;
        }
        return 0;
    }

    public static Set<Integer> getAllSlots(IInventory inventory) {
        inventory = InventoryUtils.getInventory(inventory);
        HashSet<Integer> slots = new HashSet<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            slots.add(i);
        }
        return slots;
    }

    public static Map<Integer, ItemStack> getAllItems(IInventory inventory) {
        HashMap result = Maps.newHashMap();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            result.put(i, stack);
        }
        return result;
    }

    public static int moveItemsToOneOfSides(TileEntity te, IInventory inv, int fromSlot, int maxAmount, Set<ForgeDirection> sides) {
        IInventory inventory = InventoryUtils.getInventory(inv);
        if (inventory.func_70301_a(fromSlot) == null) {
            return 0;
        }
        ArrayList shuffledSides = Lists.newArrayList(sides);
        Collections.shuffle(shuffledSides);
        for (ForgeDirection dir : shuffledSides) {
            TileEntity tileOnSurface = BlockUtils.getTileInDirection(te, dir);
            if (tileOnSurface == null) {
                return 0;
            }
            int moved = InventoryUtils.moveItemInto(inventory, fromSlot, tileOnSurface, -1, maxAmount, dir, true);
            if (moved <= 0) continue;
            return moved;
        }
        return 0;
    }

    public static boolean inventoryIsEmpty(IInventory inventory) {
        int l = inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean tryMergeStacks(ItemStack stackToMerge, ItemStack stackInSlot) {
        if (stackInSlot == null || !stackInSlot.func_77969_a(stackToMerge) || !ItemStack.func_77970_a((ItemStack)stackToMerge, (ItemStack)stackInSlot)) {
            return false;
        }
        int newStackSize = stackInSlot.field_77994_a + stackToMerge.field_77994_a;
        int maxStackSize = stackToMerge.func_77976_d();
        if (newStackSize <= maxStackSize) {
            stackToMerge.field_77994_a = 0;
            stackInSlot.field_77994_a = newStackSize;
            return true;
        }
        if (stackInSlot.field_77994_a < maxStackSize) {
            stackToMerge.field_77994_a -= maxStackSize - stackInSlot.field_77994_a;
            stackInSlot.field_77994_a = maxStackSize;
            return true;
        }
        return false;
    }

    public static ItemStack returnItem(ItemStack stack) {
        return stack == null || stack.field_77994_a <= 0 ? null : stack.func_77946_l();
    }

    public static void swapStacks(IInventory inventory, int slot1, int slot2) {
        InventoryUtils.swapStacks(inventory, slot1, slot2, true, true);
    }

    public static void swapStacks(IInventory inventory, int slot1, int slot2, boolean copy, boolean validate) {
        Preconditions.checkElementIndex((int)slot1, (int)inventory.func_70302_i_(), (String)"input slot id");
        Preconditions.checkElementIndex((int)slot2, (int)inventory.func_70302_i_(), (String)"output slot id");
        ItemStack stack1 = inventory.func_70301_a(slot1);
        ItemStack stack2 = inventory.func_70301_a(slot2);
        if (validate) {
            InventoryUtils.isItemValid(inventory, slot2, stack1);
            InventoryUtils.isItemValid(inventory, slot1, stack2);
        }
        if (copy) {
            if (stack1 != null) {
                stack1 = stack1.func_77946_l();
            }
            if (stack2 != null) {
                stack2 = stack2.func_77946_l();
            }
        }
        inventory.func_70299_a(slot1, stack2);
        inventory.func_70299_a(slot2, stack1);
        inventory.func_70296_d();
    }

    public static void swapStacks(ISidedInventory inventory, int slot1, ForgeDirection side1, int slot2, ForgeDirection side2) {
        InventoryUtils.swapStacks(inventory, slot1, side1, slot2, side2, true, true);
    }

    public static void swapStacks(ISidedInventory inventory, int slot1, ForgeDirection side1, int slot2, ForgeDirection side2, boolean copy, boolean validate) {
        Preconditions.checkElementIndex((int)slot1, (int)inventory.func_70302_i_(), (String)"input slot id");
        Preconditions.checkElementIndex((int)slot2, (int)inventory.func_70302_i_(), (String)"output slot id");
        ItemStack stack1 = inventory.func_70301_a(slot1);
        ItemStack stack2 = inventory.func_70301_a(slot2);
        if (validate) {
            InventoryUtils.isItemValid((IInventory)inventory, slot2, stack1);
            InventoryUtils.isItemValid((IInventory)inventory, slot1, stack2);
            InventoryUtils.canExtract(inventory, slot1, side1, stack1);
            InventoryUtils.canInsert(inventory, slot2, side2, stack1);
            InventoryUtils.canExtract(inventory, slot2, side2, stack2);
            InventoryUtils.canInsert(inventory, slot1, side1, stack2);
        }
        if (copy) {
            if (stack1 != null) {
                stack1 = stack1.func_77946_l();
            }
            if (stack2 != null) {
                stack2 = stack2.func_77946_l();
            }
        }
        inventory.func_70299_a(slot1, stack2);
        inventory.func_70299_a(slot2, stack1);
        inventory.func_70296_d();
    }

    protected static void isItemValid(IInventory inventory, int slot, ItemStack stack) {
        Preconditions.checkArgument((boolean)inventory.func_94041_b(slot, stack), (String)"Slot %s cannot accept item", (Object[])new Object[]{slot});
    }

    protected static void canInsert(ISidedInventory inventory, int slot, ForgeDirection side, ItemStack stack) {
        Preconditions.checkArgument((boolean)inventory.func_102007_a(slot, stack, side.ordinal()), (String)"Item cannot be inserted into slot %s on side %s", (Object[])new Object[]{slot, side});
    }

    protected static void canExtract(ISidedInventory inventory, int slot, ForgeDirection side, ItemStack stack) {
        Preconditions.checkArgument((boolean)inventory.func_102008_b(slot, stack, side.ordinal()), (String)"Item cannot be extracted from slot %s on side %s", (Object[])new Object[]{slot, side});
    }
}

