/*
 * Decompiled with CFR 0.152.
 */
package openmods.shapes;

import openmods.shapes.IShapeGenerator;
import openmods.shapes.IShapeable;
import openmods.utils.render.GeometryUtils;

public class ShapeEquilateral2dGenerator
implements IShapeGenerator {
    private int sides;

    public ShapeEquilateral2dGenerator(int sides) {
        this.sides = sides;
    }

    @Override
    public void generateShape(int xSize, int ySize, int zSize, IShapeable shapeable) {
        int firstX = 0;
        int firstZ = 0;
        int previousX = 0;
        int previousZ = 0;
        for (int i = 0; i < this.sides; ++i) {
            double d = Math.PI * 2 * (double)i / (double)this.sides;
            int x = (int)Math.round(Math.cos(d) * (double)xSize);
            int z = (int)Math.round(Math.sin(d) * (double)xSize);
            if (i == 0) {
                firstX = previousX = x;
                firstZ = previousZ = z;
                continue;
            }
            GeometryUtils.line2D(0, previousX, previousZ, x, z, shapeable);
            previousX = x;
            previousZ = z;
        }
        GeometryUtils.line2D(0, previousX, previousZ, firstX, firstZ, shapeable);
    }
}

