/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.senders;

import cpw.mods.fml.common.network.FMLOutboundHandler;
import io.netty.channel.Channel;
import io.netty.util.concurrent.GenericFutureListener;
import openmods.network.senders.IPacketSender;
import openmods.network.senders.ITargetedPacketSender;
import openmods.utils.NetUtils;

public class TargetedPacketSenderBase<M, T>
implements ITargetedPacketSender<M, T> {
    private final Channel channel;

    public TargetedPacketSenderBase(Channel channel) {
        this.channel = channel;
    }

    protected void configureChannel(Channel channel, T target) {
    }

    protected void setTargetAttr(Channel channel, Object attr) {
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(attr);
    }

    @Override
    public void sendPacket(M msg, T target) {
        this.configureChannel(this.channel, target);
        this.channel.writeAndFlush(msg).addListener((GenericFutureListener)NetUtils.LOGGING_LISTENER);
    }

    @Override
    public IPacketSender<M> bind(final T target) {
        return new IPacketSender<M>(){

            @Override
            public void sendPacket(M msg) {
                TargetedPacketSenderBase.this.sendPacket(msg, target);
            }
        };
    }
}

