/*
 * Decompiled with CFR 0.152.
 */
package openmods.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.Channel;
import io.netty.channel.embedded.EmbeddedChannel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import openmods.network.DimCoord;
import openmods.network.senders.ExtPacketSenderFactory;
import openmods.network.senders.FmlPacketSenderFactory;
import openmods.network.senders.IPacketSender;
import openmods.network.senders.ITargetedPacketSender;

public abstract class Dispatcher<M> {
    protected abstract EmbeddedChannel getChannel(Side var1);

    protected EmbeddedChannel serverChannel() {
        return this.getChannel(Side.SERVER);
    }

    protected EmbeddedChannel clientChannel() {
        return this.getChannel(Side.CLIENT);
    }

    public class Senders {
        public final IPacketSender<M> client;
        public final IPacketSender<M> global;
        public final ITargetedPacketSender<M, EntityPlayer> player;
        public final ITargetedPacketSender<M, Integer> dimension;
        public final ITargetedPacketSender<M, NetworkRegistry.TargetPoint> point;
        public final ITargetedPacketSender<M, DimCoord> block;
        public final ITargetedPacketSender<M, Entity> entity;

        public Senders() {
            this.client = FmlPacketSenderFactory.createClientSender((Channel)Dispatcher.this.clientChannel());
            this.global = FmlPacketSenderFactory.createGlobalSender((Channel)Dispatcher.this.serverChannel());
            this.player = FmlPacketSenderFactory.createPlayerSender((Channel)Dispatcher.this.serverChannel());
            this.dimension = FmlPacketSenderFactory.createDimensionSender((Channel)Dispatcher.this.serverChannel());
            this.point = FmlPacketSenderFactory.createPointSender((Channel)Dispatcher.this.serverChannel());
            this.block = ExtPacketSenderFactory.createBlockSender((Channel)Dispatcher.this.serverChannel());
            this.entity = ExtPacketSenderFactory.createEntitySender((Channel)Dispatcher.this.serverChannel());
        }
    }
}

