/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component.page;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.EmptyComposite;
import openmods.gui.component.GuiComponentCraftingGrid;
import openmods.gui.component.GuiComponentItemStackSpinner;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.page.PageBase;
import openmods.gui.listener.IMouseDownListener;
import openmods.utils.RecipeUtils;
import openmods.utils.render.FakeIcon;

public class StandardRecipePage
extends PageBase {
    public static IIcon iconCraftingGrid = FakeIcon.createSheetIcon(0, 180, 56, 56);
    public static IIcon iconArrow = FakeIcon.createSheetIcon(60, 198, 48, 15);
    public static IIcon iconYoutube = FakeIcon.createSheetIcon(0, 236, 12, 8);
    private GuiComponentCraftingGrid craftingGrid;
    private GuiComponentSprite arrow;
    private GuiComponentLabel lblDescription;
    private GuiComponentLabel lblTitle;
    private GuiComponentItemStackSpinner outputSpinner;

    public StandardRecipePage(String title, String description, String videoLink, ItemStack resultingItem) {
        String translatedTitle = StatCollector.func_74838_a((String)title);
        String translatedDescription = StatCollector.func_74838_a((String)description).replaceAll("\\\\n", "\n");
        String translatedLink = StatCollector.func_74838_a((String)videoLink);
        if (videoLink != "" && !videoLink.equals(translatedLink)) {
            this.addComponent(StandardRecipePage.createYoutubeButton(25, 146, translatedLink));
        }
        this.lblTitle = new GuiComponentLabel((this.getWidth() - Minecraft.func_71410_x().field_71466_p.func_78256_a(translatedTitle)) / 2, 12, translatedTitle);
        this.lblDescription = new GuiComponentLabel(27, 95, 340, 51, translatedDescription);
        this.arrow = new GuiComponentSprite(90, 50, iconArrow, BOOK_TEXTURE);
        this.craftingGrid = new GuiComponentCraftingGrid(25, 30, RecipeUtils.getFirstRecipeForItem(resultingItem), iconCraftingGrid, BOOK_TEXTURE);
        this.lblDescription.setScale(0.5f);
        this.lblDescription.setAdditionalLineHeight(4);
        this.outputSpinner = new GuiComponentItemStackSpinner(150, 40, resultingItem);
        this.addComponent(this.lblDescription);
        this.addComponent(this.lblTitle);
        this.addComponent(this.arrow);
        this.addComponent(this.outputSpinner);
        this.addComponent(this.craftingGrid);
    }

    private static void openURI(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static BaseComponent createYoutubeButton(int x, int y, final String link) {
        EmptyComposite result = new EmptyComposite(x, y, 50, 8);
        GuiComponentLabel label = new GuiComponentLabel(15, 2, StatCollector.func_74838_a((String)"openblocks.gui.watch_video"));
        label.setScale(0.5f);
        result.addComponent(label);
        GuiComponentSprite image = new GuiComponentSprite(0, 0, iconYoutube, BOOK_TEXTURE);
        result.addComponent(image);
        final URI uri = URI.create(link);
        result.setListener(new IMouseDownListener(){

            @Override
            public void componentMouseDown(BaseComponent component, int x, int y, int button) {
                final Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71474_y.field_74358_q) {
                    final GuiScreen prevGui = mc.field_71462_r;
                    mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink(new GuiYesNoCallback(){

                        public void func_73878_a(boolean result, int id) {
                            if (result) {
                                StandardRecipePage.openURI(uri);
                            }
                            mc.func_147108_a(prevGui);
                        }
                    }, link, 0, false));
                } else {
                    StandardRecipePage.openURI(uri);
                }
            }
        });
        return result;
    }
}

