/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.game;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import openmods.Log;
import openmods.config.BlockInstances;
import openmods.config.InstanceContainer;
import openmods.config.ItemInstances;
import openmods.config.game.AbstractFeatureManager;
import openmods.config.game.FactoryRegistry;
import openmods.config.game.IRegisterableBlock;
import openmods.config.game.IgnoreFeature;
import openmods.config.game.RegisterBlock;
import openmods.config.game.RegisterItem;

public class GameConfigProvider {
    private static final AbstractFeatureManager NULL_FEATURE_MANAGER = new AbstractFeatureManager(){

        @Override
        public boolean isEnabled(String category, String name) {
            return true;
        }
    };
    private AbstractFeatureManager features = NULL_FEATURE_MANAGER;
    private boolean remapFromLegacy = true;
    private final FactoryRegistry<Block> blockFactory = new FactoryRegistry();
    private final FactoryRegistry<Item> itemFactory = new FactoryRegistry();
    private final Map<String, Item> itemRemaps = Maps.newHashMap();
    private final Map<String, Block> blockRemaps = Maps.newHashMap();
    private final String modPrefix;
    private final String modId;

    public GameConfigProvider(String modPrefix) {
        this.modPrefix = modPrefix;
        ModContainer mod = Loader.instance().activeModContainer();
        Preconditions.checkNotNull((Object)mod, (Object)"This class can only be initialized in mod init");
        this.modId = mod.getModId();
    }

    public void setFeatures(AbstractFeatureManager features) {
        this.features = features;
    }

    public void setRemapFromLegacy(boolean remapFromLegacy) {
        this.remapFromLegacy = remapFromLegacy;
    }

    public FactoryRegistry<Block> getBlockFactory() {
        return this.blockFactory;
    }

    public FactoryRegistry<Item> getItemFactory() {
        return this.itemFactory;
    }

    private static <I, A extends Annotation> void processAnnotations(Class<? extends InstanceContainer<?>> config, Class<I> fieldClass, Class<A> annotationClass, FactoryRegistry<I> factory, IAnnotationProcessor<I, A> processor) {
        for (Field f : config.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !fieldClass.isAssignableFrom(f.getType()) || f.isAnnotationPresent(IgnoreFeature.class)) continue;
            A annotation = f.getAnnotation(annotationClass);
            if (annotation == null) {
                Log.warn("Field %s has valid type %s for registration, but no annotation %s", f, fieldClass, annotationClass);
                continue;
            }
            String name = processor.getEntryName(annotation);
            if (!processor.isEnabled(name)) {
                Log.info("Item %s (from field %s) is disabled", name, f);
                continue;
            }
            Class<?> fieldType = f.getType();
            Object entry = factory.construct(name, fieldType);
            if (entry == null) continue;
            try {
                f.set(null, entry);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            processor.process(entry, annotation);
        }
    }

    private static String dotName(String a, String b) {
        return a + "." + b;
    }

    private static String underscoreName(String a, String b) {
        return a + "_" + b;
    }

    public void registerItems(Class<? extends ItemInstances> klazz) {
        GameConfigProvider.processAnnotations(klazz, Item.class, RegisterItem.class, this.itemFactory, new IAnnotationProcessor<Item, RegisterItem>(){

            @Override
            public void process(Item item, RegisterItem annotation) {
                String name = annotation.name();
                String unlocalizedName = annotation.unlocalizedName();
                String prefixedName = GameConfigProvider.dotName(GameConfigProvider.this.modPrefix, name);
                if (GameConfigProvider.this.remapFromLegacy) {
                    GameRegistry.registerItem((Item)item, (String)name);
                    GameConfigProvider.this.itemRemaps.put(GameConfigProvider.this.modId + ":" + prefixedName, item);
                } else {
                    GameRegistry.registerItem((Item)item, (String)prefixedName);
                }
                if (!unlocalizedName.equals("[none]")) {
                    unlocalizedName = unlocalizedName.equals("[default]") ? prefixedName : GameConfigProvider.dotName(GameConfigProvider.this.modPrefix, unlocalizedName);
                    item.func_77655_b(unlocalizedName);
                }
            }

            @Override
            public String getEntryName(RegisterItem annotation) {
                return annotation.name();
            }

            @Override
            public boolean isEnabled(String name) {
                return GameConfigProvider.this.features.isItemEnabled(name);
            }
        });
    }

    public void registerBlocks(Class<? extends BlockInstances> klazz) {
        GameConfigProvider.processAnnotations(klazz, Block.class, RegisterBlock.class, this.blockFactory, new IAnnotationProcessor<Block, RegisterBlock>(){

            @Override
            public void process(Block block, RegisterBlock annotation) {
                String name = annotation.name();
                Class<? extends ItemBlock> itemBlockClass = annotation.itemBlock();
                Class<? extends TileEntity> teClass = annotation.tileEntity();
                if (teClass == TileEntity.class) {
                    teClass = null;
                }
                String prefixedName = GameConfigProvider.underscoreName(GameConfigProvider.this.modPrefix, name);
                if (GameConfigProvider.this.remapFromLegacy) {
                    GameRegistry.registerBlock((Block)block, itemBlockClass, (String)name);
                    GameConfigProvider.this.blockRemaps.put(GameConfigProvider.this.modId + ":" + prefixedName, block);
                } else {
                    GameRegistry.registerBlock((Block)block, itemBlockClass, (String)prefixedName);
                }
                String unlocalizedName = annotation.unlocalizedName();
                if (!unlocalizedName.equals("[none]")) {
                    unlocalizedName = unlocalizedName.equals("[default]") ? GameConfigProvider.dotName(GameConfigProvider.this.modPrefix, name) : GameConfigProvider.dotName(GameConfigProvider.this.modPrefix, unlocalizedName);
                    block.func_149663_c(unlocalizedName);
                }
                if (teClass != null) {
                    GameRegistry.registerTileEntity(teClass, (String)prefixedName);
                }
                if (block instanceof IRegisterableBlock) {
                    ((IRegisterableBlock)block).setupBlock(GameConfigProvider.this.modPrefix, name, teClass, itemBlockClass);
                }
                for (RegisterBlock.RegisterTileEntity te : annotation.tileEntities()) {
                    String teName = GameConfigProvider.underscoreName(GameConfigProvider.this.modPrefix, te.name());
                    GameRegistry.registerTileEntity(te.cls(), (String)teName);
                }
            }

            @Override
            public String getEntryName(RegisterBlock annotation) {
                return annotation.name();
            }

            @Override
            public boolean isEnabled(String name) {
                return GameConfigProvider.this.features.isBlockEnabled(name);
            }
        });
    }

    public void handleRemaps(Collection<FMLMissingMappingsEvent.MissingMapping> mappings) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : mappings) {
            switch (mapping.type) {
                case BLOCK: {
                    Block remap = this.blockRemaps.get(mapping.name);
                    if (remap == null) break;
                    mapping.remap(remap);
                    break;
                }
                case ITEM: {
                    Block blockRemap;
                    Block remap = this.itemRemaps.get(mapping.name);
                    if (remap == null && (blockRemap = this.blockRemaps.get(mapping.name)) != null) {
                        remap = Item.func_150898_a((Block)blockRemap);
                    }
                    if (remap == null) break;
                    mapping.remap((Item)remap);
                }
            }
        }
    }

    private static interface IAnnotationProcessor<I, A extends Annotation> {
        public void process(I var1, A var2);

        public String getEntryName(A var1);

        public boolean isEnabled(String var1);
    }
}

