/*
 * Decompiled with CFR 0.152.
 */
package gcewing.lighting;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.lighting.BaseConfiguration;
import gcewing.lighting.BaseIntegration;
import gcewing.lighting.BaseModClient;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BaseMod<CLIENT extends BaseModClient<? extends BaseMod>>
extends BaseIntegration
implements IGuiHandler {
    public String modID;
    public BaseConfiguration config;
    public String modPackage;
    public String assetKey;
    public String resourceDir;
    public URL resourceURL;
    public CLIENT client;
    public IGuiHandler proxy;
    public boolean serverSide;
    public boolean clientSide;
    public CreativeTabs creativeTab;
    public boolean debugGui;
    File cfgFile;
    List<IBlock> registeredBlocks = new ArrayList<IBlock>();
    List<BaseIntegration> integrations = new ArrayList<BaseIntegration>();
    public List<VSBinding> registeredVillagers = new ArrayList<VSBinding>();
    Map<Integer, Class<? extends Container>> containerClasses = new HashMap<Integer, Class<? extends Container>>();

    public void setModOf(Object object) {
        if (object instanceof ISetMod) {
            ((ISetMod)object).setMod(this);
        }
    }

    public String resourcePath(String string) {
        return this.resourceDir + string;
    }

    public BaseMod() {
        Class<?> clazz = this.getClass();
        this.modPackage = clazz.getPackage().getName();
        this.assetKey = this.modPackage.replace(".", "_");
        this.modID = BaseMod.getModID(clazz);
        String string = "assets/" + this.assetKey + "/";
        this.resourceDir = "/" + string;
        this.resourceURL = this.getClass().getClassLoader().getResource(string);
        this.integrations.add(this);
    }

    static String getModID(Class clazz) {
        Mod mod = clazz.getAnnotation(Mod.class);
        if (mod instanceof Mod) {
            return mod.modid();
        }
        System.out.printf("BaseMod: Mod annotation not found\n", new Object[0]);
        return "<unknown>";
    }

    public static boolean isModLoaded(String string) {
        return Loader.isModLoaded((String)string);
    }

    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        this.serverSide = fMLPreInitializationEvent.getSide().isServer();
        this.clientSide = fMLPreInitializationEvent.getSide().isClient();
        if (this.clientSide) {
            this.client = this.initClient();
            this.proxy = this.client;
        }
        this.cfgFile = fMLPreInitializationEvent.getSuggestedConfigurationFile();
        this.loadConfig();
        this.configure();
        if (this.client != null) {
            ((BaseModClient)this.client).preInit(fMLPreInitializationEvent);
        }
        for (BaseIntegration baseIntegration : this.integrations) {
            baseIntegration.registerBlocks();
            baseIntegration.registerTileEntities();
            baseIntegration.registerItems();
            baseIntegration.registerOres();
        }
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (this.client != null) {
            ((BaseModClient)this.client).init(fMLInitializationEvent);
        }
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        for (BaseIntegration baseIntegration : this.integrations) {
            baseIntegration.registerRecipes();
            baseIntegration.registerRandomItems();
            baseIntegration.registerWorldGenerators();
            baseIntegration.registerContainers();
            baseIntegration.registerEntities();
            baseIntegration.registerVillagers();
            baseIntegration.registerOther();
        }
        if (this.client != null) {
            ((BaseModClient)this.client).postInit(fMLPostInitializationEvent);
        }
        if (this.proxy == null) {
            this.proxy = this;
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, this.proxy);
        this.saveConfig();
    }

    void loadConfig() {
        this.config = new BaseConfiguration(this.cfgFile);
    }

    void saveConfig() {
        if (this.config.extended) {
            this.config.save();
        }
    }

    String qualifiedName(String string) {
        return this.modPackage + "." + string;
    }

    void configure() {
    }

    CLIENT initClient() {
        return (CLIENT)new BaseModClient<BaseMod>(this);
    }

    public BaseIntegration integrateWith(String string, String string2) {
        BaseIntegration baseIntegration = null;
        if (BaseMod.isModLoaded(string)) {
            baseIntegration = this.newIntegration(string2);
            this.integrations.add(baseIntegration);
        }
        return baseIntegration;
    }

    BaseIntegration newIntegration(String string) {
        try {
            return (BaseIntegration)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Item newItem(String string) {
        return this.newItem(string, Item.class);
    }

    public <ITEM extends Item> ITEM newItem(String string, Class<ITEM> clazz) {
        Item item;
        try {
            Constructor<ITEM> constructor = clazz.getConstructor(new Class[0]);
            item = (Item)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return (ITEM)this.addItem(item, string);
    }

    public <ITEM extends Item> ITEM addItem(ITEM ITEM, String string) {
        String string2 = this.assetKey + ":" + string;
        ITEM.func_77655_b(string2);
        ITEM.func_111206_d(string2);
        GameRegistry.registerItem(ITEM, (String)string);
        System.out.printf("BaseMod.addItem: Registered %s as %s\n", ITEM, string);
        if (this.creativeTab != null) {
            System.out.printf("BaseMod.addItem: Setting creativeTab to %s\n", this.creativeTab);
            ITEM.func_77637_a(this.creativeTab);
        }
        return ITEM;
    }

    public Block newBlock(String string) {
        return this.newBlock(string, Block.class);
    }

    public <BLOCK extends Block> BLOCK newBlock(String string, Class<BLOCK> clazz) {
        return this.newBlock(string, clazz, ItemBlock.class);
    }

    public <BLOCK extends Block> BLOCK newBlock(String string, Class<BLOCK> clazz, Class clazz2) {
        Block block;
        try {
            Constructor<BLOCK> constructor = clazz.getConstructor(new Class[0]);
            block = (Block)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return (BLOCK)this.addBlock(block, string, clazz2);
    }

    public <BLOCK extends Block> BLOCK addBlock(BLOCK BLOCK, String string) {
        return this.addBlock(BLOCK, string, ItemBlock.class);
    }

    public <BLOCK extends Block> BLOCK addBlock(BLOCK BLOCK, String string, Class clazz) {
        String string2 = this.assetKey + ":" + string;
        BLOCK.func_149663_c(string2);
        BLOCK.func_149658_d(string2);
        System.out.printf("BaseMod.addBlock: name '%s' qualName '%s' %s\n", string, string2, BLOCK);
        GameRegistry.registerBlock(BLOCK, (Class)clazz, (String)string);
        if (this.creativeTab != null) {
            System.out.printf("BaseMod.addBlock: Setting creativeTab to %s\n", this.creativeTab);
            BLOCK.func_149647_a(this.creativeTab);
        }
        if (BLOCK instanceof IBlock) {
            this.registeredBlocks.add((IBlock)BLOCK);
        }
        return BLOCK;
    }

    public void addOre(String string, Block block) {
        OreDictionary.registerOre((String)string, (ItemStack)new ItemStack(block));
    }

    public void addOre(String string, Item item) {
        OreDictionary.registerOre((String)string, (Item)item);
    }

    public static boolean blockMatchesOre(Block block, String string) {
        return BaseMod.stackMatchesOre(new ItemStack(block), string);
    }

    public static boolean itemMatchesOre(Item item, String string) {
        return BaseMod.stackMatchesOre(new ItemStack(item), string);
    }

    public static boolean stackMatchesOre(ItemStack itemStack, String string) {
        int n = OreDictionary.getOreID((ItemStack)itemStack);
        return n == OreDictionary.getOreID((String)string);
    }

    public void newRecipe(Item item, int n, Object ... objectArray) {
        this.newRecipe(new ItemStack(item, n), objectArray);
    }

    public void newRecipe(Block block, int n, Object ... objectArray) {
        this.newRecipe(new ItemStack(block, n), objectArray);
    }

    public void newRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, objectArray));
    }

    public void newShapelessRecipe(Block block, int n, Object ... objectArray) {
        this.newShapelessRecipe(new ItemStack(block, n), objectArray);
    }

    public void newShapelessRecipe(Item item, int n, Object ... objectArray) {
        this.newShapelessRecipe(new ItemStack(item, n), objectArray);
    }

    public void newShapelessRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemStack, objectArray));
    }

    public void newSmeltingRecipe(Item item, int n, Item item2) {
        this.newSmeltingRecipe(item, n, item2, 0);
    }

    public void newSmeltingRecipe(Item item, int n, Item item2, int n2) {
        GameRegistry.addSmelting((Item)item2, (ItemStack)new ItemStack(item, n), (float)n2);
    }

    public void newSmeltingRecipe(Item item, int n, Block block) {
        this.newSmeltingRecipe(item, n, block, 0);
    }

    public void newSmeltingRecipe(Item item, int n, Block block, int n2) {
        GameRegistry.addSmelting((Block)block, (ItemStack)new ItemStack(item, n), (float)n2);
    }

    public void addRandomChestItem(ItemStack itemStack, int n, int n2, int n3, String ... stringArray) {
        WeightedRandomChestContent weightedRandomChestContent = new WeightedRandomChestContent(itemStack, n, n2, n3);
        for (int i = 0; i < stringArray.length; ++i) {
            ChestGenHooks.addItem((String)stringArray[i], (WeightedRandomChestContent)weightedRandomChestContent);
        }
    }

    public void addEntity(Class<? extends Entity> clazz, String string, Enum enum_) {
        this.addEntity(clazz, string, enum_.ordinal());
    }

    public void addEntity(Class<? extends Entity> clazz, String string, int n) {
        this.addEntity(clazz, string, n, 1, true);
    }

    public void addEntity(Class<? extends Entity> clazz, String string, Enum enum_, int n, boolean bl) {
        this.addEntity(clazz, string, enum_.ordinal(), n, bl);
    }

    public void addEntity(Class<? extends Entity> clazz, String string, int n, int n2, boolean bl) {
        System.out.printf("%s: BaseMod.addEntity: %s, \"%s\", %s\n", this.getClass().getSimpleName(), clazz.getSimpleName(), string, n);
        EntityRegistry.registerModEntity(clazz, (String)string, (int)n, (Object)this, (int)256, (int)n2, (boolean)bl);
    }

    int addVillager(String string, ResourceLocation resourceLocation) {
        int n = this.config.getVillager(string);
        VSBinding vSBinding = new VSBinding();
        vSBinding.id = n;
        vSBinding.object = resourceLocation;
        this.registeredVillagers.add(vSBinding);
        return n;
    }

    void addTradeHandler(int n, VillagerRegistry.IVillageTradeHandler iVillageTradeHandler) {
        VillagerRegistry.instance().registerVillageTradeHandler(n, iVillageTradeHandler);
    }

    public ResourceLocation resourceLocation(String string) {
        return new ResourceLocation(this.assetKey, string);
    }

    public String soundName(String string) {
        return this.assetKey + ":" + string;
    }

    public ResourceLocation textureLocation(String string) {
        return this.resourceLocation("textures/" + string);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IIconRegister iIconRegister, String string) {
        return iIconRegister.func_94245_a(this.assetKey + ":" + string);
    }

    public Set<String> listResources(String string) {
        try {
            HashSet<String> hashSet = new HashSet<String>();
            if (this.resourceURL != null) {
                String string2 = this.resourceURL.getProtocol();
                if (string2.equals("jar")) {
                    String string3 = this.resourceURL.getPath();
                    int n = string3.lastIndexOf("!");
                    URL uRL = new URL(string3.substring(0, n));
                    String string4 = string3.substring(n + 2);
                    String string5 = string4 + string + "/";
                    JarFile jarFile = new JarFile(new File(uRL.toURI()));
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        String string6 = enumeration.nextElement().getName();
                        if (!string6.startsWith(string5) || string6.endsWith("/") || string6.contains("/.")) continue;
                        hashSet.add(string6.substring(string5.length()));
                    }
                } else {
                    throw new RuntimeException("Resource URL protocol " + string2 + " not supported");
                }
            }
            return hashSet;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected void registerContainers() {
    }

    public void addContainer(Enum enum_, Class<? extends Container> clazz) {
        this.addContainer(enum_.ordinal(), clazz);
    }

    public void addContainer(int n, Class<? extends Container> clazz) {
        this.containerClasses.put(n, clazz);
    }

    public void openGui(EntityPlayer entityPlayer, Enum enum_, World world, int n, int n2, int n3) {
        this.openGui(entityPlayer, enum_.ordinal(), world, n, n2, n3);
    }

    public void openGui(EntityPlayer entityPlayer, int n, World world, int n2, int n3, int n4) {
        if (this.debugGui) {
            System.out.printf("BaseMod.openGui: for %s with id %s in %s at (%s, %s, %s)\n", this, n, world, n2, n3, n4);
        }
        entityPlayer.openGui((Object)this, n, world, n2, n3, n4);
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        Class<? extends Container> clazz;
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: for id %s\n", n);
        }
        Object object = (clazz = this.containerClasses.get(n)) != null ? this.createGuiElement(clazz, entityPlayer, world, n2, n3, n4) : this.getGuiContainer(n, entityPlayer, world, n2, n3, n4);
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: Returning %s\n", object);
        }
        this.setModOf(object);
        return object;
    }

    Container getGuiContainer(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        if (this.debugGui) {
            System.out.printf("%s: BaseMod.getGuiContainer: No Container class found for gui id %d\n", this, n);
        }
        return null;
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return null;
    }

    Object createGuiElement(Class clazz, EntityPlayer entityPlayer, World world, int n, int n2, int n3) {
        try {
            try {
                if (this.debugGui) {
                    System.out.printf("BaseMod.createGuiElement: Invoking create method of %s for %s in %s\n", clazz, entityPlayer, world);
                }
                return clazz.getMethod("create", EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, entityPlayer, world, n, n2, n3);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (this.debugGui) {
                    System.out.printf("BaseMod.createGuiElement: Invoking constructor of %s\n", clazz);
                }
                return clazz.getConstructor(EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(entityPlayer, world, n, n2, n3);
            }
        }
        catch (Exception exception) {
            BaseMod.reportExceptionCause(exception);
            return null;
        }
    }

    public static void reportExceptionCause(Exception exception) {
        Throwable throwable = exception.getCause();
        System.out.printf("BaseMod.createGuiElement: %s: %s\n", exception, throwable);
        if (throwable != null) {
            throwable.printStackTrace();
        } else {
            exception.printStackTrace();
        }
    }

    static class VSBinding
    extends IDBinding<ResourceLocation> {
        VSBinding() {
        }
    }

    static class IDBinding<T> {
        public int id;
        public T object;

        IDBinding() {
        }
    }

    static interface ISetMod {
        public void setMod(BaseMod var1);
    }

    static interface ITileEntity {
        public void onAddedToWorld();
    }

    static interface IBlock {
        public void setRenderType(int var1);

        public String getQualifiedRendererClassName();
    }
}

