/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import info.jbcs.minecraft.chisel.init.ModBlocks;
import info.jbcs.minecraft.chisel.utils.Drawing;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class BlockSpikesRenderer
implements ISimpleBlockRenderingHandler {
    public static int id;

    public BlockSpikesRenderer() {
        id = RenderingRegistry.getNextAvailableRenderId();
    }

    public void renderInventoryBlock(Block block, int meta, int modelID, RenderBlocks renderer) {
        Drawing.drawBlock(block, meta, renderer);
    }

    void drawSpike(IIcon icon, double r, double h, double x, double y, double z, double dx, double dz) {
        Tessellator tessellator = Tessellator.field_78398_a;
        double u0 = icon.func_94209_e();
        double u1 = icon.func_94212_f();
        double v0 = icon.func_94210_h();
        double v1 = icon.func_94206_g();
        double tx = x + dx;
        double ty = y + h;
        double tz = z + dz;
        tessellator.func_78374_a(x + r, y + 0.0, z + r, u0, v0);
        tessellator.func_78374_a(x + r, y + 0.0, z - r, u1, v0);
        tessellator.func_78374_a(tx, ty, tz, u1, v1);
        tessellator.func_78374_a(tx, ty, tz, u0, v1);
        tessellator.func_78374_a(x - r, y + 0.0, z + r, u1, v0);
        tessellator.func_78374_a(x + r, y + 0.0, z + r, u0, v0);
        tessellator.func_78374_a(tx, ty, tz, u1, v1);
        tessellator.func_78374_a(tx, ty, tz, u0, v1);
        tessellator.func_78374_a(x + r, y + 0.0, z - r, u1, v0);
        tessellator.func_78374_a(x - r, y + 0.0, z - r, u0, v0);
        tessellator.func_78374_a(tx, ty, tz, u1, v1);
        tessellator.func_78374_a(tx, ty, tz, u0, v1);
        tessellator.func_78374_a(x - r, y + 0.0, z - r, u1, v0);
        tessellator.func_78374_a(x - r, y + 0.0, z + r, u0, v0);
        tessellator.func_78374_a(tx, ty, tz, u1, v1);
        tessellator.func_78374_a(tx, ty, tz, u0, v1);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.func_147784_q(block, x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon icon = ModBlocks.spikeTrap.iconSpike;
        double d = 0.09375;
        double r = d / 2.0;
        double skew = 0.5;
        tessellator.func_78372_c(0.0f, 0.0625f, 0.0f);
        Random rand = new Random();
        for (int xx = 0; xx < 4; ++xx) {
            for (int yy = 0; yy < 4; ++yy) {
                float sx = (2.0f + (12.0f - (float)d) * (float)xx / 3.0f) / 16.0f;
                float sz = (2.0f + (12.0f - (float)d) * (float)yy / 3.0f) / 16.0f;
                tessellator.func_78372_c(sx, 0.0f, sz);
                this.drawSpike(icon, r, 0.5 + rand.nextDouble() * 0.35, x, y, z, rand.nextDouble() * skew - skew / 2.0, rand.nextDouble() * skew - skew / 2.0);
                tessellator.func_78372_c(-sx, 0.0f, -sz);
            }
        }
        tessellator.func_78372_c(0.0f, -0.0625f, 0.0f);
        return true;
    }

    public boolean shouldRender3DInInventory(int renderId) {
        return true;
    }

    public int getRenderId() {
        return id;
    }
}

