/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import info.jbcs.minecraft.chisel.Chisel;
import info.jbcs.minecraft.chisel.api.ICarvable;
import info.jbcs.minecraft.chisel.block.tileentity.TileEntityPresent;
import info.jbcs.minecraft.chisel.carving.CarvableHelper;
import info.jbcs.minecraft.chisel.carving.CarvableVariation;
import info.jbcs.minecraft.chisel.init.ModTabs;
import info.jbcs.minecraft.chisel.inventory.InventoryLargePresent;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPresent
extends BlockContainer
implements ICarvable {
    private final Random random = new Random();
    public CarvableHelper carverHelper = new CarvableHelper();
    private boolean isChristmas = true;

    public BlockPresent() {
        super(Material.field_151575_d);
        this.func_149647_a(ModTabs.tabChiselBlocks);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 875.0f, 0.9365f);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 25 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    private static boolean isCatSittingOnMe(World world, int x, int y, int z) {
        Entity entity;
        EntityOcelot ocelot;
        Iterator iterator = world.func_72872_a(EntityOcelot.class, AxisAlignedBB.func_72330_a((double)x, (double)(y + 1), (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1))).iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(ocelot = (EntityOcelot)(entity = (Entity)iterator.next())).func_70906_o());
        return true;
    }

    public ResourceLocation getResourceSingle(int metadata) {
        if (this.isChristmas) {
            switch (metadata) {
                case 1: {
                    return new ResourceLocation("chisel", "textures/blocks/present/red.png");
                }
            }
            return null;
        }
        switch (metadata) {
            case 1: {
                return new ResourceLocation("chisel", "textures/blocks/present/crate.png");
            }
        }
        return null;
    }

    public ResourceLocation getResourceDouble(int metadata) {
        if (this.isChristmas) {
            switch (metadata) {
                case 1: {
                    return new ResourceLocation("chisel", "textures/blocks/presentDouble/red.png");
                }
            }
            return null;
        }
        switch (metadata) {
            case 1: {
                return new ResourceLocation("chisel", "textures/blocks/presentDouble/crate.png");
            }
        }
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        Block front = world.func_147439_a(x, y, z - 1);
        Block back = world.func_147439_a(x, y, z + 1);
        Block left = world.func_147439_a(x - 1, y, z);
        Block right = world.func_147439_a(x + 1, y, z);
        int metadata = 0;
        int rot = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (rot == 0) {
            metadata = 2;
        }
        if (rot == 1) {
            metadata = 5;
        }
        if (rot == 2) {
            metadata = 3;
        }
        if (rot == 3) {
            metadata = 4;
        }
        if (front != this && back != this && left != this && right != this) {
            world.func_72921_c(x, y, z, metadata, 3);
        } else {
            if (!(front != this && back != this || metadata != 4 && metadata != 5)) {
                if (front == this) {
                    world.func_72921_c(x, y, z - 1, metadata, 3);
                } else {
                    world.func_72921_c(x, y, z + 1, metadata, 3);
                }
                world.func_72921_c(x, y, z, metadata, 3);
            }
            if (!(left != this && right != this || metadata != 4 && metadata != 5)) {
                if (left == this) {
                    world.func_72921_c(x - 1, y, z, metadata, 3);
                } else {
                    world.func_72921_c(x + 1, y, z, metadata, 3);
                }
                world.func_72921_c(x, y, z, metadata, 3);
            }
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        int l = 0;
        if (world.func_147439_a(x - 1, y, z) == this) {
            ++l;
        }
        if (world.func_147439_a(x + 1, y, z) == this) {
            ++l;
        }
        if (world.func_147439_a(x, y, z - 1) == this) {
            ++l;
        }
        if (world.func_147439_a(x, y, z + 1) == this) {
            ++l;
        }
        return l > 1 ? false : (this.areSurroundingBlocksMe(world, x, y - 1, z) ? false : (this.areSurroundingBlocksMe(world, x, y + 1, z) ? false : (this.areSurroundingBlocksMe(world, x, y, z - 1) ? false : !this.areSurroundingBlocksMe(world, x, y, z + 1))));
    }

    private boolean areSurroundingBlocksMe(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) != this ? false : (world.func_147439_a(x - 1, y, z) == this ? true : (world.func_147439_a(x + 1, y, z) == this ? true : (world.func_147439_a(x, y, z - 1) == this ? true : world.func_147439_a(x, y, z + 1) == this)));
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        super.func_149695_a(world, x, y, z, neighbor);
        TileEntityPresent tileEntityPresent = (TileEntityPresent)world.func_147438_o(x, y, z);
        if (tileEntityPresent != null) {
            tileEntityPresent.func_145836_u();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block present, int meta) {
        TileEntityPresent tileEntityPresent = (TileEntityPresent)world.func_147438_o(x, y, z);
        if (tileEntityPresent != null) {
            for (int c = 0; c < tileEntityPresent.func_70302_i_(); ++c) {
                ItemStack itemStack = tileEntityPresent.func_70301_a(c);
                if (itemStack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemStack.field_77994_a > 0) {
                    int stack = this.random.nextInt(21) + 10;
                    if (stack > itemStack.field_77994_a) {
                        stack = itemStack.field_77994_a;
                    }
                    itemStack.field_77994_a -= stack;
                    EntityItem entityItem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemStack.func_77973_b(), stack, itemStack.func_77960_j()));
                    float motion = 0.05f;
                    entityItem.field_70159_w = this.random.nextGaussian() * (double)motion;
                    entityItem.field_70181_x = this.random.nextGaussian() * (double)motion + (double)0.2f;
                    entityItem.field_70179_y = this.random.nextGaussian() * (double)motion;
                    if (itemStack.func_77942_o()) {
                        entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityItem);
                }
            }
            world.func_147453_f(x, y, z, (Block)this);
        }
        super.func_149749_a(world, x, y, z, (Block)this, meta);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int meta, float x1, float y1, float z1) {
        if (!world.field_72995_K) {
            player.openGui((Object)Chisel.instance, 2, world, x, y, z);
            return true;
        }
        return true;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z - 1) == this) {
            this.func_149676_a(0.0625f, 0.0f, 0.0f, 0.9375f, 0.875f, 0.9375f);
        } else if (world.func_147439_a(x, y, z + 1) == this) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        } else if (world.func_147439_a(x - 1, y, z) == this) {
            this.func_149676_a(0.0f, 0.0f, 0.0625f, 0.9375f, 0.875f, 1.0f);
        } else if (world.func_147439_a(x + 1, y, z) == this) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 1.0f, 0.875f, 0.9375f);
        } else {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.changeMetadataBasedOffSpecs(world, x, y, z);
        Block back = world.func_147439_a(x, y, z - 1);
        Block front = world.func_147439_a(x, y, z + 1);
        Block left = world.func_147439_a(x - 1, y, z);
        Block right = world.func_147439_a(x + 1, y, z);
        if (back == this) {
            this.changeMetadataBasedOffSpecs(world, x, y, z - 1);
        }
        if (front == this) {
            this.changeMetadataBasedOffSpecs(world, x, y, z + 1);
        }
        if (left == this) {
            this.changeMetadataBasedOffSpecs(world, x - 1, y, z);
        }
        if (right == this) {
            this.changeMetadataBasedOffSpecs(world, x + 1, y, z);
        }
    }

    public void changeMetadataBasedOffSpecs(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block back = world.func_147439_a(x, y, z - 1);
            Block front = world.func_147439_a(x, y, z + 1);
            Block left = world.func_147439_a(x - 1, y, z);
            Block right = world.func_147439_a(x + 1, y, z);
            boolean flag = true;
            if (front != this && back != this) {
                int metadata;
                if (left != this && right != this) {
                    metadata = 3;
                    if (front.func_149730_j() && !back.func_149730_j()) {
                        metadata = 3;
                    }
                    if (back.func_149730_j() && !front.func_149730_j()) {
                        metadata = 2;
                    }
                    if (left.func_149730_j() && !right.func_149730_j()) {
                        metadata = 5;
                    }
                    if (right.func_149730_j() && !left.func_149730_j()) {
                        metadata = 4;
                    }
                } else {
                    int x1 = back == this ? x - 1 : x + 1;
                    Block backLeft = world.func_147439_a(x1, y, z - 1);
                    int z1 = back == this ? z - 1 : z + 1;
                    Block frontRight = world.func_147439_a(x + 1, y, z1);
                    metadata = 5;
                    boolean flag1 = true;
                    int blockMeta = back == this ? world.func_72805_g(x, y, z - 1) : world.func_72805_g(x, y, z + 1);
                    if (blockMeta == 4) {
                        metadata = 4;
                    }
                    if ((left.func_149730_j() || backLeft.func_149730_j()) && !right.func_149730_j() && !frontRight.func_149730_j()) {
                        metadata = 5;
                    }
                    if ((right.func_149730_j() || frontRight.func_149730_j()) && !left.func_149730_j() && !backLeft.func_149730_j()) {
                        metadata = 4;
                    }
                }
                world.func_72921_c(x, y, z, metadata, 3);
            }
        }
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityPresent();
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int strength) {
        if (!this.func_149744_f()) {
            return 0;
        }
        int players = ((TileEntityPresent)world.func_147438_o((int)x, (int)y, (int)z)).field_145987_o;
        return MathHelper.func_76125_a((int)players, (int)0, (int)15);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int strength) {
        return strength == 1 ? this.func_149709_b(world, x, y, z, strength) : 0;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int strength) {
        return Container.func_94526_b((IInventory)this.getInventory(world, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("planks_oak");
    }

    public IInventory getInventory(World world, int x, int y, int z) {
        Object object = (TileEntityPresent)world.func_147438_o(x, y, z);
        if (object == null) {
            return null;
        }
        if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) {
            return null;
        }
        if (BlockPresent.isCatSittingOnMe(world, x, y, z)) {
            return null;
        }
        if (world.func_147439_a(x - 1, y, z) == this && (world.isSideSolid(x - 1, y + 1, z, ForgeDirection.DOWN) || BlockPresent.isCatSittingOnMe(world, x, y - 1, z))) {
            return null;
        }
        if (world.func_147439_a(x + 1, y, z) == this && (world.isSideSolid(x + 1, y + 1, z, ForgeDirection.DOWN) || BlockPresent.isCatSittingOnMe(world, x, y + 1, z))) {
            return null;
        }
        if (world.func_147439_a(x, y, z - 1) == this && (world.isSideSolid(x, y + 1, z - 1, ForgeDirection.DOWN) || BlockPresent.isCatSittingOnMe(world, x, y, z - 1))) {
            return null;
        }
        if (world.func_147439_a(x, y, z + 1) == this && (world.isSideSolid(x, y + 1, z + 1, ForgeDirection.DOWN) || BlockPresent.isCatSittingOnMe(world, x, y, z + 1))) {
            return null;
        }
        if (world.func_147439_a(x - 1, y, z) == this) {
            object = new InventoryLargePresent("container.chestDouble", (IInventory)((TileEntityPresent)world.func_147438_o(x - 1, y, z)), (IInventory)object);
        }
        if (world.func_147439_a(x + 1, y, z) == this) {
            object = new InventoryLargePresent("container.chestDouble", (IInventory)((TileEntityPresent)world.func_147438_o(x + 1, y, z)), (IInventory)object);
        }
        if (world.func_147439_a(x, y, z - 1) == this) {
            object = new InventoryLargePresent("container.chestDouble", (IInventory)((TileEntityPresent)world.func_147438_o(x, y, z - 1)), (IInventory)object);
        }
        if (world.func_147439_a(x, y, z + 1) == this) {
            object = new InventoryLargePresent("container.chestDouble", (IInventory)((TileEntityPresent)world.func_147438_o(x, y, z + 1)), (IInventory)object);
        }
        return (IInventory)object;
    }

    @Override
    public CarvableVariation getVariation(int metadata) {
        return this.carverHelper.getVariation(metadata);
    }
}

