/*
 * Decompiled with CFR 0.152.
 */
package info.jbcs.minecraft.chisel;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import info.jbcs.minecraft.chisel.BlockNameConversion;
import info.jbcs.minecraft.chisel.ChiselLeftClick;
import info.jbcs.minecraft.chisel.Configurations;
import info.jbcs.minecraft.chisel.Crafting;
import info.jbcs.minecraft.chisel.block.BlockCarvable;
import info.jbcs.minecraft.chisel.block.tileentity.TileEntityAutoChisel;
import info.jbcs.minecraft.chisel.block.tileentity.TileEntityPresent;
import info.jbcs.minecraft.chisel.client.gui.GuiAutoChisel;
import info.jbcs.minecraft.chisel.client.gui.GuiChisel;
import info.jbcs.minecraft.chisel.client.gui.GuiPresent;
import info.jbcs.minecraft.chisel.compat.Compatibility;
import info.jbcs.minecraft.chisel.compat.ModIntegration;
import info.jbcs.minecraft.chisel.init.ModBlocks;
import info.jbcs.minecraft.chisel.init.ModItems;
import info.jbcs.minecraft.chisel.init.ModTabs;
import info.jbcs.minecraft.chisel.inventory.ContainerAutoChisel;
import info.jbcs.minecraft.chisel.inventory.ContainerChisel;
import info.jbcs.minecraft.chisel.inventory.ContainerPresent;
import info.jbcs.minecraft.chisel.inventory.InventoryChiselSelection;
import info.jbcs.minecraft.chisel.proxy.CommonProxy;
import info.jbcs.minecraft.chisel.utils.General;
import info.jbcs.minecraft.chisel.world.GeneratorLimestone;
import info.jbcs.minecraft.chisel.world.GeneratorMarble;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="chisel", name="Chisel 2", version="2.1.3", guiFactory="info.jbcs.minecraft.chisel.client.gui.GuiFactory", dependencies="after:ForgeMultipart;")
public class Chisel {
    public static final String MOD_ID = "chisel";
    public static final BlockCarvable.SoundType soundTempleFootstep = new BlockCarvable.SoundType("dig.stone", "chisel:step.templeblock", 1.0f, 1.0f);
    public static final String MOD_NAME = "Chisel 2";
    public static final String VERSION = "2.1.3";
    public static final BlockCarvable.SoundType soundHolystoneFootstep = new BlockCarvable.SoundType("holystone", 1.0f, 1.0f);
    public static final BlockCarvable.SoundType soundMetalFootstep = new BlockCarvable.SoundType("metal", 1.0f, 1.0f);
    public static boolean multipartLoaded = false;
    public static int RenderEldritchId;
    public static int RenderCTMId;
    public static int RenderCarpetId;
    @Mod.Instance(value="chisel")
    public static Chisel instance;
    @SidedProxy(clientSide="info.jbcs.minecraft.chisel.proxy.ClientProxy", serverSide="info.jbcs.minecraft.chisel.proxy.CommonProxy")
    public static CommonProxy proxy;

    @SideOnly(value=Side.CLIENT)
    private static void initModIntegration() {
        ModIntegration.init();
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        BlockNameConversion.init();
        for (FMLMissingMappingsEvent.MissingMapping m : event.get()) {
            if (m.name.startsWith("null.") && m.name.length() == 6 && m.type == GameRegistry.Type.BLOCK) {
                m.warn();
                continue;
            }
            if (m.type == GameRegistry.Type.BLOCK) {
                Block block = BlockNameConversion.findBlock(m.name);
                if (block != null) {
                    m.remap(block);
                    FMLLog.getLogger().info("Remapping block " + m.name + " to " + General.getName(block));
                    continue;
                }
                FMLLog.getLogger().warn("Block " + m.name + " could not get remapped.");
                continue;
            }
            if (m.type != GameRegistry.Type.ITEM) continue;
            Item item = BlockNameConversion.findItem(m.name);
            if (item != null) {
                m.remap(item);
                FMLLog.getLogger().info("Remapping item " + m.name + " to " + General.getName(item));
                continue;
            }
            FMLLog.getLogger().warn("Item " + m.name + " could not get remapped.");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File configFile = event.getSuggestedConfigurationFile();
        Configurations.configExists = configFile.exists();
        Configurations.config = new Configuration(configFile);
        Configurations.config.load();
        Configurations.refreshConfig();
        ModTabs.load();
        ModBlocks.load();
        ModItems.load();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Crafting.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, new IGuiHandler(){

            public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                switch (ID) {
                    case 0: {
                        return new ContainerChisel(player.field_71071_by, new InventoryChiselSelection(null));
                    }
                    case 1: {
                        TileEntity tileentity = world.func_147438_o(x, y, z);
                        if (tileentity instanceof TileEntityAutoChisel) {
                            return new ContainerAutoChisel(player.field_71071_by, (TileEntityAutoChisel)tileentity);
                        }
                    }
                    case 2: {
                        TileEntity tileEntity = world.func_147438_o(x, y, z);
                        if (!(tileEntity instanceof TileEntityPresent)) break;
                        return new ContainerPresent((IInventory)player.field_71071_by, (IInventory)((TileEntityPresent)tileEntity));
                    }
                }
                return null;
            }

            public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
                switch (ID) {
                    case 0: {
                        return new GuiChisel(player.field_71071_by, new InventoryChiselSelection(null));
                    }
                    case 1: {
                        TileEntity tileentity = world.func_147438_o(x, y, z);
                        if (tileentity instanceof TileEntityAutoChisel) {
                            return new GuiAutoChisel(player.field_71071_by, (TileEntityAutoChisel)tileentity);
                        }
                    }
                    case 2: {
                        TileEntity tileEntity = world.func_147438_o(x, y, z);
                        if (!(tileEntity instanceof TileEntityPresent)) break;
                        return new GuiPresent(player.field_71071_by, (TileEntityPresent)tileEntity);
                    }
                }
                return null;
            }
        });
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GeneratorMarble(ModBlocks.marble, 32, Configurations.marbleAmount), (int)1000);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GeneratorLimestone(ModBlocks.limestone, 32, Configurations.limestoneAmount), (int)1000);
        if (event.getSide() == Side.CLIENT) {
            Chisel.initModIntegration();
        }
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ChiselLeftClick());
        FMLCommonHandler.instance().bus().register((Object)instance);
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"info.jbcs.minecraft.chisel.Waila.register");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModIntegration.postInit();
        Compatibility.init(event);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MOD_ID)) {
            Configurations.refreshConfig();
        }
    }
}

