/*
 * Decompiled with CFR 0.152.
 */
package com.nauktis.solarflux.blocks;

import com.nauktis.core.block.BaseModBlockWithTileEntity;
import com.nauktis.solarflux.blocks.SolarPanelTileEntity;
import com.nauktis.solarflux.config.ModConfiguration;
import com.nauktis.solarflux.creativetab.ModCreativeTab;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class SolarPanelBlock
extends BaseModBlockWithTileEntity {
    protected final int mMaximumEnergyGeneration;
    protected final int mMaximumEnergyTransfer;
    protected final int mEnergyCapacity;
    private IIcon mBlockSideIcon;

    public SolarPanelBlock(String pName, int pMaximumEnergyGeneration, int pEnergyCapacity) {
        super("SolarFlux", pName);
        this.mMaximumEnergyGeneration = pMaximumEnergyGeneration;
        this.mMaximumEnergyTransfer = this.mMaximumEnergyGeneration * 8;
        this.mEnergyCapacity = pEnergyCapacity;
        this.func_149647_a(ModCreativeTab.MOD_TAB);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(field_149777_j);
        if (!ModConfiguration.isSolarPanelFullBlock()) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, ModConfiguration.getSolarPanelHeight(), 1.0f);
            this.func_149713_g(255);
            this.field_149783_u = true;
        }
    }

    public boolean func_149686_d() {
        if (!ModConfiguration.isSolarPanelFullBlock()) {
            return false;
        }
        return super.func_149686_d();
    }

    public boolean func_149662_c() {
        if (!ModConfiguration.isSolarPanelFullBlock()) {
            return false;
        }
        return super.func_149662_c();
    }

    public int getMaximumEnergyGeneration() {
        return this.mMaximumEnergyGeneration;
    }

    public int getMaximumEnergyTransfer() {
        return this.mMaximumEnergyTransfer;
    }

    public int getEnergyCapacity() {
        return this.mEnergyCapacity;
    }

    public TileEntity func_149915_a(World pWorld, int pMetadata) {
        return new SolarPanelTileEntity(this.mMaximumEnergyGeneration, this.mMaximumEnergyTransfer, this.mEnergyCapacity);
    }

    public IIcon func_149691_a(int pSide, int pMetadata) {
        if (ForgeDirection.UP == ForgeDirection.getOrientation((int)pSide)) {
            return super.func_149691_a(pSide, pMetadata);
        }
        return this.mBlockSideIcon;
    }

    public boolean func_149727_a(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer, int pSide, float pdx, float pdy, float pdz) {
        if (!pWorld.field_72995_K && pPlayer.func_70093_af()) {
            this.displayChatInformation(pWorld, pX, pY, pZ, pPlayer);
            return true;
        }
        return false;
    }

    private void displayChatInformation(World pWorld, int pX, int pY, int pZ, EntityPlayer pPlayer) {
        SolarPanelTileEntity tile = (SolarPanelTileEntity)pWorld.func_147438_o(pX, pY, pZ);
        String message = String.format("Energy: [%d%%] %,d / %,d Generating: %,d", tile.getPercentageEnergyStored(), tile.getEnergyStored(), tile.getMaxEnergyStored(), tile.getEnergyProduced());
        pPlayer.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    public void func_149651_a(IIconRegister pIconRegister) {
        super.func_149651_a(pIconRegister);
        this.mBlockSideIcon = pIconRegister.func_94245_a(this.func_149641_N() + "_side");
    }
}

