/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.protection;

import com.carpentersblocks.util.protection.IProtected;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;

public class ProtectedUtil {
    private static Map<String, UUID> cachedUUID = new HashMap<String, UUID>();

    public static boolean isOwner(IProtected object, EntityPlayer entityPlayer) {
        UUID uuid = ProtectedUtil.updateOwnerUUID(object);
        String ident = uuid != null ? entityPlayer.func_110124_au().toString() : entityPlayer.getDisplayName();
        return object.getOwner().equals(ident);
    }

    public static UUID updateOwnerUUID(IProtected object) {
        String owner = object.getOwner();
        UUID uuid = null;
        try {
            uuid = UUID.fromString(owner);
        }
        catch (IllegalArgumentException e) {
            if (cachedUUID.containsKey(owner)) {
                if (cachedUUID.get(owner) != null) {
                    object.setOwner(cachedUUID.get(owner));
                }
            }
            uuid = ProtectedUtil.getOwnerIdentity(owner);
            if (uuid != null) {
                object.setOwner(uuid);
            }
            cachedUUID.put(owner, uuid);
        }
        return uuid;
    }

    private static UUID getOwnerIdentity(String name) {
        final GameProfile[] gameProfileResult = new GameProfile[1];
        ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile gameProfile) {
                gameProfileResult[0] = gameProfile;
            }

            public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                gameProfileResult[0] = null;
            }
        };
        MinecraftServer.func_71276_C().func_152359_aw().findProfilesByNames(new String[]{name}, Agent.MINECRAFT, profilelookupcallback);
        return gameProfileResult[0] != null ? gameProfileResult[0].getId() : null;
    }
}

