/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.data.Torch;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.renderer.helper.RenderHelper;
import com.carpentersblocks.renderer.helper.VertexHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersTorch
extends BlockHandlerBase {
    private Vec3[] vec3 = new Vec3[8];
    private static Torch data = new Torch();
    private ForgeDirection dir;

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    @Override
    protected IIcon getUniqueIcon(ItemStack itemStack, int side, IIcon icon) {
        Block block = BlockProperties.toBlock(itemStack);
        if (this.TE.hasAttribute(TEBase.ATTR_COVER[6])) {
            return block.func_149691_a(side, this.renderBlocks.field_147845_a.func_72805_g(this.TE.field_145851_c, this.TE.field_145848_d, this.TE.field_145849_e));
        }
        return IconRegistry.icon_uncovered_solid;
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        this.disableAO = true;
        ItemStack itemStack = this.getCoverForRendering(new TEBase[0]);
        this.dir = data.getDirection(this.TE);
        switch (data.getType(this.TE)) {
            case 0: {
                this.renderTypeVanilla(itemStack, x, y, z);
                break;
            }
            case 1: {
                this.renderTypeLantern(itemStack, x, y, z);
            }
        }
        this.disableAO = false;
        this.renderBlocks.field_147837_f = false;
    }

    private void renderTypeVanilla(ItemStack itemStack, int x, int y, int z) {
        this.renderBlocks.func_147782_a(0.4375, 0.0, 0.4375, 0.5625, 0.625, 0.5625);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(this.srcBlock.func_149677_c(this.renderBlocks.field_147845_a, this.TE.field_145851_c, this.TE.field_145848_d, this.TE.field_145849_e));
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        RenderHelper.setFloatingIconLock();
        IIcon icon = null;
        switch (data.getState(this.TE)) {
            case LIT: {
                icon = IconRegistry.icon_torch_head_lit;
                break;
            }
            case SMOLDERING: {
                icon = IconRegistry.icon_torch_head_smoldering;
                break;
            }
            case UNLIT: {
                icon = IconRegistry.icon_torch_head_unlit;
                break;
            }
        }
        this.vec3 = new Vec3[]{Vec3.func_72443_a((double)-0.0625, (double)0.5, (double)-0.0625), Vec3.func_72443_a((double)0.0625, (double)0.5, (double)-0.0625), Vec3.func_72443_a((double)0.0625, (double)0.5, (double)0.0625), Vec3.func_72443_a((double)-0.0625, (double)0.5, (double)0.0625), Vec3.func_72443_a((double)-0.0625, (double)0.625, (double)-0.0625), Vec3.func_72443_a((double)0.0625, (double)0.625, (double)-0.0625), Vec3.func_72443_a((double)0.0625, (double)0.625, (double)0.0625), Vec3.func_72443_a((double)-0.0625, (double)0.625, (double)0.0625)};
        this.setVanillaRotations(data.getDirection(this.TE), this.vec3, x, y, z);
        for (int side = 0; side < 6; ++side) {
            this.renderVectors(side, icon, false);
        }
        RenderHelper.clearFloatingIconLock();
        this.vec3 = new Vec3[]{Vec3.func_72443_a((double)-0.0625, (double)0.0, (double)-0.0625), Vec3.func_72443_a((double)0.0625, (double)0.0, (double)-0.0625), Vec3.func_72443_a((double)0.0625, (double)0.0, (double)0.0625), Vec3.func_72443_a((double)-0.0625, (double)0.0, (double)0.0625), Vec3.func_72443_a((double)-0.0625, (double)0.5, (double)-0.0625), Vec3.func_72443_a((double)0.0625, (double)0.5, (double)-0.0625), Vec3.func_72443_a((double)0.0625, (double)0.5, (double)0.0625), Vec3.func_72443_a((double)-0.0625, (double)0.5, (double)0.0625)};
        this.setVanillaRotations(data.getDirection(this.TE), this.vec3, x, y, z);
        this.lightingHelper.setupLightingYNeg(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 0);
        this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 1);
        this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 2);
        this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 3);
        this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 4);
        this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
        this.delegateSideRender(itemStack, x, y, z, 5);
    }

    private void renderTypeLantern(ItemStack itemStack, int x, int y, int z) {
        switch (this.dir) {
            case UP: {
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, 0.0, 0.375, 0.625, 0.375, 0.625, new ForgeDirection[0]);
                break;
            }
            default: {
                this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, 0.375, 0.0, 0.5625, 0.75, 0.25, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, 0.375, 0.25, 0.625, 0.75, 0.375, this.dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, 0.25, 0.375, 0.625, 0.375, 0.625, new ForgeDirection[0]);
            }
        }
        for (int facing = 2; facing < 6; ++facing) {
            ForgeDirection nextDir = ForgeDirection.getOrientation((int)facing);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.25, 0.25, 0.25, 0.375, 0.75, 0.375, nextDir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.25, 0.25, 0.375, 0.375, 0.375, 0.625, nextDir);
            if (facing == this.dir.ordinal()) continue;
            this.renderBlocks.func_147782_a(0.375, 0.375, 0.3125, 0.625, 0.75, 0.3125);
            this.rotateBounds(this.renderBlocks, nextDir);
            this.renderPartPane(IconRegistry.icon_lantern_glass, x, y, z, nextDir);
        }
        this.renderBlockWithRotation(itemStack, x, y, z, 0.1875, 0.75, 0.1875, 0.8125, 0.875, 0.8125, new ForgeDirection[0]);
        this.renderBlockWithRotation(itemStack, x, y, z, 0.3125, 0.875, 0.3125, 0.6875, 0.9375, 0.6875, new ForgeDirection[0]);
        this.suppressOverlay = true;
        this.suppressDyeColor = true;
        this.suppressChiselDesign = true;
        RenderHelper.setFloatingIconLock();
        this.setIconOverride(6, IconRegistry.icon_torch_head_lit);
        this.lightingHelper.setMaximumLuminosity();
        this.renderBlockWithRotation(new ItemStack(Blocks.field_150346_d), x, y, z, 0.4375, 0.375, 0.4375, 0.5625, 0.5, 0.5625, new ForgeDirection[0]);
        this.lightingHelper.clearMaximumLuminosity();
        this.clearIconOverride(6);
        RenderHelper.clearFloatingIconLock();
        this.suppressOverlay = false;
        this.suppressDyeColor = false;
        this.suppressChiselDesign = false;
    }

    protected final void renderPartPane(IIcon icon, int x, int y, int z, ForgeDirection dir) {
        int side = dir.getOpposite().ordinal();
        float LIGHTNESS = this.lightingHelper.LIGHTNESS[side];
        Tessellator.field_78398_a.func_78380_c(Blocks.field_150359_w.func_149677_c(this.renderBlocks.field_147845_a, x, y, z));
        Tessellator.field_78398_a.func_78386_a(LIGHTNESS, LIGHTNESS, LIGHTNESS);
        switch (side) {
            case 2: {
                RenderHelper.renderFaceZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 3: {
                RenderHelper.renderFaceZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 4: {
                RenderHelper.renderFaceXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 5: {
                RenderHelper.renderFaceXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
        }
    }

    @Override
    protected void render(int x, int y, int z, int side, IIcon icon) {
        if (data.getType(this.TE) == 0) {
            this.renderVectors(side, icon, true);
        } else {
            super.render(x, y, z, side, icon);
        }
    }

    private void setVanillaRotations(ForgeDirection dir, Vec3[] vec3, int x, int y, int z) {
        block9: for (int vecCount = 0; vecCount < 8; ++vecCount) {
            switch (dir) {
                case UP: {
                    vec3[vecCount].field_72450_a += (double)x + 0.5;
                    vec3[vecCount].field_72448_b += (double)y;
                    vec3[vecCount].field_72449_c += (double)z + 0.5;
                    continue block9;
                }
                default: {
                    vec3[vecCount].field_72449_c += 0.0625;
                    vec3[vecCount].func_72440_a(-1.186824f);
                    vec3[vecCount].field_72448_b -= 0.4375;
                    vec3[vecCount].func_72440_a(1.5707964f);
                    switch (dir) {
                        case NORTH: {
                            vec3[vecCount].func_72442_b(0.0f);
                            break;
                        }
                        case SOUTH: {
                            vec3[vecCount].func_72442_b((float)Math.PI);
                            break;
                        }
                        case WEST: {
                            vec3[vecCount].func_72442_b(1.5707964f);
                            break;
                        }
                        case EAST: {
                            vec3[vecCount].func_72442_b(-1.5707964f);
                            break;
                        }
                    }
                    vec3[vecCount].field_72450_a += (double)x + 0.5;
                    vec3[vecCount].field_72448_b += (double)((float)y + 0.1875f);
                    vec3[vecCount].field_72449_c += (double)z + 0.5;
                }
            }
        }
    }

    private void renderVectors(int side, IIcon icon, boolean isHandle) {
        double vMax;
        double vMin;
        double uMax;
        double uMin;
        if (isHandle) {
            uMin = icon.func_94214_a(7.0);
            uMax = icon.func_94214_a(9.0);
            if (side == 0) {
                vMin = icon.func_94207_b(7.0);
                vMax = icon.func_94207_b(9.0);
            } else {
                vMin = icon.func_94206_g();
                vMax = icon.func_94207_b(8.0);
            }
        } else {
            uMin = icon.func_94214_a(7.0);
            uMax = icon.func_94214_a(9.0);
            if (VertexHelper.hasFloatingIcon()) {
                vMin = icon.func_94206_g();
                vMax = icon.func_94207_b(2.0);
            } else {
                vMin = icon.func_94207_b(6.0);
                vMax = icon.func_94207_b(8.0);
            }
        }
        Vec3 vertex1 = null;
        Vec3 vertex2 = null;
        Vec3 vertex3 = null;
        Vec3 vertex4 = null;
        switch (side) {
            case 0: {
                vertex1 = this.vec3[0];
                vertex2 = this.vec3[1];
                vertex3 = this.vec3[2];
                vertex4 = this.vec3[3];
                break;
            }
            case 1: {
                vertex1 = this.vec3[7];
                vertex2 = this.vec3[6];
                vertex3 = this.vec3[5];
                vertex4 = this.vec3[4];
                break;
            }
            case 2: {
                vertex1 = this.vec3[1];
                vertex2 = this.vec3[0];
                vertex3 = this.vec3[4];
                vertex4 = this.vec3[5];
                break;
            }
            case 3: {
                vertex1 = this.vec3[3];
                vertex2 = this.vec3[2];
                vertex3 = this.vec3[6];
                vertex4 = this.vec3[7];
                break;
            }
            case 4: {
                vertex1 = this.vec3[0];
                vertex2 = this.vec3[3];
                vertex3 = this.vec3[7];
                vertex4 = this.vec3[4];
                break;
            }
            case 5: {
                vertex1 = this.vec3[2];
                vertex2 = this.vec3[1];
                vertex3 = this.vec3[5];
                vertex4 = this.vec3[6];
            }
        }
        VertexHelper.drawVertex(this.renderBlocks, vertex1.field_72450_a, vertex1.field_72448_b, vertex1.field_72449_c, uMin, vMax);
        VertexHelper.drawVertex(this.renderBlocks, vertex2.field_72450_a, vertex2.field_72448_b, vertex2.field_72449_c, uMax, vMax);
        VertexHelper.drawVertex(this.renderBlocks, vertex3.field_72450_a, vertex3.field_72448_b, vertex3.field_72449_c, uMax, vMin);
        VertexHelper.drawVertex(this.renderBlocks, vertex4.field_72450_a, vertex4.field_72448_b, vertex4.field_72449_c, uMin, vMin);
    }
}

