/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.data.Bed;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.renderer.helper.VertexHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.DyeHandler;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersBed
extends BlockHandlerBase {
    private IIcon[] icon_design;
    private ForgeDirection dir;
    private boolean isHead;
    private boolean hasDesign;
    private boolean bedParallelNeg;
    private boolean bedParallelPos;
    private TEBase TE_head;
    private TEBase TE_foot;

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    private boolean getIsParallelPos() {
        if (this.dir.ordinal() < 4 && this.renderBlocks.field_147845_a.func_147439_a(this.TE.field_145851_c + 1, this.TE.field_145848_d, this.TE.field_145849_e).equals(this.srcBlock)) {
            TEBase TE_adj = (TEBase)this.renderBlocks.field_147845_a.func_147438_o(this.TE.field_145851_c + 1, this.TE.field_145848_d, this.TE.field_145849_e);
            return Bed.isHeadOfBed(this.TE) == Bed.isHeadOfBed(TE_adj) && Bed.getDirection(this.TE) == Bed.getDirection(TE_adj);
        }
        if (this.renderBlocks.field_147845_a.func_147439_a(this.TE.field_145851_c, this.TE.field_145848_d, this.TE.field_145849_e + 1).equals(this.srcBlock)) {
            TEBase TE_adj = (TEBase)this.renderBlocks.field_147845_a.func_147438_o(this.TE.field_145851_c, this.TE.field_145848_d, this.TE.field_145849_e + 1);
            return Bed.isHeadOfBed(this.TE) == Bed.isHeadOfBed(TE_adj) && Bed.getDirection(this.TE) == Bed.getDirection(TE_adj);
        }
        return false;
    }

    private boolean getIsParallelNeg() {
        if (this.dir.ordinal() < 4 && this.renderBlocks.field_147845_a.func_147439_a(this.TE.field_145851_c - 1, this.TE.field_145848_d, this.TE.field_145849_e).equals(this.srcBlock)) {
            TEBase TE_adj = (TEBase)this.renderBlocks.field_147845_a.func_147438_o(this.TE.field_145851_c - 1, this.TE.field_145848_d, this.TE.field_145849_e);
            return Bed.isHeadOfBed(this.TE) == Bed.isHeadOfBed(TE_adj) && Bed.getDirection(this.TE) == Bed.getDirection(TE_adj);
        }
        if (this.renderBlocks.field_147845_a.func_147439_a(this.TE.field_145851_c, this.TE.field_145848_d, this.TE.field_145849_e - 1).equals(this.srcBlock)) {
            TEBase TE_adj = (TEBase)this.renderBlocks.field_147845_a.func_147438_o(this.TE.field_145851_c, this.TE.field_145848_d, this.TE.field_145849_e - 1);
            return Bed.isHeadOfBed(this.TE) == Bed.isHeadOfBed(TE_adj) && Bed.getDirection(this.TE) == Bed.getDirection(TE_adj);
        }
        return false;
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        this.renderBlocks.field_147837_f = true;
        this.setParams();
        this.renderFabricComponents(new ItemStack(Blocks.field_150325_L), x, y, z);
        if (this.TE_head != null) {
            if (this.TE.hasAttribute(TEBase.ATTR_DYE[6])) {
                this.setDyeOverride(DyeHandler.getColor(this.TE.getAttribute(TEBase.ATTR_DYE[6])));
            } else {
                this.suppressDyeColor = true;
            }
        }
        switch (Bed.getType(this.TE)) {
            case 0: {
                this.renderNormalFrame(this.getCoverForRendering(new TEBase[0]), x, y, z);
            }
        }
        this.clearDyeOverride();
        this.suppressDyeColor = false;
        this.renderBlocks.field_147837_f = false;
    }

    private void setParams() {
        this.dir = Bed.getDirection(this.TE);
        this.isHead = Bed.isHeadOfBed(this.TE);
        this.hasDesign = this.TE.hasDesign();
        this.bedParallelPos = this.getIsParallelPos();
        this.bedParallelNeg = this.getIsParallelNeg();
        TEBase tEBase = this.TE_head = this.isHead ? this.TE : Bed.getOppositeTE(this.TE);
        if (this.TE_head != null) {
            this.TE_foot = Bed.getOppositeTE(this.TE_head);
        }
        if (this.hasDesign) {
            this.icon_design = IconRegistry.icon_design_bed.get(DesignHandler.listBed.indexOf(this.TE.getDesign()));
        }
    }

    private void renderFabricComponents(ItemStack itemStack, int x, int y, int z) {
        this.suppressDyeColor = true;
        this.suppressOverlay = true;
        this.suppressChiselDesign = true;
        int[] rotateTop = new int[]{2, 0, 1, 3};
        this.renderBlocks.field_147867_u = this.renderBlocks.field_147865_v = rotateTop[this.dir.ordinal() - 2];
        this.renderPillow(itemStack, x, y, z);
        this.renderBlanket(itemStack, x, y, z);
        this.renderBlocks.field_147865_v = 0;
        this.renderBlocks.field_147867_u = 0;
        this.renderMattress(itemStack, x, y, z);
        this.suppressDyeColor = false;
        this.suppressOverlay = false;
        this.suppressChiselDesign = false;
    }

    private void renderPillow(ItemStack itemStack, int x, int y, int z) {
        if (this.isHead) {
            IIcon icon_pillow = this.hasDesign ? this.icon_design[0] : IconRegistry.icon_bed_pillow;
            this.setIconOverride(6, icon_pillow);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.5625, 0.1875, 0.875, 0.6875, 0.5625, this.dir);
            this.clearIconOverride(6);
        }
    }

    private void renderBlanket(ItemStack itemStack, int x, int y, int z) {
        VertexHelper.setFloatingIconLock();
        int blanketDyeMetadata = 0;
        boolean isOccupied = false;
        if (this.TE_head != null) {
            isOccupied |= Bed.isOccupied(this.TE_head);
        }
        if (this.TE_foot != null) {
            isOccupied |= Bed.isOccupied(this.TE_foot);
        }
        if (this.hasDesign) {
            int[] idxHead = new int[]{2, 2, 2, 7, 1, 3};
            int[] idxFoot = new int[]{5, 5, 2, 7, 4, 6};
            int[][] idxRot = new int[][]{{3, 2, 5, 4}, {2, 3, 4, 5}, {4, 5, 3, 2}, {5, 4, 2, 3}};
            int valDir = this.dir.ordinal() - 2;
            IIcon[][] icon = new IIcon[][]{{this.icon_design[idxHead[0]], this.icon_design[idxHead[1]], this.icon_design[idxHead[idxRot[valDir][0]]], this.icon_design[idxHead[idxRot[valDir][1]]], this.icon_design[idxHead[idxRot[valDir][2]]], this.icon_design[idxHead[idxRot[valDir][3]]]}, {this.icon_design[idxFoot[0]], this.icon_design[idxFoot[1]], this.icon_design[idxFoot[idxRot[valDir][0]]], this.icon_design[idxFoot[idxRot[valDir][1]]], this.icon_design[idxFoot[idxRot[valDir][2]]], this.icon_design[idxFoot[idxRot[valDir][3]]]}};
            int idx = this.isHead ? 0 : 1;
            for (int side = 0; side < 6; ++side) {
                this.setIconOverride(side, icon[idx][side]);
            }
        } else if (this.TE_foot != null) {
            blanketDyeMetadata = this.TE.hasAttribute(TEBase.ATTR_DYE[this.coverRendering]) ? DyeHandler.getVanillaDmgValue(this.TE.getAttribute(TEBase.ATTR_DYE[this.coverRendering])) : 0;
        }
        double yTop = isOccupied ? 0.875 : 0.625;
        double depth = 0.3125;
        itemStack.func_77964_b(blanketDyeMetadata);
        if (this.isHead) {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0625, yTop - 0.0625, 0.5, 0.9375, yTop, 1.0, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, yTop - depth, 0.5, 0.0625, yTop, 1.0, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.9375, yTop - depth, 0.5, 1.0, yTop, 1.0, this.dir);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0625, yTop - 0.0625, 0.0, 0.9375, yTop, 0.9375, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, yTop - depth, 0.0, 0.0625, yTop, 1.0, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.9375, yTop - depth, 0.0, 1.0, yTop, 1.0, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0625, yTop - depth, 0.9375, 0.9375, yTop, 1.0, this.dir);
        }
        itemStack.func_77964_b(15);
        this.clearIconOverride(6);
        VertexHelper.clearFloatingIconLock();
    }

    private void renderMattress(ItemStack itemStack, int x, int y, int z) {
        itemStack.func_77964_b(0);
        switch (this.dir) {
            case NORTH: {
                this.renderBlocks.func_147782_a(this.bedParallelNeg ? 0.0 : 0.0625, 0.3125, this.isHead ? 0.0 : 0.0625, this.bedParallelPos ? 1.0 : 0.9375, 0.5625, this.isHead ? 0.875 : 1.0);
                break;
            }
            case SOUTH: {
                this.renderBlocks.func_147782_a(this.bedParallelNeg ? 0.0 : 0.0625, 0.3125, this.isHead ? 0.125 : 0.0, this.bedParallelPos ? 1.0 : 0.9375, 0.5625, this.isHead ? 1.0 : 0.9375);
                break;
            }
            case WEST: {
                this.renderBlocks.func_147782_a(this.isHead ? 0.0 : 0.0625, 0.3125, this.bedParallelNeg ? 0.0 : 0.0625, this.isHead ? 0.875 : 1.0, 0.5625, this.bedParallelPos ? 1.0 : 0.9375);
                break;
            }
            case EAST: {
                this.renderBlocks.func_147782_a(this.isHead ? 0.125 : 0.0, 0.3125, this.bedParallelNeg ? 0.0 : 0.0625, this.isHead ? 1.0 : 0.9375, 0.5625, this.bedParallelPos ? 1.0 : 0.9375);
                break;
            }
        }
        this.renderBlock(itemStack, x, y, z);
    }

    private void renderNormalFrame(ItemStack itemStack, int x, int y, int z) {
        switch (this.dir) {
            case NORTH: {
                if (this.isHead) {
                    this.renderBlocks.func_147782_a(0.0, this.bedParallelNeg ? 0.1875 : 0.0, 0.875, 0.125, this.bedParallelNeg ? 0.875 : 1.0, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                    this.renderBlocks.func_147782_a(0.875, this.bedParallelPos ? 0.1875 : 0.0, 0.875, 1.0, this.bedParallelPos ? 0.875 : 1.0, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                    break;
                }
                if (!this.bedParallelNeg) {
                    this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.125, 0.1875, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (this.bedParallelPos) break;
                this.renderBlocks.func_147782_a(0.875, 0.0, 0.0, 1.0, 0.1875, 0.125);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
            case SOUTH: {
                if (this.isHead) {
                    this.renderBlocks.func_147782_a(0.0, this.bedParallelNeg ? 0.1875 : 0.0, 0.0, 0.125, this.bedParallelNeg ? 0.875 : 1.0, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                    this.renderBlocks.func_147782_a(0.875, this.bedParallelPos ? 0.1875 : 0.0, 0.0, 1.0, this.bedParallelPos ? 0.875 : 1.0, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                    break;
                }
                if (!this.bedParallelNeg) {
                    this.renderBlocks.func_147782_a(0.0, 0.0, 0.875, 0.125, 0.1875, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (this.bedParallelPos) break;
                this.renderBlocks.func_147782_a(0.875, 0.0, 0.875, 1.0, 0.1875, 1.0);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
            case WEST: {
                if (this.isHead) {
                    this.renderBlocks.func_147782_a(0.875, this.bedParallelNeg ? 0.1875 : 0.0, 0.0, 1.0, this.bedParallelNeg ? 0.875 : 1.0, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                    this.renderBlocks.func_147782_a(0.875, this.bedParallelPos ? 0.1875 : 0.0, 0.875, 1.0, this.bedParallelPos ? 0.875 : 1.0, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                    break;
                }
                if (!this.bedParallelNeg) {
                    this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.125, 0.1875, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (this.bedParallelPos) break;
                this.renderBlocks.func_147782_a(0.0, 0.0, 0.875, 0.125, 0.1875, 1.0);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
            case EAST: {
                if (this.isHead) {
                    this.renderBlocks.func_147782_a(0.0, this.bedParallelNeg ? 0.1875 : 0.0, 0.0, 0.125, this.bedParallelNeg ? 0.875 : 1.0, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                    this.renderBlocks.func_147782_a(0.0, this.bedParallelPos ? 0.1875 : 0.0, 0.875, 0.125, this.bedParallelPos ? 0.875 : 1.0, 1.0);
                    this.renderBlock(itemStack, x, y, z);
                    break;
                }
                if (!this.bedParallelNeg) {
                    this.renderBlocks.func_147782_a(0.875, 0.0, 0.0, 1.0, 0.1875, 0.125);
                    this.renderBlock(itemStack, x, y, z);
                }
                if (this.bedParallelPos) break;
                this.renderBlocks.func_147782_a(0.875, 0.0, 0.875, 1.0, 0.1875, 1.0);
                this.renderBlock(itemStack, x, y, z);
                break;
            }
        }
        if (this.isHead) {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.125, 0.1875, 0.0, 0.875, 0.875, 0.125, this.dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.1875, 0.125, 1.0, 0.3125, 1.0, this.dir);
        } else {
            this.renderBlockWithRotation(itemStack, x, y, z, 0.0, 0.1875, 0.0, 1.0, 0.3125, 1.0, this.dir);
        }
    }
}

