/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.block.BlockCarpentersBarrier;
import com.carpentersblocks.data.Barrier;
import com.carpentersblocks.renderer.BlockHandlerBase;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.registry.BlockRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersBarrier
extends BlockHandlerBase {
    private boolean[] barrier;
    private boolean[] connect;
    private static final int YN = 0;
    private static final int YP = 1;

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        renderBlocks.func_147782_a(0.125, 0.0, 0.375, 0.375, 1.0, 0.625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.625, 0.0, 0.375, 0.875, 1.0, 0.625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.0, 0.8125, 0.4375, 1.0, 0.9375, 0.5625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
        renderBlocks.func_147782_a(0.0, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
    }

    @Override
    protected void renderCarpentersBlock(int x, int y, int z) {
        int type = Barrier.getType(this.TE);
        ItemStack itemStack = this.getCoverForRendering(new TEBase[0]);
        this.findBarriers(x, y, z);
        switch (type) {
            case 4: {
                this.renderTypePicket(itemStack, x, y, z);
                break;
            }
            case 5: {
                this.renderTypeShadowbox(itemStack, x, y, z);
                break;
            }
            case 6: {
                this.renderTypeWall(itemStack, x, y, z);
                break;
            }
            default: {
                this.renderTypeVanilla(itemStack, x, y, z);
            }
        }
    }

    private void findBarriers(int x, int y, int z) {
        BlockCarpentersBarrier tempBlock = (BlockCarpentersBarrier)this.srcBlock;
        this.connect = new boolean[]{tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x, y - 1, z, ForgeDirection.UP), tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x, y + 1, z, ForgeDirection.DOWN), tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x, y, z - 1, ForgeDirection.SOUTH), tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x, y, z + 1, ForgeDirection.NORTH), tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x - 1, y, z, ForgeDirection.EAST), tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x + 1, y, z, ForgeDirection.WEST), tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x, y + 1, z - 1, ForgeDirection.SOUTH), tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x, y + 1, z + 1, ForgeDirection.NORTH), tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x - 1, y + 1, z, ForgeDirection.EAST), tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, x + 1, y + 1, z, ForgeDirection.WEST)};
        this.barrier = new boolean[]{this.renderBlocks.field_147845_a.func_147439_a(x, y - 1, z).equals(this.srcBlock), this.renderBlocks.field_147845_a.func_147439_a(x, y + 1, z).equals(this.srcBlock)};
    }

    private boolean hasPost(TEBase TE) {
        BlockCarpentersBarrier tempBlock = (BlockCarpentersBarrier)this.srcBlock;
        boolean flowerPotYP = this.renderBlocks.field_147845_a.func_147439_a(TE.field_145851_c, TE.field_145848_d + 1, TE.field_145849_e).func_149688_o().equals(Material.field_151594_q);
        boolean connectZN = tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e - 1, ForgeDirection.SOUTH);
        boolean connectZP = tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e + 1, ForgeDirection.NORTH);
        boolean connectXN = tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, TE.field_145851_c - 1, TE.field_145848_d, TE.field_145849_e, ForgeDirection.EAST);
        boolean connectXP = tempBlock.canConnectBarrierTo(this.renderBlocks.field_147845_a, TE.field_145851_c + 1, TE.field_145848_d, TE.field_145849_e, ForgeDirection.WEST);
        boolean adjGate = this.renderBlocks.field_147845_a.func_147439_a(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e - 1).equals(BlockRegistry.blockCarpentersGate) || this.renderBlocks.field_147845_a.func_147439_a(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e + 1).equals(BlockRegistry.blockCarpentersGate) || this.renderBlocks.field_147845_a.func_147439_a(TE.field_145851_c - 1, TE.field_145848_d, TE.field_145849_e).equals(BlockRegistry.blockCarpentersGate) || this.renderBlocks.field_147845_a.func_147439_a(TE.field_145851_c + 1, TE.field_145848_d, TE.field_145849_e).equals(BlockRegistry.blockCarpentersGate);
        boolean pathOnX = connectXN && connectXP;
        boolean pathOnZ = connectZN && connectZP;
        return Barrier.getPost(TE) == 1 || flowerPotYP || adjGate || pathOnX == pathOnZ || (connectXN || connectXP) && (connectZN || connectZP);
    }

    private boolean isPostAt() {
        Block block;
        int y;
        if (this.hasPost(this.TE)) {
            return true;
        }
        for (y = this.TE.field_145848_d + 1; y < this.renderBlocks.field_147845_a.func_72800_K() && (block = this.renderBlocks.field_147845_a.func_147439_a(this.TE.field_145851_c, y, this.TE.field_145849_e)).equals(this.srcBlock); ++y) {
            if (!this.hasPost((TEBase)this.renderBlocks.field_147845_a.func_147438_o(this.TE.field_145851_c, y, this.TE.field_145849_e))) continue;
            return true;
        }
        for (y = this.TE.field_145848_d - 1; y > 0 && (block = this.renderBlocks.field_147845_a.func_147439_a(this.TE.field_145851_c, y, this.TE.field_145849_e)).equals(this.srcBlock); --y) {
            if (!this.hasPost((TEBase)this.renderBlocks.field_147845_a.func_147438_o(this.TE.field_145851_c, y, this.TE.field_145849_e))) continue;
            return true;
        }
        return false;
    }

    private void renderPost(ItemStack itemStack, int x, int y, int z, double radius) {
        if (this.isPostAt()) {
            double radiusLow = 0.5 - radius;
            double radiusHigh = 0.5 + radius;
            this.renderBlocks.func_147782_a(radiusLow, 0.0, radiusLow, radiusHigh, 1.0, radiusHigh);
            this.renderBlock(itemStack, x, y, z);
        }
    }

    private void renderSupportPlank(ItemStack itemStack, int x, int y, int z, ForgeDirection dir, double depthRadius, double yMin, double yMax, boolean enforce) {
        boolean isTop = yMax - 0.5 > 0.5 - yMin;
        double radiusLow = 0.5 - depthRadius;
        double radiusHigh = 0.5 + depthRadius;
        if (isTop) {
            if (enforce || !this.connect[dir.ordinal() + 4] || !this.barrier[1]) {
                this.renderBlockWithRotation(itemStack, x, y, z, radiusLow, yMin, 0.5, radiusHigh, yMax, 1.0, dir);
            }
        } else if (enforce || !this.barrier[0]) {
            this.renderBlockWithRotation(itemStack, x, y, z, radiusLow, yMin, 0.5, radiusHigh, yMax, 1.0, dir);
        }
    }

    private void renderTypeVanilla(ItemStack itemStack, int x, int y, int z) {
        this.renderPost(itemStack, x, y, z, 0.125);
        double yOffset = (double)Barrier.getType(this.TE) * 0.0625;
        boolean singlePlank = Barrier.getType(this.TE) == 3;
        for (int side = 2; side < 6; ++side) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            if (!this.connect[side]) continue;
            if (singlePlank) {
                this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.1875, 0.9375, true);
                continue;
            }
            this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.75 - yOffset, 0.9375, true);
            this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.375 - yOffset, 0.5625, true);
        }
    }

    private void renderTypePicket(ItemStack itemStack, int x, int y, int z) {
        this.renderPost(itemStack, x, y, z, 0.0625);
        double yMin = this.barrier[0] ? 0.0 : 0.0625;
        for (int side = 2; side < 6; ++side) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            if (this.connect[side]) {
                double yMax = this.connect[side + 4] && this.connect[1] ? 1.0 : 0.875;
                this.renderBlockWithRotation(itemStack, x, y, z, 0.5625, yMin, 0.6875, 0.625, yMax, 0.8125, dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, yMin, 0.6875, 0.4375, yMax, 0.8125, dir);
                yMax = this.connect[side + 4] && this.connect[1] ? 1.0 : 0.8125;
                this.renderBlockWithRotation(itemStack, x, y, z, 0.5625, yMin, 0.9375, 0.625, yMax, 1.0, dir);
                this.renderBlockWithRotation(itemStack, x, y, z, 0.375, yMin, 0.9375, 0.4375, yMax, 1.0, dir);
                this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.625, 0.6875, false);
                this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.1875, 0.25, false);
                continue;
            }
            this.renderBlockWithRotation(itemStack, x, y, z, 0.4375, yMin, 0.5625, 0.5625, 1.0, 0.625, dir);
        }
    }

    private void renderTypeWall(ItemStack itemStack, int x, int y, int z) {
        this.renderPost(itemStack, x, y, z, 0.25);
        for (int side = 2; side < 6; ++side) {
            if (!this.connect[side]) continue;
            double yMax = this.connect[side + 4] && this.connect[1] ? 1.0 : 0.8125;
            this.renderBlockWithRotation(itemStack, x, y, z, 0.3125, 0.0, 0.5, 0.6875, yMax, 1.0, ForgeDirection.getOrientation((int)side));
        }
    }

    private void renderTypeShadowbox(ItemStack itemStack, int x, int y, int z) {
        this.renderPost(itemStack, x, y, z, 0.0625);
        for (int side = 2; side < 6; ++side) {
            if (!this.connect[side]) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)side);
            this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.75, 0.875, false);
            this.renderSupportPlank(itemStack, x, y, z, dir, 0.0625, 0.125, 0.25, false);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.5625, 0.0, 0.5, 0.625, 1.0, 0.75, dir);
            this.renderBlockWithRotation(itemStack, x, y, z, 0.375, 0.0, 0.75, 0.4375, 1.0, 1.0, dir);
        }
    }
}

