/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.api.ICarpentersChisel;
import com.carpentersblocks.api.ICarpentersHammer;
import com.carpentersblocks.renderer.helper.FancyFluidsHelper;
import com.carpentersblocks.renderer.helper.ParticleHelper;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.handler.DesignHandler;
import com.carpentersblocks.util.handler.EventHandler;
import com.carpentersblocks.util.handler.OverlayHandler;
import com.carpentersblocks.util.protection.PlayerPermissions;
import com.carpentersblocks.util.registry.FeatureRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import com.carpentersblocks.util.registry.ItemRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCoverable
extends BlockContainer {
    protected boolean grabLightValue = false;
    protected final int METADATA_DROP_ATTR_ONLY = 16;
    private boolean enableDrops = false;

    public BlockCoverable(Material material) {
        super(material);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return IconRegistry.icon_uncovered_solid;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (BlockProperties.isMetadataDefaultIcon(metadata)) {
            return this.getIcon();
        }
        return BlockRedstoneWire.func_150173_e((String)"cross_overlay");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        ItemStack itemStack = BlockProperties.getCover(TE, 6);
        Block block = BlockProperties.toBlock(itemStack);
        return block instanceof BlockCoverable ? this.getIcon() : block.func_149691_a(side, itemStack.func_77960_j());
    }

    protected void setBlockBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                this.func_149676_a(minX, 1.0f - maxZ, minY, maxX, 1.0f - minZ, maxY);
                break;
            }
            case UP: {
                this.func_149676_a(minX, minZ, minY, maxX, maxZ, maxY);
                break;
            }
            case NORTH: {
                this.func_149676_a(1.0f - maxX, minY, 1.0f - maxZ, 1.0f - minX, maxY, 1.0f - minZ);
                break;
            }
            case EAST: {
                this.func_149676_a(minZ, minY, 1.0f - maxX, maxZ, maxY, 1.0f - minX);
                break;
            }
            case WEST: {
                this.func_149676_a(1.0f - maxZ, minY, minX, 1.0f - minZ, maxY, maxX);
                break;
            }
            default: {
                this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
            }
        }
    }

    public boolean func_149696_a(World world, int x, int y, int z, int itemId, int metadata) {
        ItemStack itemStack = new ItemStack(Item.func_150899_d((int)itemId), 1, metadata);
        if (itemStack != null) {
            this.func_149642_a(world, x, y, z, itemStack);
        }
        return true;
    }

    protected void destroyBlock(World world, int x, int y, int z, boolean dropBlock) {
        if (dropBlock) {
            this.func_149642_a(world, x, y, z, new ItemStack(this.func_149650_a(0, world.field_73012_v, 0)));
        }
        world.func_147468_f(x, y, z);
    }

    protected ItemStack getItemDrop(World world, int metadata) {
        int fortune = 1;
        return new ItemStack(this.func_149650_a(metadata, world.field_73012_v, fortune), 1, metadata);
    }

    protected TEBase[] getAdjacentTileEntities(World world, int x, int y, int z) {
        return new TEBase[]{this.getSimpleTileEntity((IBlockAccess)world, x, y - 1, z), this.getSimpleTileEntity((IBlockAccess)world, x, y + 1, z), this.getSimpleTileEntity((IBlockAccess)world, x, y, z - 1), this.getSimpleTileEntity((IBlockAccess)world, x, y, z + 1), this.getSimpleTileEntity((IBlockAccess)world, x - 1, y, z), this.getSimpleTileEntity((IBlockAccess)world, x + 1, y, z)};
    }

    protected TEBase getSimpleTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity TE = blockAccess.func_147438_o(x, y, z);
        return TE instanceof TEBase ? (TEBase)TE : null;
    }

    protected TEBase getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getSimpleTileEntity(blockAccess, x, y, z);
        return TE != null && blockAccess.func_147439_a(x, y, z).equals((Object)this) ? TE : null;
    }

    protected boolean canPlayerActivate(TEBase TE, EntityPlayer entityPlayer) {
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null && PlayerPermissions.canPlayerEdit(TE, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, entityPlayer)) {
            ActionResult actionResult = new ActionResult();
            ItemStack itemStack = entityPlayer.func_71045_bC();
            if (itemStack != null) {
                int effectiveSide = TE.hasAttribute(TEBase.ATTR_COVER[EventHandler.eventFace]) ? EventHandler.eventFace : 6;
                Item item = itemStack.func_77973_b();
                if (item instanceof ICarpentersHammer && ((ICarpentersHammer)item).canUseHammer(world, entityPlayer)) {
                    this.preOnBlockClicked(TE, world, x, y, z, entityPlayer, actionResult);
                    if (!actionResult.altered) {
                        if (entityPlayer.func_70093_af()) {
                            if (TE.hasAttribute((byte)21)) {
                                TE.removeAttribute((byte)21);
                                actionResult.setAltered();
                            } else if (TE.hasAttribute(TEBase.ATTR_OVERLAY[effectiveSide])) {
                                TE.removeAttribute(TEBase.ATTR_OVERLAY[effectiveSide]);
                                actionResult.setAltered();
                            } else if (TE.hasAttribute(TEBase.ATTR_DYE[effectiveSide])) {
                                TE.removeAttribute(TEBase.ATTR_DYE[effectiveSide]);
                                actionResult.setAltered();
                            } else if (TE.hasAttribute(TEBase.ATTR_COVER[effectiveSide])) {
                                TE.removeAttribute(TEBase.ATTR_COVER[effectiveSide]);
                                TE.removeChiselDesign(effectiveSide);
                                actionResult.setAltered();
                            }
                        } else {
                            this.onHammerLeftClick(TE, entityPlayer);
                            actionResult.setAltered();
                        }
                    }
                    if (actionResult.altered) {
                        this.func_149695_a(world, x, y, z, (Block)this);
                        world.func_147459_d(x, y, z, (Block)this);
                    }
                } else if (item instanceof ICarpentersChisel && ((ICarpentersChisel)item).canUseChisel(world, entityPlayer)) {
                    if (entityPlayer.func_70093_af()) {
                        if (TE.hasChiselDesign(effectiveSide)) {
                            TE.removeChiselDesign(effectiveSide);
                        }
                    } else if (TE.hasAttribute(TEBase.ATTR_COVER[effectiveSide])) {
                        this.onChiselClick(TE, effectiveSide, true);
                    }
                }
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        block22: {
            ActionResult actionResult;
            block23: {
                TEBase TE;
                block24: {
                    int effectiveSide;
                    ItemStack itemStack;
                    block31: {
                        block33: {
                            block32: {
                                block30: {
                                    block27: {
                                        ItemStack tempStack;
                                        block28: {
                                            block29: {
                                                int metadata;
                                                block26: {
                                                    block25: {
                                                        itemStack = entityPlayer.func_71045_bC();
                                                        if (world.field_72995_K) {
                                                            return true;
                                                        }
                                                        TE = this.getTileEntity((IBlockAccess)world, x, y, z);
                                                        if (TE == null) break block22;
                                                        actionResult = new ActionResult();
                                                        if (!this.canPlayerActivate(TE, entityPlayer)) break block23;
                                                        TE = this.getTileEntityForBlockActivation(TE);
                                                        this.preOnBlockActivated(TE, entityPlayer, side, hitX, hitY, hitZ, actionResult);
                                                        int n = effectiveSide = TE.hasAttribute(TEBase.ATTR_COVER[side]) ? side : 6;
                                                        if (!PlayerPermissions.canPlayerEdit(TE, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, entityPlayer) || actionResult.altered || itemStack == null) break block24;
                                                        if (!(itemStack.func_77973_b() instanceof ICarpentersHammer) || !((ICarpentersHammer)itemStack.func_77973_b()).canUseHammer(world, entityPlayer)) break block25;
                                                        if (this.onHammerRightClick(TE, entityPlayer)) {
                                                            actionResult.setAltered();
                                                        }
                                                        break block24;
                                                    }
                                                    if (!ItemRegistry.enableChisel || !(itemStack.func_77973_b() instanceof ICarpentersChisel) || !((ICarpentersChisel)itemStack.func_77973_b()).canUseChisel(world, entityPlayer)) break block26;
                                                    if (TE.hasAttribute(TEBase.ATTR_COVER[effectiveSide]) && this.onChiselClick(TE, effectiveSide, false)) {
                                                        actionResult.setAltered();
                                                    }
                                                    break block24;
                                                }
                                                if (!FeatureRegistry.enableCovers || !BlockProperties.isCover(itemStack)) break block27;
                                                Block block = BlockProperties.toBlock(itemStack);
                                                int n = metadata = block instanceof BlockDirectional ? MathHelper.func_76128_c((double)((double)(entityPlayer.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3 : itemStack.func_77960_j();
                                                if (BlockProperties.blockRotates(itemStack)) {
                                                    int rot = Direction.field_71580_e[EntityLivingUtil.getRotationValue((EntityLivingBase)entityPlayer)];
                                                    int side_interpolated = entityPlayer.field_70125_A < -45.0f ? 0 : (entityPlayer.field_70125_A > 45.0f ? 1 : (rot == 0 ? 3 : (rot == 1 ? 4 : (rot == 2 ? 2 : 5))));
                                                    metadata = block.func_149660_a(world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, side_interpolated, hitX, hitY, hitZ, metadata);
                                                }
                                                tempStack = itemStack.func_77946_l();
                                                tempStack.func_77964_b(metadata);
                                                if (effectiveSide != 6) break block28;
                                                if (!this.canCoverSide(TE, world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, 6)) break block29;
                                                if (!TE.hasAttribute(TEBase.ATTR_COVER[6])) break block28;
                                            }
                                            effectiveSide = side;
                                        }
                                        if (this.canCoverSide(TE, world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, effectiveSide)) {
                                            if (!TE.hasAttribute(TEBase.ATTR_COVER[effectiveSide])) {
                                                TE.addAttribute(TEBase.ATTR_COVER[effectiveSide], tempStack);
                                                actionResult.setAltered().decInventory().setSoundSource(itemStack);
                                            }
                                        }
                                        break block24;
                                    }
                                    if (!entityPlayer.func_70093_af()) break block24;
                                    if (!FeatureRegistry.enableIllumination || !BlockProperties.isIlluminator(itemStack)) break block30;
                                    if (!TE.hasAttribute((byte)21)) {
                                        TE.addAttribute((byte)21, itemStack);
                                        actionResult.setAltered().decInventory().setSoundSource(itemStack);
                                    }
                                    break block24;
                                }
                                if (!FeatureRegistry.enableOverlays || !BlockProperties.isOverlay(itemStack)) break block31;
                                if (TE.hasAttribute(TEBase.ATTR_OVERLAY[effectiveSide])) break block24;
                                if (effectiveSide >= 6) break block32;
                                if (TE.hasAttribute(TEBase.ATTR_COVER[effectiveSide])) break block33;
                            }
                            if (effectiveSide != 6) break block24;
                        }
                        TE.addAttribute(TEBase.ATTR_OVERLAY[effectiveSide], itemStack);
                        actionResult.setAltered().decInventory().setSoundSource(itemStack);
                        break block24;
                    }
                    if (FeatureRegistry.enableDyeColors && BlockProperties.isDye(itemStack, false)) {
                        if (!TE.hasAttribute(TEBase.ATTR_DYE[effectiveSide])) {
                            TE.addAttribute(TEBase.ATTR_DYE[effectiveSide], itemStack);
                            actionResult.setAltered().decInventory().setSoundSource(itemStack);
                        }
                    }
                }
                if (!actionResult.altered) {
                    this.postOnBlockActivated(TE, entityPlayer, side, hitX, hitY, hitZ, actionResult);
                } else {
                    if (actionResult.itemStack == null) {
                        actionResult.setSoundSource(BlockProperties.getCover(TE, 6));
                    }
                    this.damageItemWithChance(world, entityPlayer);
                    this.func_149695_a(world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, (Block)this);
                    world.func_147459_d(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, (Block)this);
                }
                if (actionResult.playSound) {
                    BlockProperties.playBlockSound(TE.func_145831_w(), actionResult.itemStack, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, false);
                }
                if (actionResult.decInv) {
                    EntityLivingUtil.decrementCurrentSlot(entityPlayer);
                }
            }
            return actionResult.altered;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    public boolean onChiselClick(TEBase TE, int side, boolean leftClick) {
        String design = TE.getChiselDesign(side);
        String designAdj = "";
        if (design.equals("")) {
            TEBase[] TE_list;
            World world = TE.func_145831_w();
            for (TEBase TE_current : TE_list = this.getAdjacentTileEntities(world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e)) {
                if (TE_current == null) continue;
                TE_current.func_145838_q();
                if (!TE_current.hasChiselDesign(side)) continue;
                designAdj = design = TE_current.getChiselDesign(side);
            }
        }
        if (designAdj.equals("")) {
            String string = design = leftClick ? DesignHandler.getPrev("chisel", design) : DesignHandler.getNext("chisel", design);
        }
        if (!design.equals("")) {
            TE.setChiselDesign(side, design);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            for (int side = 0; side < 6; ++side) {
                if (!TE.hasAttribute(TEBase.ATTR_COVER[side])) continue;
                if (!this.canCoverSide(TE, world, x, y, z, side)) {
                    TE.removeAttributes(side);
                    continue;
                }
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                if (!world.isSideSolid(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite()) || !this.isSideSolid((IBlockAccess)world, x, y, z, dir)) continue;
                TE.removeAttributes(side);
            }
        }
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        int power = 0;
        if (TE != null) {
            for (int idx = 0; idx < 7; ++idx) {
                Block block;
                int tempPower;
                if (!TE.hasAttribute(TEBase.ATTR_COVER[idx]) || (tempPower = (block = BlockProperties.toBlock(BlockProperties.getCover(TE, idx))).func_149709_b(blockAccess, x, y, z, side)) <= power) continue;
                power = tempPower;
            }
        }
        return power;
    }

    public int func_149748_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        int power = 0;
        if (TE != null) {
            Block block;
            int tempPower;
            int effectiveSide = ForgeDirection.OPPOSITES[side];
            if (TE.hasAttribute(TEBase.ATTR_COVER[effectiveSide])) {
                Block block2 = BlockProperties.toBlock(BlockProperties.getCover(TE, effectiveSide));
                int tempPower2 = block2.func_149709_b(blockAccess, x, y, z, side);
                if (tempPower2 > power) {
                    power = tempPower2;
                }
            } else if (TE.hasAttribute(TEBase.ATTR_COVER[6]) && (tempPower = (block = BlockProperties.toBlock(BlockProperties.getCover(TE, 6))).func_149709_b(blockAccess, x, y, z, side)) > power) {
                power = tempPower;
            }
        }
        return power;
    }

    protected boolean suppressDestroyBlock(EntityPlayer entityPlayer) {
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            return entityPlayer.field_71075_bZ.field_75098_d && item != null && (item instanceof ICarpentersHammer || item instanceof ICarpentersChisel);
        }
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer entityPlayer, int x, int y, int z) {
        if (!this.suppressDestroyBlock(entityPlayer)) {
            return super.removedByPlayer(world, entityPlayer, x, y, z);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (TE != null) {
            int effectiveSide = TE.hasAttribute(TEBase.ATTR_COVER[target.field_72310_e]) ? target.field_72310_e : 6;
            ItemStack itemStack = BlockProperties.getCover(TE, effectiveSide);
            if (TE.hasAttribute(TEBase.ATTR_OVERLAY[effectiveSide])) {
                OverlayHandler.Overlay overlay = OverlayHandler.getOverlayType(TE.getAttribute(TEBase.ATTR_OVERLAY[effectiveSide]));
                if (OverlayHandler.coversFullSide(overlay, target.field_72310_e)) {
                    itemStack = overlay.getItemStack();
                }
            }
            Block block = BlockProperties.toBlock(itemStack);
            double xOffset = (double)target.field_72311_b + world.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)0.2f) + (double)0.1f + block.func_149704_x();
            double yOffset = (double)target.field_72312_c + world.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)0.2f) + (double)0.1f + block.func_149665_z();
            double zOffset = (double)target.field_72309_d + world.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)0.2f) + (double)0.1f + block.func_149706_B();
            switch (target.field_72310_e) {
                case 0: {
                    yOffset = (double)target.field_72312_c + block.func_149665_z() - 0.1;
                    break;
                }
                case 1: {
                    yOffset = (double)target.field_72312_c + block.func_149669_A() + 0.1;
                    break;
                }
                case 2: {
                    zOffset = (double)target.field_72309_d + block.func_149706_B() - 0.1;
                    break;
                }
                case 3: {
                    zOffset = (double)target.field_72309_d + block.func_149693_C() + 0.1;
                    break;
                }
                case 4: {
                    xOffset = (double)target.field_72311_b + block.func_149704_x() - 0.1;
                    break;
                }
                case 5: {
                    xOffset = (double)target.field_72311_b + block.func_149753_y() + 0.1;
                }
            }
            ParticleHelper.addHitEffect(TE, target, xOffset, yOffset, zOffset, itemStack, effectRenderer);
            return true;
        }
        return super.addHitEffects(world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int metadata, EffectRenderer effectRenderer) {
        EntityPlayer entityPlayer;
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && (entityPlayer = world.func_72977_a((double)x, (double)y, (double)z, 6.5)) != null) {
            if (!this.suppressDestroyBlock(entityPlayer)) {
                ParticleHelper.addDestroyEffect(world, x, y, z, BlockProperties.getCover(TE, 6), effectRenderer);
            } else {
                return true;
            }
        }
        return false;
    }

    protected int getLightValue(TEBase TE, Block block, int metadata) {
        int lightValue = block.func_149750_m();
        if (lightValue == 0) {
            TE.setMetadata(metadata);
            lightValue = block.getLightValue((IBlockAccess)TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
            TE.restoreMetadata();
        }
        return lightValue;
    }

    /*
     * Unable to fully structure code
     */
    public int getLightValue(IBlockAccess blockAccess, int x, int y, int z) {
        block4: {
            lightValue = 0;
            if (this.grabLightValue) {
                return 0;
            }
            this.grabLightValue = true;
            TE = this.getTileEntity(blockAccess, x, y, z);
            if (TE == null) break block4;
            if (!FeatureRegistry.enableIllumination) ** GOTO lbl-1000
            if (TE.hasAttribute((byte)21)) {
                lightValue = 15;
            } else lbl-1000:
            // 4 sources

            {
                for (side = 0; side < 7; ++side) {
                    if (!TE.hasAttribute(TEBase.ATTR_COVER[side]) || (tempLight = this.getLightValue(TE, BlockProperties.toBlock(itemStack = BlockProperties.getCover(TE, side)), itemStack.func_77960_j())) <= lightValue) continue;
                    lightValue = tempLight;
                }
            }
        }
        this.grabLightValue = false;
        return lightValue;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (TE.hasAttribute(TEBase.ATTR_COVER[6])) {
                return BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_149712_f(world, x, y, z);
            }
        }
        return this.field_149782_v;
    }

    public int getFlammability(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection face) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            return Blocks.field_150480_ab.getFlammability(BlockProperties.toBlock(BlockProperties.getCover(TE, 6)));
        }
        return super.getFlammability(blockAccess, x, y, z, face);
    }

    public int getFireSpreadSpeed(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection side) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            return Blocks.field_150480_ab.getEncouragement(BlockProperties.toBlock(BlockProperties.getCover(TE, 6)));
        }
        return super.getFireSpreadSpeed(blockAccess, x, y, z, side);
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (TE.hasAttribute(TEBase.ATTR_COVER[6])) {
                return BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).isFireSource(world, x, y, z, side);
            }
        }
        return false;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (TE.hasAttribute(TEBase.ATTR_COVER[6])) {
                return BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_149638_a(entity);
            }
        }
        return this.func_149638_a(entity);
    }

    public boolean isWood(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            if (TE.hasAttribute(TEBase.ATTR_COVER[6])) {
                return BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).isWood(blockAccess, x, y, z);
            }
        }
        return super.isWood(blockAccess, x, y, z);
    }

    public boolean canEntityDestroy(IBlockAccess blockAccess, int x, int y, int z, Entity entity) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            if (TE.hasAttribute(TEBase.ATTR_COVER[6])) {
                Block block = BlockProperties.toBlock(BlockProperties.getCover(TE, 6));
                if (entity instanceof EntityWither) {
                    return !block.equals(Blocks.field_150357_h) && !block.equals(Blocks.field_150384_bq) && !block.equals(Blocks.field_150378_br) && !block.equals(Blocks.field_150483_bI);
                }
                if (entity instanceof EntityDragon) {
                    return !block.equals(Blocks.field_150343_Z) && !block.equals(Blocks.field_150377_bs) && !block.equals(Blocks.field_150357_h);
                }
            }
        }
        return super.canEntityDestroy(blockAccess, x, y, z, entity);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (TE.hasAttribute(TEBase.ATTR_COVER[6])) {
                BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_149670_a(world, x, y, z, entity);
            }
        }
    }

    public void func_149690_a(World world, int x, int y, int z, int metadata, float harvestLevel, int fortune) {
        if (this.enableDrops) {
            super.func_149690_a(world, x, y, z, metadata, harvestLevel, fortune);
        } else {
            this.func_149642_a(world, x, y, z, this.getItemDrop(world, metadata));
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        for (ItemStack itemStack : this.getDrops(world, x, y, z, 16, 0)) {
            this.enableDrops = true;
            this.func_149642_a(world, x, y, z, itemStack);
            this.enableDrops = false;
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (metadata == 16) {
            ret.clear();
        }
        if (TE != null) {
            for (int idx = 0; idx < 7; ++idx) {
                if (TE.hasAttribute(TEBase.ATTR_COVER[idx])) {
                    ret.add(BlockProperties.getCoverForDrop(TE, idx));
                }
                if (TE.hasAttribute(TEBase.ATTR_OVERLAY[idx])) {
                    ret.add(TE.getAttribute(TEBase.ATTR_OVERLAY[idx]));
                }
                if (!TE.hasAttribute(TEBase.ATTR_DYE[idx])) continue;
                ret.add(TE.getAttribute(TEBase.ATTR_DYE[idx]));
            }
            if (TE.hasAttribute((byte)21)) {
                ret.add(TE.getAttribute((byte)21));
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (TE.hasAttribute(TEBase.ATTR_COVER[6])) {
                BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_149734_b(world, x, y, z, random);
            }
            if (TE.hasAttribute(TEBase.ATTR_OVERLAY[6])) {
                if (OverlayHandler.getOverlayType(TE.getAttribute(TEBase.ATTR_OVERLAY[6])).equals((Object)OverlayHandler.Overlay.MYCELIUM)) {
                    Blocks.field_150391_bh.func_149734_b(world, x, y, z, random);
                }
            }
        }
    }

    public boolean canSustainPlant(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection side, IPlantable plantable) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            if (!this.isSideSolid(blockAccess, x, y, z, side)) {
                return false;
            }
            ArrayList<Object> blocks = new ArrayList<Object>();
            for (int side1 = 1; side1 < 7; side1 += 5) {
                if (TE.hasAttribute(TEBase.ATTR_COVER[side1])) {
                    blocks.add(BlockProperties.toBlock(BlockProperties.getCover(TE, side1)));
                }
                if (!TE.hasAttribute(TEBase.ATTR_OVERLAY[side1])) continue;
                blocks.add(BlockProperties.toBlock(OverlayHandler.getOverlayType(TE.getAttribute(TEBase.ATTR_OVERLAY[side1])).getItemStack()));
            }
            Material material = BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_149688_o();
            if (material.equals(Material.field_151577_b)) {
                blocks.add(Blocks.field_150349_c);
            } else if (material.equals(Material.field_151578_c)) {
                blocks.add(Blocks.field_150346_d);
            } else if (material.equals(Material.field_151595_p)) {
                blocks.add(Blocks.field_150354_m);
            }
            switch (plantable.getPlantType(blockAccess, x, y + 1, z)) {
                case Desert: {
                    return blocks.contains(Blocks.field_150354_m);
                }
                case Nether: {
                    return blocks.contains(Blocks.field_150425_aM);
                }
                case Plains: {
                    return blocks.contains(Blocks.field_150349_c) || blocks.contains(Blocks.field_150346_d);
                }
                case Beach: {
                    boolean isBeach = blocks.contains(Blocks.field_150349_c) || blocks.contains(Blocks.field_150346_d) || blocks.contains(Blocks.field_150354_m);
                    boolean hasWater = blockAccess.func_147439_a(x - 1, y, z).func_149688_o() == Material.field_151586_h || blockAccess.func_147439_a(x + 1, y, z).func_149688_o() == Material.field_151586_h || blockAccess.func_147439_a(x, y, z - 1).func_149688_o() == Material.field_151586_h || blockAccess.func_147439_a(x, y, z + 1).func_149688_o() == Material.field_151586_h;
                    return isBeach && hasWater;
                }
            }
        }
        return super.canSustainPlant(blockAccess, x, y, z, side, plantable);
    }

    protected boolean isBlockSolid(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            return !TE.hasAttribute(TEBase.ATTR_COVER[6]) || BlockProperties.toBlock(BlockProperties.getCover(TE, 6)).func_149662_c();
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            TE.setOwner(entityLiving.func_110124_au());
        }
    }

    public float func_149737_a(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        Item item;
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && ((item = itemStack.func_77973_b()) instanceof ICarpentersHammer || item instanceof ICarpentersChisel)) {
            return -1.0f;
        }
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            return ForgeHooks.blockStrength((Block)BlockProperties.toBlock(BlockProperties.getCover(TE, 6)), (EntityPlayer)entityPlayer, (World)world, (int)x, (int)y, (int)z);
        }
        return super.func_149737_a(entityPlayer, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TEBase TE;
        if (y > 0 && y < blockAccess.func_72800_K() && (TE = this.getTileEntity(blockAccess, x, y, z)) != null) {
            ForgeDirection side_src = ForgeDirection.getOrientation((int)side);
            ForgeDirection side_adj = side_src.getOpposite();
            TEBase TE_adj = (TEBase)blockAccess.func_147438_o(x, y, z);
            TEBase TE_src = (TEBase)blockAccess.func_147438_o(x + side_adj.offsetX, y + side_adj.offsetY, z + side_adj.offsetZ);
            if (TE_adj.func_145838_q().isSideSolid(blockAccess, x, y, z, side_adj) == TE_src.func_145838_q().isSideSolid(blockAccess, x + side_adj.offsetX, y + side_adj.offsetY, z + side_adj.offsetZ, ForgeDirection.getOrientation((int)side)) && this.shareFaces(TE_adj, TE_src, side_adj, side_src)) {
                Block block_adj = BlockProperties.toBlock(BlockProperties.getCover(TE_adj, 6));
                Block block_src = BlockProperties.toBlock(BlockProperties.getCover(TE_src, 6));
                if (!TE_adj.hasAttribute(TEBase.ATTR_COVER[6])) {
                    return TE_src.hasAttribute(TEBase.ATTR_COVER[6]);
                }
                if (!TE_src.hasAttribute(TEBase.ATTR_COVER[6]) && block_adj.func_149701_w() == 0) {
                    return !block_adj.func_149662_c();
                }
                return !TE_src.hasAttribute(TEBase.ATTR_COVER[6]) || block_src.func_149662_c() != block_adj.func_149662_c() || block_src.func_149701_w() != block_adj.func_149701_w();
            }
        }
        return super.func_149646_a(blockAccess, x, y, z, side);
    }

    public boolean canRenderInPass(int pass) {
        ForgeHooksClient.setRenderPass((int)pass);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        if (ForgeHooksClient.getWorldRenderPass() < 0) {
            return 0;
        }
        return 1;
    }

    protected boolean shareFaces(TEBase TE_adj, TEBase TE_src, ForgeDirection side_adj, ForgeDirection side_src) {
        return TE_adj.func_145838_q().isSideSolid((IBlockAccess)TE_adj.func_145831_w(), TE_adj.field_145851_c, TE_adj.field_145848_d, TE_adj.field_145849_e, side_adj) && TE_src.func_145838_q().isSideSolid((IBlockAccess)TE_src.func_145831_w(), TE_src.field_145851_c, TE_src.field_145848_d, TE_src.field_145849_e, side_src);
    }

    public boolean func_149662_c() {
        Class clazz;
        if (FeatureRegistry.enableRoutableFluids && (clazz = FancyFluidsHelper.getCallerClass()) != null) {
            for (Class clazz1 : FancyFluidsHelper.liquidClasses) {
                if (!clazz.isAssignableFrom(clazz1)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149710_n() {
        return true;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147455_a(x, y, z, this.func_149915_a(world, 0));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TEBase();
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    protected void preOnBlockClicked(TEBase TE, World world, int x, int y, int z, EntityPlayer entityPlayer, ActionResult actionResult) {
    }

    protected void preOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, ActionResult actionResult) {
    }

    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, ActionResult actionResult) {
    }

    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        return false;
    }

    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        return false;
    }

    protected void damageItemWithChance(World world, EntityPlayer entityPlayer) {
        Item item = entityPlayer.func_71045_bC().func_77973_b();
        if (item instanceof ICarpentersHammer) {
            ((ICarpentersHammer)item).onHammerUse(world, entityPlayer);
        } else if (item instanceof ICarpentersChisel) {
            ((ICarpentersChisel)item).onChiselUse(world, entityPlayer);
        }
    }

    protected boolean canCoverSide(TEBase TE, World world, int x, int y, int z, int side) {
        return side == 6;
    }

    protected TEBase getTileEntityForBlockActivation(TEBase TE) {
        return TE;
    }

    protected class ActionResult {
        public ItemStack itemStack;
        public boolean playSound = true;
        public boolean altered = false;
        public boolean decInv = false;

        protected ActionResult() {
        }

        public ActionResult setSoundSource(ItemStack itemStack) {
            this.itemStack = itemStack;
            return this;
        }

        public ActionResult setNoSound() {
            this.playSound = false;
            return this;
        }

        public ActionResult setAltered() {
            this.altered = true;
            return this;
        }

        public ActionResult decInventory() {
            this.decInv = true;
            return this;
        }
    }
}

