/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.block.BlockSided;
import com.carpentersblocks.data.Torch;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersTorch;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.FeatureRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersTorch
extends BlockSided {
    private static final Torch data = new Torch();
    public static final String[] type = new String[]{"vanilla", "lantern"};

    public BlockCarpentersTorch(Material material) {
        super(material, data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_torch = iconRegister.func_94245_a("CarpentersBlocks:torch/torch");
        IconRegistry.icon_torch_head_lit = iconRegister.func_94245_a("CarpentersBlocks:torch/torch_head_lit");
        IconRegistry.icon_torch_head_smoldering = iconRegister.func_94245_a("CarpentersBlocks:torch/torch_head_smoldering");
        IconRegistry.icon_torch_head_unlit = iconRegister.func_94245_a("CarpentersBlocks:torch/torch_head_unlit");
        IconRegistry.icon_lantern_glass = iconRegister.func_94245_a("CarpentersBlocks:torch/lantern_glass");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return IconRegistry.icon_torch;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int temp = data.getType(TE);
        if (++temp > type.length - 1) {
            temp = 0;
        }
        data.setType(TE, temp);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int temp = data.getType(TE);
        if (--temp < 0) {
            temp = type.length - 1;
        }
        data.setType(TE, temp);
        return true;
    }

    @Override
    protected void preOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        Block block;
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemBlock && !data.getState(TE).equals((Object)Torch.State.LIT) && ((block = BlockProperties.toBlock(itemStack)).equals(BlockRegistry.blockCarpentersTorch) || block.equals(Blocks.field_150478_aa))) {
            data.setState(TE, Torch.State.LIT);
            actionResult.setAltered();
        }
    }

    @Override
    public int getLightValue(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            int coverLight = super.getLightValue(blockAccess, x, y, z);
            int torchLight = 0;
            switch (data.getState(TE)) {
                case LIT: {
                    torchLight = 15;
                    break;
                }
                case SMOLDERING: {
                    torchLight = 10;
                    break;
                }
            }
            return coverLight > torchLight ? coverLight : torchLight;
        }
        return super.func_149750_m();
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (data.getType(TE) == 1) {
                return super.func_149668_a(world, x, y, z);
            }
        }
        return null;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            ForgeDirection side = data.getDirection(TE);
            if (data.getType(TE) == 0) {
                switch (side) {
                    case UP: {
                        this.func_149676_a(0.4f, 0.0f, 0.4f, 0.6f, 0.6f, 0.6f);
                        break;
                    }
                    default: {
                        this.setBlockBounds(0.35f, 0.2f, 0.0f, 0.65f, 0.8f, 0.3f, side);
                        break;
                    }
                }
            } else {
                switch (side) {
                    case UP: {
                        this.func_149676_a(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.9375f, 0.8125f);
                        break;
                    }
                    default: {
                        this.setBlockBounds(0.1875f, 0.25f, 0.0f, 0.8125f, 0.9375f, 0.8125f, side);
                    }
                }
            }
        }
    }

    @Override
    public boolean canAttachToSide(int side) {
        return side != 0;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            if (data.getType(TE) == 0) {
                boolean isWet = world.func_72951_B(x, y, z);
                boolean canDropState = FeatureRegistry.enableTorchWeatherEffects;
                switch (data.getState(TE)) {
                    case LIT: {
                        if (!canDropState || !isWet) break;
                        data.setState(TE, Torch.State.SMOLDERING);
                        break;
                    }
                    case SMOLDERING: {
                        if (canDropState && isWet) {
                            data.setState(TE, Torch.State.UNLIT);
                            break;
                        }
                        data.setState(TE, Torch.State.LIT);
                        break;
                    }
                    case UNLIT: {
                        if (canDropState && isWet) break;
                        data.setState(TE, Torch.State.SMOLDERING);
                        break;
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        Torch.State state;
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && !(state = data.getState(TE)).equals((Object)Torch.State.UNLIT)) {
            double[] headCoords = data.getHeadCoordinates(TE);
            world.func_72869_a("smoke", headCoords[0], headCoords[1], headCoords[2], 0.0, 0.0, 0.0);
            if (state.equals((Object)Torch.State.LIT)) {
                world.func_72869_a("flame", headCoords[0], headCoords[1], headCoords[2], 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TECarpentersTorch();
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersTorchRenderID;
    }
}

