/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.Slope;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.EntityLivingUtil;
import com.carpentersblocks.util.handler.EventHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import com.carpentersblocks.util.registry.ItemRegistry;
import com.carpentersblocks.util.slope.SlopeTransform;
import com.carpentersblocks.util.slope.SlopeUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersSlope
extends BlockCoverable {
    public static final String[] slopeType = new String[]{"wedge", "obliqueInterior", "obliqueExterior", "prism", "prismWedge"};
    public static final int META_WEDGE = 0;
    public static final int META_OBLIQUE_INT = 1;
    public static final int META_OBLIQUE_EXT = 2;
    public static final int META_PRISM = 3;
    public static final int META_PRISM_SLOPE = 4;
    private boolean rayTracing;
    private final int CORNER_SE = 0;
    private final int CORNER_NE = 1;
    private final int CORNER_NW = 2;
    private final int CORNER_SW = 3;

    public BlockCarpentersSlope(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_uncovered_oblique_pos = iconRegister.func_94245_a("CarpentersBlocks:slope/oblique_pos");
        IconRegistry.icon_uncovered_oblique_neg = iconRegister.func_94245_a("CarpentersBlocks:slope/oblique_neg");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return IconRegistry.icon_uncovered_full;
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int slopeID = TE.getData();
        Slope slope = Slope.slopesList[slopeID];
        switch (slope.type) {
            case WEDGE_SIDE: {
                if (++slopeID <= 3) break;
                slopeID = 0;
                break;
            }
            case WEDGE: {
                if (slope.isPositive) {
                    if (++slopeID <= 11) break;
                    slopeID = 8;
                    break;
                }
                if (++slopeID <= 7) break;
                slopeID = 4;
                break;
            }
            case WEDGE_INT: {
                if (slope.isPositive) {
                    if (++slopeID <= 19) break;
                    slopeID = 16;
                    break;
                }
                if (++slopeID <= 15) break;
                slopeID = 12;
                break;
            }
            case WEDGE_EXT: {
                if (slope.isPositive) {
                    if (++slopeID <= 27) break;
                    slopeID = 24;
                    break;
                }
                if (++slopeID <= 23) break;
                slopeID = 20;
                break;
            }
            case OBLIQUE_INT: {
                if (slope.isPositive) {
                    if (++slopeID <= 35) break;
                    slopeID = 32;
                    break;
                }
                if (++slopeID <= 31) break;
                slopeID = 28;
                break;
            }
            case OBLIQUE_EXT: {
                if (slope.isPositive) {
                    if (++slopeID <= 43) break;
                    slopeID = 40;
                    break;
                }
                if (++slopeID <= 39) break;
                slopeID = 36;
                break;
            }
            case PRISM_1P: {
                if (++slopeID <= 49) break;
                slopeID = 46;
                break;
            }
            case PRISM_2P: {
                if (slope.equals(Slope.PRISM_2P_POS_NS)) {
                    slopeID = 51;
                    break;
                }
                if (slope.equals(Slope.PRISM_2P_POS_WE)) {
                    slopeID = 50;
                    break;
                }
                if (++slopeID <= 55) break;
                slopeID = 52;
                break;
            }
            case PRISM_3P: {
                if (++slopeID <= 59) break;
                slopeID = 56;
                break;
            }
            case PRISM_WEDGE: {
                if (++slopeID <= 64) break;
                slopeID = 61;
                break;
            }
        }
        TE.setData(slopeID);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        int slopeID = TE.getData();
        Slope slope = Slope.slopesList[slopeID];
        switch (slope.type) {
            case WEDGE_SIDE: {
                slopeID += 8;
                break;
            }
            case WEDGE: {
                if (slope.isPositive) {
                    slopeID -= 4;
                    break;
                }
                slopeID += 12;
                break;
            }
            case WEDGE_INT: {
                if (slope.isPositive) {
                    slopeID -= 4;
                    break;
                }
                slopeID += 12;
                break;
            }
            case WEDGE_EXT: {
                if (slope.isPositive) {
                    slopeID -= 4;
                    break;
                }
                slopeID += 12;
                break;
            }
            case OBLIQUE_INT: {
                if (slope.isPositive) {
                    slopeID -= 4;
                    break;
                }
                slopeID += 12;
                break;
            }
            case OBLIQUE_EXT: {
                if (slope.isPositive) {
                    slopeID -= 4;
                    break;
                }
                slopeID = 45;
                break;
            }
            case PRISM: {
                if (slope.isPositive) {
                    slopeID = 44;
                    break;
                }
                slopeID = 46;
                break;
            }
            case PRISM_1P: {
                slopeID = 50;
                break;
            }
            case PRISM_2P: {
                if (slope.equals(Slope.PRISM_2P_POS_NS) || slope.equals(Slope.PRISM_2P_POS_WE)) {
                    slopeID = 52;
                    break;
                }
                slopeID = 56;
                break;
            }
            case PRISM_3P: {
                slopeID = 60;
                break;
            }
            case PRISM_4P: {
                slopeID = 61;
                break;
            }
            case PRISM_WEDGE: {
                slopeID = 0;
                break;
            }
        }
        TE.setData(slopeID);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
    }

    @Override
    protected void damageItemWithChance(World world, EntityPlayer entityPlayer) {
        if ((double)world.field_73012_v.nextFloat() <= ItemRegistry.itemHammerDamageChanceFromSlopes) {
            super.damageItemWithChance(world, entityPlayer);
        }
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE;
        if (!this.rayTracing && (TE = this.getTileEntity(blockAccess, x, y, z)) != null) {
            int slopeID = TE.getData();
            Slope slope = Slope.slopesList[slopeID];
            switch (slope.getPrimaryType()) {
                case PRISM_1P: 
                case PRISM_2P: 
                case PRISM_3P: 
                case PRISM: 
                case PRISM_4P: {
                    if (slope.isPositive) {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
                        break;
                    }
                    this.func_149676_a(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                default: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        MovingObjectPosition finalTrace = null;
        if (TE != null) {
            Slope slope = Slope.slopesList[TE.getData()];
            SlopeUtil slopeUtil = new SlopeUtil();
            int numPasses = slopeUtil.getNumPasses(slope);
            int precision = slopeUtil.getNumBoxesPerPass(slope);
            this.rayTracing = true;
            for (int pass = 0; pass < numPasses; ++pass) {
                for (int slice = 0; slice < precision && finalTrace == null; ++slice) {
                    float[] box = slopeUtil.genBounds(slope, slice, precision, pass);
                    if (box == null) continue;
                    this.func_149676_a(box[0], box[1], box[2], box[3], box[4], box[5]);
                    finalTrace = super.func_149731_a(world, x, y, z, startVec, endVec);
                }
                if (!slope.type.equals((Object)Slope.Type.OBLIQUE_EXT)) continue;
                --precision;
            }
            this.rayTracing = false;
            if (finalTrace != null) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                finalTrace = super.func_149731_a(world, x, y, z, startVec, endVec);
            }
        }
        return finalTrace;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisAlignedBB, List list, Entity entity) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            AxisAlignedBB box = null;
            Slope slope = Slope.slopesList[TE.getData()];
            SlopeUtil slopeUtil = new SlopeUtil();
            int precision = slopeUtil.getNumBoxesPerPass(slope);
            int numPasses = slopeUtil.getNumPasses(slope);
            for (int pass = 0; pass < numPasses; ++pass) {
                for (int slice = 0; slice < precision; ++slice) {
                    float[] dim = slopeUtil.genBounds(slope, slice, precision, pass);
                    if (dim != null) {
                        box = AxisAlignedBB.func_72330_a((double)((float)x + dim[0]), (double)((float)y + dim[1]), (double)((float)z + dim[2]), (double)((float)x + dim[3]), (double)((float)y + dim[4]), (double)((float)z + dim[5]));
                    }
                    if (box == null || !axisAlignedBB.func_72326_a(box)) continue;
                    list.add(box);
                }
                if (!slope.type.equals((Object)Slope.Type.OBLIQUE_EXT)) continue;
                --precision;
            }
        }
    }

    public boolean isSideSolid(IBlockAccess blockAccess, int x, int y, int z, ForgeDirection side) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null && this.isBlockSolid(blockAccess, x, y, z)) {
            return Slope.slopesList[TE.getData()].isFaceFull(side);
        }
        return false;
    }

    @Override
    protected boolean shareFaces(TEBase TE_adj, TEBase TE_src, ForgeDirection side_adj, ForgeDirection side_src) {
        if (TE_adj.func_145838_q() == this) {
            Slope slope_src = Slope.slopesList[TE_src.getData()];
            Slope slope_adj = Slope.slopesList[TE_adj.getData()];
            if (!slope_adj.hasSide(side_adj)) {
                return false;
            }
            return slope_src.getFaceBias(side_src) == slope_adj.getFaceBias(side_adj);
        }
        return super.shareFaces(TE_adj, TE_src, side_adj, side_src);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        EventHandler.eventFace = side;
        EventHandler.hitX = hitX;
        EventHandler.hitY = hitY;
        EventHandler.hitZ = hitZ;
        return metadata;
    }

    private int getWedgeOrientation(ForgeDirection dir, int side, double hitX, double hitY, double hitZ) {
        switch (side) {
            case 2: {
                hitX = 1.0 - hitX;
                break;
            }
            case 4: {
                hitX = hitZ;
                break;
            }
            case 5: {
                hitX = 1.0 - hitZ;
            }
        }
        int slopeID = side > 1 ? (hitY > 0.5 && hitX > 1.0 - hitY && hitX < hitY ? side + 2 : (hitY < 0.5 && hitX < 1.0 - hitY && hitX > hitY ? side + 6 : (hitX < (double)0.2f ? (side == 2 ? 1 : (side == 3 ? 0 : (side == 4 ? 3 : 2))) : (hitX > (double)0.8f ? (side == 2 ? 2 : (side == 3 ? 3 : (side == 4 ? 1 : 0))) : (hitY > 0.5 ? side + 2 : side + 6))))) : side + 12;
        if (slopeID > 11) {
            switch (dir) {
                case NORTH: {
                    return slopeID == 12 ? 5 : 9;
                }
                case SOUTH: {
                    return slopeID == 12 ? 4 : 8;
                }
                case WEST: {
                    return slopeID == 12 ? 7 : 11;
                }
                case EAST: {
                    return slopeID == 12 ? 6 : 10;
                }
            }
            return 0;
        }
        return slopeID;
    }

    private int getCorner(float rotationYaw) {
        switch ((MathHelper.func_76128_c((double)(rotationYaw * 4.0f / 360.0f)) & 3) % 4) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 3;
            }
        }
        return 2;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            int slopeID = 0;
            int metadata = world.func_72805_g(x, y, z);
            boolean isPositive = EventHandler.eventFace > 1 && EventHandler.hitY < 0.5f || EventHandler.eventFace == 1;
            int corner = this.getCorner(entityLiving.field_70177_z);
            ForgeDirection dir = EntityLivingUtil.getFacing(entityLiving).getOpposite();
            block0 : switch (metadata) {
                case 0: {
                    slopeID = this.getWedgeOrientation(dir, EventHandler.eventFace, EventHandler.hitX, EventHandler.hitY, EventHandler.hitZ);
                    if (entityLiving.func_70093_af()) break;
                    slopeID = SlopeTransform.transformWedge(world, slopeID, x, y, z);
                    TE.setData(slopeID);
                    SlopeTransform.transformAdjacentWedges(world, slopeID, x, y, z);
                    break;
                }
                case 1: {
                    switch (corner) {
                        case 0: {
                            slopeID = isPositive ? 32 : 28;
                            break;
                        }
                        case 1: {
                            slopeID = isPositive ? 34 : 30;
                            break;
                        }
                        case 2: {
                            slopeID = isPositive ? 33 : 29;
                            break;
                        }
                        case 3: {
                            slopeID = isPositive ? 35 : 31;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (corner) {
                        case 0: {
                            slopeID = isPositive ? 40 : 36;
                            break;
                        }
                        case 1: {
                            slopeID = isPositive ? 42 : 38;
                            break;
                        }
                        case 2: {
                            slopeID = isPositive ? 41 : 37;
                            break;
                        }
                        case 3: {
                            slopeID = isPositive ? 43 : 39;
                        }
                    }
                    break;
                }
                case 3: {
                    if (isPositive) {
                        slopeID = 45;
                        if (entityLiving.func_70093_af()) break;
                        slopeID = SlopeTransform.transformPrism(world, slopeID, x, y, z);
                        TE.setData(slopeID);
                        SlopeTransform.transformAdjacentPrisms(world, x, y, z);
                        break;
                    }
                    slopeID = 44;
                    break;
                }
                case 4: {
                    switch (dir) {
                        case NORTH: {
                            slopeID = 62;
                            break block0;
                        }
                        case SOUTH: {
                            slopeID = 61;
                            break block0;
                        }
                        case WEST: {
                            slopeID = 64;
                            break block0;
                        }
                        case EAST: {
                            slopeID = 63;
                            break block0;
                        }
                    }
                }
            }
            TE.setData(slopeID);
        }
        super.func_149689_a(world, x, y, z, entityLiving, itemStack);
    }

    @Override
    public boolean canCoverSide(TEBase TE, World world, int x, int y, int z, int side) {
        return super.canCoverSide(TE, world, x, y, z, side) || this.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.getOrientation((int)side));
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersSlopeRenderID;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TEBase) {
            TEBase cbTile = (TEBase)tile;
            int data = cbTile.getData();
            int dataAngle = data % 4;
            switch (axis) {
                case UP: {
                    switch (dataAngle) {
                        case 0: {
                            cbTile.setData(data + 3);
                            break;
                        }
                        case 1: {
                            cbTile.setData(data + 1);
                            break;
                        }
                        case 2: {
                            cbTile.setData(data - 2);
                            break;
                        }
                        case 3: {
                            cbTile.setData(data - 2);
                        }
                    }
                    break;
                }
                case DOWN: {
                    switch (dataAngle) {
                        case 0: {
                            cbTile.setData(data + 2);
                            break;
                        }
                        case 1: {
                            cbTile.setData(data + 2);
                            break;
                        }
                        case 2: {
                            cbTile.setData(data - 1);
                            break;
                        }
                        case 3: {
                            cbTile.setData(data - 3);
                        }
                    }
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

