/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.data.FlowerPot;
import com.carpentersblocks.network.PacketEnrichPlant;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.tileentity.TECarpentersFlowerPot;
import com.carpentersblocks.util.BlockProperties;
import com.carpentersblocks.util.flowerpot.FlowerPotHandler;
import com.carpentersblocks.util.flowerpot.FlowerPotProperties;
import com.carpentersblocks.util.handler.EventHandler;
import com.carpentersblocks.util.handler.PacketHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import com.carpentersblocks.util.registry.IconRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCarpentersFlowerPot
extends BlockCoverable {
    public BlockCarpentersFlowerPot(Material material) {
        super(material);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        IconRegistry.icon_flower_pot = iconRegister.func_94245_a("CarpentersBlocks:flowerpot/flower_pot");
        IconRegistry.icon_flower_pot_glass = iconRegister.func_94245_a("CarpentersBlocks:flowerpot/flower_pot_glass");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 1 && metadata == 0) {
            return IconRegistry.icon_flower_pot;
        }
        return super.func_149691_a(side, metadata);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        TE.setPrevDesign();
        TE.removeAttribute(TEBase.ATTR_COVER[6]);
        return true;
    }

    @Override
    protected boolean onHammerRightClick(TEBase TE, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            TE.removeDesign();
        } else {
            TE.setNextDesign();
        }
        TE.removeAttribute(TEBase.ATTR_COVER[6]);
        return true;
    }

    public static boolean isFertilizer(ItemStack itemStack) {
        return itemStack != null ? itemStack.func_77973_b().equals(Items.field_151100_aR) && itemStack.func_77960_j() == 15 : false;
    }

    @Override
    protected void preOnBlockClicked(TEBase TE, World world, int x, int y, int z, EntityPlayer entityPlayer, BlockCoverable.ActionResult actionResult) {
        if (entityPlayer.func_70093_af()) {
            if (EventHandler.hitY > 0.375f) {
                if (TE.hasAttribute((byte)24)) {
                    actionResult.setSoundSource(new ItemStack((Block)Blocks.field_150354_m));
                    actionResult.setAltered();
                    TE.removeAttribute((byte)24);
                }
                if (!actionResult.altered) {
                    if (TE.hasAttribute((byte)22)) {
                        actionResult.setSoundSource(TE.getAttribute((byte)22));
                        actionResult.setAltered();
                        TE.removeAttribute((byte)22);
                    }
                }
            } else if (TE.hasAttribute((byte)23) && EventHandler.eventFace == 1 && EventHandler.hitX > 0.375f && EventHandler.hitX < 0.625f && EventHandler.hitZ > 0.375f && EventHandler.hitZ < 0.625f) {
                actionResult.setSoundSource(TE.getAttribute((byte)23));
                actionResult.setAltered();
                TE.removeAttribute((byte)23);
            }
        }
    }

    @Override
    protected void preOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        ItemStack itemStack = entityPlayer.func_70694_bm();
        if (itemStack != null) {
            boolean hasCover = TE.hasAttribute(TEBase.ATTR_COVER[6]);
            boolean hasOverlay = TE.hasAttribute(TEBase.ATTR_OVERLAY[6]);
            boolean soilAreaClicked = side == 1 && hitX > 0.375f && hitX < 0.625f && hitZ > 0.375f && hitZ < 0.625f;
            if (TE.hasAttribute((byte)23)) {
                if (!soilAreaClicked && (!hasCover && BlockProperties.isCover(itemStack) || !hasOverlay && BlockProperties.isOverlay(itemStack))) {
                    return;
                }
                if (!TE.hasAttribute((byte)22) && FlowerPotProperties.isPlant(itemStack)) {
                    int angle = MathHelper.func_76128_c((double)((double)((entityPlayer.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
                    FlowerPot.setAngle(TE, angle);
                    TE.addAttribute((byte)22, itemStack);
                    actionResult.setAltered().setSoundSource(itemStack).decInventory();
                }
            } else if (FlowerPotProperties.isSoil(itemStack) && (hasCover || soilAreaClicked)) {
                TE.addAttribute((byte)23, itemStack);
                actionResult.setAltered().setSoundSource(itemStack).decInventory();
            }
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TEBase TE;
        if (world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            ItemStack itemStack;
            if (TE.hasAttribute((byte)22) && (itemStack = entityPlayer.func_71045_bC()) != null && itemStack.func_77973_b().equals(Items.field_151100_aR) && itemStack.func_77960_j() == 15) {
                if (!TE.hasAttribute((byte)24) && FlowerPotProperties.isPlantColorable(TE)) {
                    PacketHandler.sendPacketToServer(new PacketEnrichPlant(x, y, z, FlowerPotProperties.getPlantColor(TE)));
                    return true;
                }
            }
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            FlowerPotHandler.Profile profile;
            if (!this.func_149707_d(world, x, y, z, 1)) {
                this.destroyBlock(world, x, y, z, true);
            }
            if (TE.hasAttribute((byte)22) && ((profile = FlowerPotHandler.getPlantProfile(TE)).equals((Object)FlowerPotHandler.Profile.DOUBLEPLANT) || profile.equals((Object)FlowerPotHandler.Profile.THIN_DOUBLEPLANT)) && world.func_147439_a(x, y + 1, z).isSideSolid((IBlockAccess)world, x, y + 1, z, ForgeDirection.DOWN)) {
                TE.removeAttribute((byte)22);
            }
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        Block block_YN = world.func_147439_a(x, y - 1, z);
        return block_YN.isSideSolid((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP) || block_YN.canPlaceTorchOnTop(world, x, y - 1, z);
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            if (TE.hasAttribute((byte)22)) {
                switch (FlowerPotHandler.getPlantProfile(TE)) {
                    case CACTUS: 
                    case LEAVES: {
                        this.func_149676_a(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.99f, 0.6875f);
                        break;
                    }
                    default: {
                        this.func_149676_a(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.75f, 0.6875f);
                        break;
                    }
                }
            } else {
                this.func_149676_a(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.375f, 0.6875f);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_72330_a((double)((float)x + 0.3125f), (double)y, (double)((float)z + 0.3125f), (double)((float)x + 0.6875f), (double)((float)y + 0.375f), (double)((float)z + 0.6875f));
            if (TE.hasAttribute((byte)22)) {
                switch (FlowerPotHandler.getPlantProfile(TE)) {
                    case CACTUS: 
                    case LEAVES: {
                        axisAlignedBB = AxisAlignedBB.func_72330_a((double)((float)x + 0.3125f), (double)y, (double)((float)z + 0.3125f), (double)((float)x + 0.6875f), (double)((float)y + 0.99f), (double)((float)z + 0.6875f));
                        break;
                    }
                }
            }
            return axisAlignedBB;
        }
        return super.func_149668_a(world, x, y, z);
    }

    @Override
    public int getLightValue(IBlockAccess blockAccess, int x, int y, int z) {
        int lightValue = super.getLightValue(blockAccess, x, y, z);
        if (this.grabLightValue) {
            return 0;
        }
        this.grabLightValue = true;
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            int temp;
            ItemStack itemStack;
            if (TE.hasAttribute((byte)23)) {
                itemStack = TE.getAttribute((byte)23);
                temp = this.getLightValue(TE, FlowerPotProperties.toBlock(itemStack), itemStack.func_77960_j());
                if (temp > lightValue) {
                    lightValue = temp;
                }
            }
            if (TE.hasAttribute((byte)22)) {
                itemStack = TE.getAttribute((byte)22);
                temp = this.getLightValue(TE, FlowerPotProperties.toBlock(itemStack), itemStack.func_77960_j());
                if (temp > lightValue) {
                    lightValue = temp;
                }
            }
        }
        this.grabLightValue = false;
        return lightValue;
    }

    @Override
    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            if (TE.hasAttribute((byte)22)) {
                ItemStack itemStack = TE.getAttribute((byte)22);
                TE.setMetadata(itemStack.func_77960_j());
                FlowerPotProperties.toBlock(itemStack).func_149670_a(world, x, y, z, entity);
                TE.restoreMetadata();
            }
        }
        super.func_149670_a(world, x, y, z, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149648_K() {
        return true;
    }

    @Override
    protected boolean canCoverSide(TEBase TE, World world, int x, int y, int z, int side) {
        return side == 6 ? !TE.hasDesign() : false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TEBase TE = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && TE instanceof TECarpentersFlowerPot) {
            ItemStack itemStack;
            if (TE.hasAttribute((byte)22)) {
                itemStack = TE.getAttribute((byte)22);
                TE.setMetadata(itemStack.func_77960_j());
                FlowerPotProperties.toBlock(itemStack).func_149734_b(world, x, y, z, random);
                TE.restoreMetadata();
            }
            if (TE.hasAttribute((byte)23)) {
                itemStack = TE.getAttribute((byte)23);
                TE.setMetadata(itemStack.func_77960_j());
                BlockProperties.toBlock(itemStack).func_149734_b(world, x, y, z, random);
                TE.restoreMetadata();
            }
        }
        super.func_149734_b(world, x, y, z, random);
    }

    @Override
    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = super.getDrops(world, x, y, z, metadata, fortune);
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null) {
            if (TE.hasAttribute((byte)24)) {
                ret.add(TE.getAttribute((byte)24));
            }
            if (TE.hasAttribute((byte)22)) {
                ret.add(TE.getAttribute((byte)22));
            }
            if (TE.hasAttribute((byte)23)) {
                ret.add(TE.getAttribute((byte)23));
            }
        }
        return ret;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TECarpentersFlowerPot();
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersFlowerPotRenderID;
    }
}

