/*
 * Decompiled with CFR 0.152.
 */
package portablejim.veinminer.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import portablejim.veinminer.configuration.ConfigurationSettings;
import portablejim.veinminer.configuration.ConfigurationValues;
import portablejim.veinminer.core.MinerInstance;
import portablejim.veinminer.util.PlayerStatus;
import portablejim.veinminer.util.Point;

public class MinerServer {
    public static MinerServer instance;
    private HashSet<MinerInstance> minerInstances;
    private HashSet<UUID> clientPlayers;
    private HashMap<UUID, PlayerStatus> players;
    private ConfigurationSettings settings;

    public MinerServer(ConfigurationValues configValues) {
        instance = this;
        this.minerInstances = new HashSet();
        this.clientPlayers = new HashSet();
        this.players = new HashMap();
        this.settings = new ConfigurationSettings(configValues);
    }

    public void setPlayerStatus(UUID player, PlayerStatus status) {
        this.players.put(player, status);
    }

    public PlayerStatus getPlayerStatus(UUID player) {
        if (this.players.containsKey(player)) {
            return this.players.get(player);
        }
        return PlayerStatus.INACTIVE;
    }

    public void addEntity(Entity entity) {
        int eX = (int)Math.floor(entity.field_70165_t);
        int eY = (int)Math.floor(entity.field_70163_u);
        int eZ = (int)Math.floor(entity.field_70161_v);
        Point p = new Point(eX, eY, eZ);
        if (!EntityItem.class.isInstance(entity)) {
            return;
        }
        EntityItem entityItem = (EntityItem)entity;
        for (MinerInstance minerInstance : this.minerInstances) {
            if (!minerInstance.isRegistered(p)) continue;
            minerInstance.addDrop(entityItem);
        }
    }

    public void addInstance(MinerInstance ins) {
        this.minerInstances.add(ins);
    }

    public void removeInstance(MinerInstance ins) {
        this.minerInstances.remove(ins);
    }

    public ConfigurationSettings getConfigurationSettings() {
        return this.settings;
    }

    public boolean playerHasClient(UUID playerName) {
        return this.clientPlayers.contains(playerName);
    }

    public void addClientPlayer(UUID playerName) {
        this.clientPlayers.add(playerName);
        this.setPlayerStatus(playerName, PlayerStatus.INACTIVE);
    }

    public void removeClientPlayer(UUID playerName) {
        this.clientPlayers.remove(playerName);
    }
}

