/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.renderers;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.renderers.TileEntityBlockSkullRenderer;
import ganymedes01.headcrumbs.utils.TextureUtils;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ItemSkullRender
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack stack, Object ... data) {
        boolean isVanilla;
        int skullType = stack.func_77960_j();
        if (skullType < 0 || skullType >= SkullTypes.values().length) {
            return;
        }
        GameProfile profile = null;
        boolean bl = isVanilla = stack.func_77973_b() == Items.field_151144_bL;
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_150297_b("SkullOwner", 10)) {
                profile = NBTUtil.func_152459_a((NBTTagCompound)stack.func_77978_p().func_74775_l("SkullOwner"));
            } else if (stack.func_77978_p().func_150297_b("SkullOwner", 8)) {
                String username = stack.func_77978_p().func_74779_i("SkullOwner");
                profile = TextureUtils.profiles.containsKey(username) ? TextureUtils.profiles.get(username) : new GameProfile(null, username);
                if (isVanilla) {
                    skullType = SkullTypes.player.ordinal();
                    isVanilla = false;
                }
            }
        }
        if (!isVanilla) {
            switch (SkullTypes.values()[skullType]) {
                case witch: 
                case wildDeer: 
                case horseBlack: 
                case horseBrown: 
                case horseChestnut: 
                case horseCreamy: 
                case horseDarkBrown: 
                case horseGrey: 
                case horseWhite: 
                case donkey: 
                case mule: 
                case horseUndead: 
                case horseSkeleton: {
                    GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
                    GL11.glTranslated((double)0.0, (double)-0.45, (double)0.0);
                    break;
                }
                case enderDragon: 
                case pinchBeetle: {
                    GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
                    break;
                }
                case mistWolf: 
                case winterWolf: {
                    GL11.glTranslated((double)0.0, (double)-0.25, (double)0.0);
                    break;
                }
            }
        }
        switch (type) {
            case ENTITY: {
                this.renderSkull(-0.25f, -0.5f, -0.5f, skullType, profile, isVanilla);
                break;
            }
            case EQUIPPED: {
                this.renderSkull(0.5f, 0.0f, 0.0f, skullType, profile, isVanilla);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderSkull(0.75f, 0.25f, 0.4f, skullType, profile, isVanilla);
                break;
            }
            case INVENTORY: {
                GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
                this.renderSkull(0.75f, 0.3f, 0.5f, skullType, profile, isVanilla);
                break;
            }
        }
    }

    private void renderSkull(float x, float y, float z, int type, GameProfile name, boolean isVanilla) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        if (isVanilla) {
            TileEntitySkullRenderer.field_147536_b.func_152674_a(0.0f, 0.0f, 0.0f, 0, 0.0f, type, name);
        } else {
            TileEntityBlockSkullRenderer.instance.renderHead(0.0f, 0.0f, 0.0f, 0, 0.0f, type, name);
        }
        GL11.glPopMatrix();
    }
}

