/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.libs;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Loader;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.utils.TextureUtils;
import ganymedes01.headcrumbs.utils.Utils;
import ganymedes01.headcrumbs.utils.helpers.LycanitesHelperClient;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public enum SkullTypes {
    player(null, null),
    blaze("textures/entity/blaze"),
    enderman("textures/entity/enderman/enderman"),
    pigman("textures/entity/zombie_pigman"),
    spider("textures/entity/spider/spider"),
    caveSpider("textures/entity/spider/cave_spider"),
    pig("textures/entity/pig/pig"),
    cow("textures/entity/cow/cow"),
    mooshroom("textures/entity/cow/mooshroom"),
    sheep("textures/entity/sheep/sheep"),
    wolf("textures/entity/wolf/wolf"),
    villager("textures/entity/villager/villager"),
    chicken("textures/entity/chicken"),
    witch("textures/entity/witch"),
    zombieVillager("textures/entity/zombie/zombie_villager"),
    ironGolem("textures/entity/iron_golem"),
    squid("textures/entity/squid"),
    wither("textures/entity/wither/wither"),
    bunnyDutch("twilightforest:textures/model/bunnydutch", "TwilightForest"),
    penguin("twilightforest:textures/model/penguin", "TwilightForest"),
    bighorn("twilightforest:textures/model/bighorn", "TwilightForest"),
    wildDeer("twilightforest:textures/model/wilddeer", "TwilightForest"),
    wildBoar("twilightforest:textures/model/wildboar", "TwilightForest"),
    redcap("twilightforest:textures/model/redcap", "TwilightForest"),
    druid("twilightforest:textures/model/skeletondruid", "TwilightForest"),
    hedgeSpider("twilightforest:textures/model/hedgespider", "TwilightForest"),
    ghast("textures/entity/ghast/ghast"),
    blizz("thermalfoundation:textures/entity/Blizz", "ThermalFoundation"),
    mistWolf("twilightforest:textures/model/mistwolf", "TwilightForest"),
    miniGhast("twilightforest:textures/model/towerghast", "TwilightForest"),
    guardGhast("twilightforest:textures/model/towerghast_openeyes", "TwilightForest"),
    kingSpider("twilightforest:textures/model/kingspider", "TwilightForest"),
    kobold("twilightforest:textures/model/kobold", "TwilightForest"),
    slimeBeetle("twilightforest:textures/model/slimebeetle", "TwilightForest"),
    fireBeetle("twilightforest:textures/model/firebeetle", "TwilightForest"),
    pinchBeetle("twilightforest:textures/model/pinchbeetle", "TwilightForest"),
    towerGolem("twilightforest:textures/model/carminitegolem", "TwilightForest"),
    enderDragon("textures/entity/enderdragon/dragon"),
    hostileWolf("textures/entity/wolf/wolf_angry", "TwilightForest"),
    bunnyBrown("twilightforest:textures/model/bunnybrown", "TwilightForest"),
    bunnyWhite("twilightforest:textures/model/bunnywhite", "TwilightForest"),
    squirrel("twilightforest:textures/model/squirrel2", "TwilightForest"),
    ocelot("textures/entity/cat/ocelot"),
    ocelotBlack("textures/entity/cat/black"),
    ocelotRed("textures/entity/cat/red"),
    ocelotSiamese("textures/entity/cat/siamese"),
    bat("textures/entity/bat"),
    slime("textures/entity/slime/slime"),
    magmaCube("textures/entity/slime/magmacube"),
    horseBlack("textures/entity/horse/horse_black"),
    horseBrown("textures/entity/horse/horse_brown"),
    horseChestnut("textures/entity/horse/horse_chestnut"),
    horseCreamy("textures/entity/horse/horse_creamy"),
    horseDarkBrown("textures/entity/horse/horse_darkbrown"),
    horseGrey("textures/entity/horse/horse_gray"),
    horseWhite("textures/entity/horse/horse_white"),
    donkey("textures/entity/horse/donkey"),
    mule("textures/entity/horse/mule"),
    horseUndead("textures/entity/horse/horse_zombie"),
    horseSkeleton("textures/entity/horse/horse_skeleton"),
    snowMan("textures/entity/snowman"),
    silverfish("textures/entity/silverfish"),
    swarmSpider("twilightforest:textures/model/swarmspider", "TwilightForest"),
    towerBroodling("twilightforest:textures/model/towerbroodling", "TwilightForest"),
    winterWolf("twilightforest:textures/model/winterwolf", "TwilightForest"),
    mazeSlime("twilightforest:textures/model/mazeslime", "TwilightForest"),
    towerwoodBorer("twilightforest:textures/model/towertermite", "TwilightForest"),
    imp("natura:textures/mob/imp", "Natura"),
    nitroCreeper("natura:textures/mob/creeperunstable", "Natura"),
    heatscarSpider("natura:textures/mob/flamespider", "Natura"),
    angryZombie("thaumcraft:textures/models/bzombievil", "Thaumcraft"),
    fireBat("thaumcraft:textures/models/firebat", "Thaumcraft"),
    thaumicSlime("thaumcraft:textures/models/tslime", "Thaumcraft"),
    taintedChicken("thaumcraft:textures/models/chicken", "Thaumcraft"),
    taintedCow("thaumcraft:textures/models/cow", "Thaumcraft"),
    taintedPig("thaumcraft:textures/models/pig", "Thaumcraft"),
    taintedCreeper("thaumcraft:textures/models/creeper", "Thaumcraft"),
    taintedVillager("thaumcraft:textures/models/villager", "Thaumcraft"),
    taintedSheep("thaumcraft:textures/models/sheep", "Thaumcraft"),
    pech("thaumcraft:textures/models/pech_forage", "Thaumcraft"),
    eldritchGuardian("thaumcraft:textures/models/eldritch_guardian", "Thaumcraft"),
    lycanites(""),
    pinky("demonmobs:textures/entity/pinky", "lycanitesmobs"),
    behemoth("demonmobs:textures/entity/behemoth", "lycanitesmobs"),
    belph("demonmobs:textures/entity/belph", "lycanitesmobs");

    private final String mod;
    private final ResourceLocation texture;
    private static final ResourceLocation ENDERMAN_EYES;
    private static final ResourceLocation SHEEP_FUR_HEAD;
    private static final ResourceLocation ENDER_DRAGON_EYES;
    private static final ResourceLocation SPIDER_EYES;
    private static final ResourceLocation TAINTED_SHEEP_FUR_HEAD;

    private SkullTypes(String texture, String mod) {
        this.mod = mod;
        this.texture = Utils.getResource(texture + ".png");
    }

    private SkullTypes(String texture) {
        this(texture, null);
    }

    public boolean canShow() {
        return this != player && !Headcrumbs.enableMobsAndAnimalHeads ? false : this.mod == null || Loader.isModLoaded((String)this.mod);
    }

    public ResourceLocation getTexture(GameProfile name) {
        if (this == player) {
            return TextureUtils.getPlayerSkin(name);
        }
        if (this == lycanites) {
            return LycanitesHelperClient.getTexture(name.getName());
        }
        return this.texture;
    }

    public ResourceLocation getSecondTexture() {
        switch (this) {
            case enderman: {
                return ENDERMAN_EYES;
            }
            case sheep: 
            case bighorn: {
                return SHEEP_FUR_HEAD;
            }
            case enderDragon: {
                return ENDER_DRAGON_EYES;
            }
            case mooshroom: {
                return TextureMap.field_110575_b;
            }
            case spider: 
            case caveSpider: 
            case hedgeSpider: 
            case kingSpider: 
            case swarmSpider: 
            case towerBroodling: 
            case heatscarSpider: {
                return SPIDER_EYES;
            }
            case taintedSheep: {
                return TAINTED_SHEEP_FUR_HEAD;
            }
        }
        return null;
    }

    static {
        ENDERMAN_EYES = Utils.getResource("textures/entity/enderman/enderman_eyes.png");
        SHEEP_FUR_HEAD = Utils.getResource("textures/entity/sheep/sheep_fur.png");
        ENDER_DRAGON_EYES = Utils.getResource("textures/entity/enderdragon/dragon_eyes.png");
        SPIDER_EYES = Utils.getResource("textures/entity/spider_eyes.png");
        TAINTED_SHEEP_FUR_HEAD = Utils.getResource("thaumcraft:textures/models/sheep_fur.png");
    }
}

