/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.entity;

import com.google.common.reflect.ClassPath;
import ganymedes01.headcrumbs.entity.EntityCelebrity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class VIPHandler {
    private static final VIPHandler DEFAULT = new VIPHandler(0);
    private static final Map<String, VIPHandler> handlers = new HashMap<String, VIPHandler>();

    public static VIPHandler getHandler(String name) {
        if (handlers.containsKey(name)) {
            return handlers.get(name);
        }
        return DEFAULT;
    }

    public VIPHandler() {
        handlers.put(this.getClass().getSimpleName(), this);
    }

    private VIPHandler(int i) {
    }

    public void dropItems(EntityCelebrity entity, int looting) {
        int amount = this.minDropAmount() + entity.func_70681_au().nextInt(this.maxBaseDropAmount());
        if (looting > 0) {
            amount += entity.func_70681_au().nextInt(looting + 1);
        }
        amount = Math.min(this.maxDropAmount(), amount);
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = this.getItem(entity);
            if (stack == null) continue;
            entity.func_70099_a(stack, 0.0f);
        }
    }

    public void dropRare(EntityCelebrity entity, int looting) {
    }

    protected int minDropAmount() {
        return 0;
    }

    protected int maxDropAmount() {
        return Integer.MAX_VALUE;
    }

    protected int maxBaseDropAmount() {
        return 3;
    }

    protected ItemStack getItem(EntityCelebrity entity) {
        return entity.func_70681_au().nextBoolean() ? new ItemStack(Items.field_151103_aS) : new ItemStack(Items.field_151078_bh);
    }

    public void onSpawn(EntityCelebrity entity) {
    }

    public String livingSound() {
        return null;
    }

    protected String hurtSound() {
        return "game.hostile.hurt";
    }

    protected String deathSound() {
        return "game.hostile.die";
    }

    public static void init() {
        try {
            for (ClassPath.ClassInfo clazzInfo : ClassPath.from((ClassLoader)VIPHandler.class.getClassLoader()).getTopLevelClasses(VIPHandler.class.getPackage().getName() + ".vip")) {
                Class clazz = clazzInfo.load();
                if (clazz == VIPHandler.class || !VIPHandler.class.isAssignableFrom(clazz)) continue;
                clazz.newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

