/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.library.entity.ProjectileBase;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.util.PiercingArrowDamage;

public class ArrowEntity
extends ProjectileBase {
    public ArrowEntity(World world) {
        super(world);
    }

    public ArrowEntity(World world, double d, double d1, double d2) {
        super(world, d, d1, d2);
    }

    public ArrowEntity(World world, EntityPlayer player, float speed, float accuracy, ItemStack stack) {
        super(world, player, speed, accuracy, stack);
    }

    @Override
    protected double getStuckDepth() {
        return 0.25;
    }

    @Override
    protected double getSlowdown() {
        return super.getSlowdown();
    }

    @Override
    protected double getGravity() {
        float mass = this.returnStack.func_77978_p().func_74775_l("InfiTool").func_74760_g("Mass");
        return mass /= 36.0f;
    }

    @Override
    public void onHitBlock(MovingObjectPosition movingobjectposition) {
        super.onHitBlock(movingobjectposition);
        if (this.defused) {
            return;
        }
        float chance = this.returnStack.func_77978_p().func_74775_l("InfiTool").func_74760_g("BreakChance");
        if (chance > TConstruct.random.nextFloat()) {
            this.func_70106_y();
            this.func_85030_a("random.break", 1.0f, 1.5f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
        }
    }

    @Override
    protected void playHitBlockSound(int x, int y, int z) {
        this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    @Override
    protected void playHitEntitySound() {
        this.func_85030_a("random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
    }

    @Override
    public boolean dealDamage(float damage, ToolCore ammo, NBTTagCompound tags, Entity entityHit) {
        boolean dealtDamage = false;
        float shift = (tags.func_74760_g("Mass") - 0.7f) * this.armorPenetrationModifier();
        if (shift < 0.0f) {
            shift = 0.0f;
        }
        if (shift > damage) {
            shift = damage;
        }
        if ((damage -= shift) > 0.0f) {
            dealtDamage = super.dealDamage(damage, ammo, tags, entityHit);
        }
        if (shift > 0.0f) {
            PiercingArrowDamage damagesource = this.field_70250_c == null ? new PiercingArrowDamage("arrow", (Entity)this, (Entity)this) : new PiercingArrowDamage("arrow", (Entity)this, this.field_70250_c);
            entityHit.func_70097_a((DamageSource)damagesource, shift);
        }
        return dealtDamage;
    }

    protected float armorPenetrationModifier() {
        return 1.0f;
    }
}

