/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.weaponry;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.event.ToolBuildEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.DualMaterialToolPart;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.weaponry.ArrowShaftMaterial;
import tconstruct.library.weaponry.BowBaseAmmo;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.tools.TinkerTools;
import tconstruct.weaponry.TinkerWeaponry;
import tconstruct.weaponry.ammo.ArrowAmmo;
import tconstruct.weaponry.ammo.BoltAmmo;
import tconstruct.weaponry.weapons.Crossbow;
import tconstruct.weaponry.weapons.LongBow;
import tconstruct.weaponry.weapons.ShortBow;

public class WeaponryHandler {
    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        if (!event.player.field_70170_p.field_72995_K && item == Item.func_150898_a((Block)TinkerTools.toolStationWood)) {
            TPlayerStats stats = TPlayerStats.get(event.player);
            if (!stats.weaponryManual) {
                stats.weaponryManual = true;
                AbilityHelper.spawnItemAtPlayer(event.player, new ItemStack(TinkerTools.manualBook, 1, 4));
            }
        }
    }

    @SubscribeEvent
    public void onAmmoCrafted(ToolCraftEvent.NormalTool event) {
        if (!(event.tool instanceof IAmmo)) {
            return;
        }
        NBTTagCompound tags = event.toolTag.func_74775_l("InfiTool");
        if (event.tool instanceof ArrowAmmo) {
            ToolMaterial head = TConstructRegistry.getMaterial(tags.func_74762_e("Head"));
            ArrowMaterial arrow = TConstructRegistry.getArrowMaterial(tags.func_74762_e("Head"));
            ArrowShaftMaterial shaft = (ArrowShaftMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Handle"), ArrowShaftMaterial.class);
            FletchingMaterial fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), FletchingMaterial.class);
            if (fletching == null) {
                fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), FletchlingLeafMaterial.class);
            }
            if (arrow == null || shaft == null || fletching == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            int durability = (int)((float)head.durability() * shaft.durabilityModifier * fletching.durabilityModifier);
            float weight = arrow.mass + shaft.weight;
            float accuracy = fletching.accuracy;
            float breakChance = shaft.fragility * arrow.breakChance + fletching.breakChance;
            this.setAmmoData(tags, durability, weight, breakChance, accuracy, head.shoddy(), head.reinforced());
            if (tags.func_74762_e("Handle") == 3) {
                tags.func_74768_a("Fiery", 5);
            }
            int mods = Math.max(0, tags.func_74762_e("Modifiers") - 1);
            tags.func_74768_a("Modifiers", mods);
        } else if (event.tool instanceof BoltAmmo) {
            ToolMaterial headMat = TConstructRegistry.getMaterial(tags.func_74762_e("Head"));
            ToolMaterial coreMat = TConstructRegistry.getMaterial(tags.func_74762_e("Handle"));
            ArrowMaterial head = TConstructRegistry.getArrowMaterial(tags.func_74762_e("Head"));
            ArrowMaterial core = TConstructRegistry.getArrowMaterial(tags.func_74762_e("Handle"));
            FletchingMaterial fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), FletchingMaterial.class);
            if (fletching == null) {
                fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), FletchlingLeafMaterial.class);
            }
            if (head == null || core == null || fletching == null) {
                event.setResult(Event.Result.DENY);
                return;
            }
            int durability = (int)((float)headMat.durability() * coreMat.handleDurability() * fletching.durabilityModifier);
            float weight = head.mass + core.mass * 1.5f;
            float accuracy = (100.0f + fletching.accuracy) / 2.0f;
            float breakChance = (fletching.breakChance * 2.0f + 0.15f * core.breakChance) * head.breakChance / 2.0f;
            float shoddy = (headMat.shoddy() + coreMat.shoddy()) / 2.0f;
            int reinforced = Math.max(headMat.reinforced(), coreMat.reinforced());
            this.setAmmoData(tags, durability, weight, breakChance, accuracy, shoddy, reinforced);
            int mods = Math.max(0, tags.func_74762_e("Modifiers") - 1);
            tags.func_74768_a("Modifiers", mods);
        }
        IAmmo ammoItem = (IAmmo)((Object)event.tool);
        tags.func_74768_a("Ammo", ammoItem.getMaxAmmo(tags));
    }

    @SubscribeEvent
    public void onProjectileWeaponCrafted(ToolCraftEvent.NormalTool event) {
        if (!(event.tool instanceof ProjectileWeapon)) {
            return;
        }
        NBTTagCompound tags = event.toolTag.func_74775_l("InfiTool");
        ProjectileWeapon weapon = (ProjectileWeapon)event.tool;
        int drawSpeed = 0;
        float flightSpeed = 0.0f;
        boolean enchanted = false;
        if (event.tool instanceof BowBaseAmmo) {
            BowMaterial top = TConstructRegistry.getBowMaterial(tags.func_74762_e("Head"));
            BowMaterial bottom = TConstructRegistry.getBowMaterial(tags.func_74762_e("Accessory"));
            BowstringMaterial string = (BowstringMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Handle"), BowstringMaterial.class);
            drawSpeed = (int)((float)(top.drawspeed + bottom.drawspeed) / 2.0f * string.drawspeedModifier);
            flightSpeed = (top.flightSpeedMax + bottom.flightSpeedMax) / 2.0f * string.flightSpeedModifier;
            if (event.tool instanceof ShortBow) {
                drawSpeed = (int)((double)drawSpeed * 0.9);
            }
            if (event.tool instanceof LongBow) {
                drawSpeed = (int)((float)drawSpeed * 1.8f);
                flightSpeed *= 1.5f;
            }
            enchanted = tags.func_74762_e("Handle") == 1;
        } else if (event.tool instanceof Crossbow) {
            BowMaterial top = TConstructRegistry.getBowMaterial(tags.func_74762_e("Head"));
            BowstringMaterial string = (BowstringMaterial)TConstructRegistry.getCustomMaterial(tags.func_74762_e("Accessory"), BowstringMaterial.class);
            drawSpeed = (int)((float)top.drawspeed * string.drawspeedModifier);
            flightSpeed = top.flightSpeedMax * string.flightSpeedModifier;
            drawSpeed = (int)((float)drawSpeed * 2.5f);
            drawSpeed = (int)((float)drawSpeed - (float)drawSpeed * 0.25f);
            flightSpeed = (float)((double)flightSpeed * 1.5);
            enchanted = tags.func_74762_e("Accessory") == 1;
        } else {
            return;
        }
        if (enchanted) {
            int modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", ++modifiers);
        }
        tags.func_74768_a("DrawSpeed", drawSpeed);
        tags.func_74768_a("BaseDrawSpeed", drawSpeed);
        tags.func_74776_a("FlightSpeed", flightSpeed);
    }

    @SubscribeEvent
    public void buildArrow(ToolBuildEvent event) {
        if (event.headStack == null || event.handleStack == null || event.accessoryStack == null) {
            return;
        }
        CustomMaterial mat = TConstructRegistry.getCustomMaterial(event.handleStack, ArrowShaftMaterial.class);
        if (mat == null) {
            return;
        }
        Item extra = event.extraStack != null ? event.extraStack.func_77973_b() : null;
        ToolCore tool = ToolBuilder.instance.getMatchingRecipe(event.headStack.func_77973_b(), mat.craftingItem.func_77973_b(), event.accessoryStack.func_77973_b(), extra);
        if (tool == TinkerWeaponry.arrowAmmo) {
            event.handleStack = mat.craftingItem.func_77946_l();
        }
    }

    @SubscribeEvent
    public void buildBolt(ToolBuildEvent event) {
        if (event.headStack == null || event.handleStack == null) {
            return;
        }
        if (event.headStack.func_77973_b() != TinkerWeaponry.partBolt) {
            return;
        }
        ItemStack bolt1 = event.headStack.func_77946_l();
        ItemStack bolt2 = event.headStack;
        ItemStack fletching = event.handleStack;
        DualMaterialToolPart dualPart = (DualMaterialToolPart)bolt2.func_77973_b();
        bolt1.func_77964_b(dualPart.getMaterialID2(bolt1));
        event.headStack = bolt1;
        event.handleStack = bolt2;
        event.accessoryStack = fletching;
    }

    private void setAmmoData(NBTTagCompound tags, int durability, float weight, float breakChance, float accuracy, float shoddy, int reinforced) {
        tags.func_74768_a("TotalDurability", durability);
        tags.func_74768_a("BaseDurability", durability);
        tags.func_74776_a("Mass", weight);
        tags.func_74776_a("BreakChance", breakChance);
        tags.func_74776_a("Accuracy", accuracy);
        tags.func_74776_a("Shoddy", shoddy);
        tags.func_74768_a("Unbreaking", reinforced);
    }
}

