/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util;

import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.tools.DynamicToolPart;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IPattern;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.tools.TinkerTools;

public final class IMCHandler {
    private IMCHandler() {
    }

    public static void processIMC(List<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            NBTTagCompound tag;
            String type = message.key;
            if (type == null || type.isEmpty()) continue;
            if (type.equals("addMaterial")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                ToolMaterial mat = IMCHandler.scanMaterial(tag);
                if (mat == null) continue;
                TConstructRegistry.addtoolMaterial(tag.func_74762_e("Id"), mat);
                TConstructRegistry.addDefaultToolPartMaterial(tag.func_74762_e("Id"));
                TConstruct.logger.info("IMC: Added material " + mat.materialName);
                continue;
            }
            if (type.equals("addPartBuilderMaterial")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (!IMCHandler.checkRequiredTags("PartBuilder", tag, "MaterialId", "Item", "Value")) continue;
                int matID = tag.func_74762_e("MaterialId");
                int value = tag.func_74762_e("Value");
                if (TConstructRegistry.getMaterial(matID) == null) {
                    TConstruct.logger.error("PartBuilder IMC: Unknown Material ID " + matID);
                    continue;
                }
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Item"));
                ItemStack shard = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Shard"));
                ItemStack rod = new ItemStack(TinkerTools.toolRod, 1, matID);
                if (shard == null) {
                    TConstructRegistry.addDefaultShardMaterial(matID);
                    shard = new ItemStack(TinkerTools.toolShard, 1, matID);
                }
                PatternBuilder.instance.registerFullMaterial(item, value, TConstructRegistry.getMaterial((int)matID).materialName, shard, rod, matID);
                LinkedList<Item> addItems = new LinkedList<Item>();
                LinkedList<Integer> addMetas = new LinkedList<Integer>();
                LinkedList<ItemStack> addOUtputs = new LinkedList<ItemStack>();
                for (Map.Entry<List, ItemStack> mappingEntry : TConstructRegistry.patternPartMapping.entrySet()) {
                    List mapping = mappingEntry.getKey();
                    if ((Integer)mapping.get(2) != 1 || !(mappingEntry.getValue().func_77973_b() instanceof DynamicToolPart)) continue;
                    Item woodPattern = (Item)mapping.get(0);
                    Integer meta = (Integer)mapping.get(1);
                    ItemStack output = mappingEntry.getValue().func_77946_l();
                    output.func_77964_b(matID);
                    addItems.add(woodPattern);
                    addMetas.add(meta);
                    addOUtputs.add(output);
                }
                for (int i = 0; i < addItems.size(); ++i) {
                    TConstructRegistry.addPartMapping((Item)addItems.get(i), (Integer)addMetas.get(i), matID, (ItemStack)addOUtputs.get(i));
                }
                TConstruct.logger.info("PartBuilder IMC: Added Part builder ampping for " + TConstructRegistry.getMaterial((int)matID).materialName);
                continue;
            }
            if (type.equals("addPartCastingMaterial")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (!IMCHandler.checkRequiredTags("Castingt", tag, "MaterialId", "FluidName")) continue;
                if (!tag.func_74764_b("MaterialId")) {
                    TConstruct.logger.error("Casting IMC: Not material ID for the result present");
                    continue;
                }
                int matID = tag.func_74762_e("MaterialId");
                FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                if (liquid == null) {
                    TConstruct.logger.error("Casting IMC: No fluid found");
                    continue;
                }
                LinkedList<CastingRecipe> newRecipies = new LinkedList<CastingRecipe>();
                for (CastingRecipe recipe : TConstructRegistry.getTableCasting().getCastingRecipes()) {
                    if (recipe.castingMetal.getFluid() != TinkerSmeltery.moltenIronFluid || recipe.cast == null || !(recipe.cast.func_77973_b() instanceof IPattern) || !(recipe.getResult().func_77973_b() instanceof DynamicToolPart)) continue;
                    newRecipies.add(recipe);
                }
                for (CastingRecipe recipe : newRecipies) {
                    ItemStack output = recipe.getResult().func_77946_l();
                    output.func_77964_b(matID);
                    FluidStack liquid2 = new FluidStack(liquid, recipe.castingMetal.amount);
                    TConstructRegistry.getTableCasting().addCastingRecipe(output, liquid2, recipe.cast, recipe.consumeCast, recipe.coolTime);
                }
                TConstruct.logger.info("Casting IMC: Added fluid " + tag.func_74779_i("FluidName") + " to part casting");
                continue;
            }
            if (type.equals("addSmelteryMelting")) {
                if (!message.isNBTMessage()) {
                    IMCHandler.logInvalidMessage(message);
                    continue;
                }
                tag = message.getNBTValue();
                if (!IMCHandler.checkRequiredTags("Smeltery", tag, "FluidName", "Temperature", "Item", "Block")) continue;
                FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                if (liquid == null) {
                    TConstruct.logger.error("Smeltery IMC: No fluid found");
                    continue;
                }
                if (liquid.amount <= 0) {
                    TConstruct.logger.error("Smeltery IMC: Liquid has to have an amount greater than zero");
                    continue;
                }
                ItemStack item = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Item"));
                ItemStack block = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("Block"));
                int temperature = tag.func_74762_e("Temperature");
                Smeltery.addMelting(item, Block.func_149634_a((Item)block.func_77973_b()), block.func_77960_j(), temperature, liquid);
                TConstruct.logger.info("Smeltery IMC: Added melting: " + item.func_82833_r() + " to " + liquid.amount + "mb " + liquid.getLocalizedName());
                continue;
            }
            if (!type.equals("addSmelteryFuel")) continue;
            if (!message.isNBTMessage()) {
                IMCHandler.logInvalidMessage(message);
                continue;
            }
            tag = message.getNBTValue();
            if (!IMCHandler.checkRequiredTags("Smeltery", tag, "FluidName", "Temperature", "Duration")) continue;
            FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
            if (liquid == null) {
                TConstruct.logger.error("Smeltery IMC: No fluid found");
                continue;
            }
            int temperature = tag.func_74762_e("Temperature");
            int duration = tag.func_74762_e("Duration");
            Smeltery.addSmelteryFuel(liquid.getFluid(), temperature, duration);
            TConstruct.logger.info("Smeltery IMC: Added fuel: " + liquid.getLocalizedName() + " (" + temperature + ", " + duration + ")");
        }
    }

    private static boolean checkRequiredTags(String prefix, NBTTagCompound tag, String ... tags) {
        boolean ok = true;
        for (String t : tags) {
            if (tag.func_74764_b(t)) continue;
            TConstruct.logger.error(String.format("%s IMC: Missing required NBT Tag %s", prefix, t));
            ok = false;
        }
        return ok;
    }

    private static void logInvalidMessage(FMLInterModComms.IMCMessage message) {
        TConstruct.logger.error(String.format("Received invalid IMC '%s' from %s. Not a NBT Message.", message.key, message.getSender()));
    }

    private static ToolMaterial scanMaterial(NBTTagCompound tag) {
        if (!tag.func_74764_b("Name")) {
            TConstruct.logger.error("Material IMC: Material has no name");
            return null;
        }
        String name = tag.func_74779_i("Name");
        if (!tag.func_74764_b("Id")) {
            TConstruct.logger.error("Material IMC: Materials need a unique id. " + name);
            return null;
        }
        if (!tag.func_74764_b("Durability")) {
            TConstruct.logger.error("Material IMC: Materials need a durability. " + name);
            return null;
        }
        if (!tag.func_74764_b("MiningSpeed")) {
            TConstruct.logger.error("Material IMC: Materials need a mining speed. " + name);
            return null;
        }
        if (tag.func_74764_b("Stonebound") && tag.func_74764_b("Jagged")) {
            TConstruct.logger.error("Material IMC: Materials can only be Stonebound or Jagged. " + name);
            return null;
        }
        int hlvl = tag.func_74762_e("HarvestLevel");
        int durability = tag.func_74762_e("Durability");
        int speed = tag.func_74762_e("MiningSpeed");
        int attack = tag.func_74762_e("Attack");
        float handle = tag.func_74760_g("HandleModifier");
        int reinforced = tag.func_74762_e("Reinforced");
        float shoddy = tag.func_74760_g("Stonebound");
        String style = tag.func_74779_i("Style");
        int color = tag.func_74762_e("Color");
        if (tag.func_74764_b("Jagged")) {
            shoddy = -tag.func_74760_g("Jagged");
        }
        if (tag.func_74764_b("localizationString")) {
            return new ToolMaterial(name, tag.func_74779_i("localizationString"), hlvl, durability, speed, attack, handle, reinforced, shoddy, style, color);
        }
        return new ToolMaterial(name, hlvl, durability, speed, attack, handle, reinforced, shoddy, style, color);
    }
}

