/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.model;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import tconstruct.client.BlockSkinRenderHelper;
import tconstruct.smeltery.logic.LavaTankLogic;
import tconstruct.util.ItemHelper;

public class TankRender
implements ISimpleBlockRenderingHandler {
    public static int tankModelID = RenderingRegistry.getNextAvailableRenderId();
    public static int renderPass = 0;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == tankModelID) {
            ItemHelper.renderStandardInvBlock(renderer, block, metadata);
            if (metadata == 0) {
                renderer.func_147782_a(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
                this.renderDoRe(renderer, block, metadata);
            }
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == tankModelID) {
            if (renderPass == 0) {
                LavaTankLogic logic = (LavaTankLogic)world.func_147438_o(x, y, z);
                if (logic.containsFluid()) {
                    FluidStack liquid = logic.tank.getFluid();
                    renderer.func_147782_a(0.001, 0.001, 0.001, 0.999, (double)logic.getFluidAmountScaled(), 0.999);
                    Fluid fluid = liquid.getFluid();
                    BlockSkinRenderHelper.renderLiquidBlock(fluid.getStillIcon(), fluid.getStillIcon(), x, y, z, renderer, world, false, fluid.getColor(liquid));
                    renderer.func_147782_a(0.0, 0.001, 0.001, 0.999, (double)logic.getFluidAmountScaled(), 0.999);
                }
            } else {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 0 && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a) {
                    renderer.func_147782_a(0.1875, 0.0, 0.1875, 0.8125, 0.125, 0.8125);
                    renderer.func_147784_q(block, x, y + 1, z);
                }
                renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                renderer.func_147784_q(block, x, y, z);
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public int getRenderId() {
        return tankModelID;
    }

    private void renderDoRe(RenderBlocks renderblocks, Block block, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderblocks.func_147768_a(block, 0.0, 0.0, 0.0, block.func_149691_a(0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderblocks.func_147806_b(block, 0.0, 0.0, 0.0, block.func_149691_a(1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderblocks.func_147761_c(block, 0.0, 0.0, 0.0, block.func_149691_a(2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderblocks.func_147734_d(block, 0.0, 0.0, 0.0, block.func_149691_a(3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderblocks.func_147798_e(block, 0.0, 0.0, 0.0, block.func_149691_a(4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderblocks.func_147764_f(block, 0.0, 0.0, 0.0, block.func_149691_a(5, meta));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

